#include "qadsl.h"

extern char user[MAXLEN], pass[MAXLEN], serv[MAXLEN], deamon_s[MAXLEN], deamon_t[MAXLEN], deamon_d[MAXLEN];
extern char *conf;

void read_conf()
{
	FILE *fd;
	char input[MAXLEN], tmp[MAXLEN], *p;
	int user_sw=0, host_sw=0, pass_sw=0, dea_s_sw=0, dea_t_sw=0, dea_d_sw=0;

	if((fd=fopen(conf,"r"))==NULL) {
		fprintf(stderr,"Could not open configuration file\n");
		exit(1);
	}

	while((fgets(input, sizeof(input), fd))!= NULL) {
		if ((p = strchr(input, '\n')))
		*p = '\0';

		if((strncmp("SERV=",input,5))== 0) {
			strcpy(serv,input+5);
			host_sw=1; 
		}

		if((strncmp("USER=",input, 5))== 0) {
			strcpy(tmp,input+5);
			url_encode(tmp,user);
			user_sw=1; 
		}	

		if((strncmp("PASS=",input, 5))== 0) {
			strcpy(tmp,input+5);
			url_encode(tmp,pass);
			pass_sw=1; 
		}

		if((strncmp("DEAMON_S=",input, 9))== 0) {
			strcpy(deamon_s,input+9);
			dea_s_sw=1; 
		}

		if((strncmp("DEAMON_T=",input, 9))== 0) {
			strcpy(deamon_t,input+9);
			dea_t_sw=1; 
		}

		if((strncmp("DEAMON_D=",input, 9))== 0) {
			strcpy(deamon_d,input+9);
			dea_d_sw=1; 
		}

	}

	if((!user_sw || !pass_sw || !host_sw || !dea_s_sw || !dea_t_sw || !dea_d_sw)) {
		printf("Error found in: %s\n",conf);

		if(!user_sw) { fprintf(stderr,"\tCould not find username!\n"); exit(1); }
		if(!pass_sw) { fprintf(stderr,"\tCould not find password!\n"); exit(1); }
		if(!host_sw) { fprintf(stderr,"\tCould not find login server!\n"); exit(1); }
		if(!dea_s_sw) { fprintf(stderr,"\tCould not find deamon startup choice!\n"); exit(1); }
		if(!dea_t_sw) { fprintf(stderr,"\tCould not find deamon type (LOGIN/PING)!\n"); exit(1); }
			if(!dea_d_sw) { fprintf(stderr,"\tCould not find deamon delay!\n"); exit(1); }

	}
}

