#include "qadsl.h"

extern int login_sw,sockfd,i;
extern char send_msg[MAXDATASIZE], get_msg[MAXDATASIZE];
extern char user[MAXLEN], pass[MAXLEN], serv[MAXLEN], deamon_s[MAXLEN], deamon_t[MAXLEN], deamon_d[MAXLEN];

extern struct hostent *he;
extern struct sockaddr_in address;

int telia_login(int check) 
{
	sprintf(send_msg,"POST /sd/login HTTP/1.0\n" \
	"Referer: http://%s/sd/init\n" \
	"Connection: Keep-Alive\n" \
	"User-Agent: Mozilla/4.73 [en] (X11; U; Linux 2.4.0 i686)\n" \
	"Host: %s\n" \
	"Accept: image/gif, image/x-xbitmap, image/jpeg, " \
	"image/pjpeg, image/png, */*\n" \
	"Accept-Encoding: gzip\n" \
	"Accept-Language: en\n" \
	"Accept-Charset: iso-8859-1,*,utf-8\n" \
	"Content-type: application/x-www-form-urlencoded\n" \
	"Content-length: 58\n\n" \
	"username=%s&password=%s&submitForm=Logga+in\n\n\n\n\n",serv, serv, user, pass);

	send_func(send_msg);

	if((read(sockfd, get_msg, sizeof(get_msg))) == -1) {
		perror("read");
		exit(1);
	}

	sleep(1);

	if(strstr(get_msg, "newPane()") == NULL) {
		if(check) fprintf(stderr,"\tTelia Broadband: LOGIN FAILED\n");
		return 0;	
	} else {
		if(check) printf("\tTelia Broadband: LOGIN SUCCESSFUL\n");
		login_sw=1;
		return 1;
	}
}

void preconnect() 
{
	sprintf(send_msg, "GET /sd/init HTTP/1.0\n" \
	"Referer: http://%s/sd/init\n" \
	"Connection: Keep-Alive\n" \
	"User-Agent: Mozilla/4.73 [en] (X11; U; Linux 2.4.0 i686)\n" \
	"Host: %s\n" \
	"Accept: image/gif, image/x-xbitmap, image/jpeg, " \
	"image/pjpeg, image/png, */*\n" \
	"Accept-Encoding: gzip\n" \
	"Accept-Language: en\n" \
	"Accept-Charset: iso-8859-1,*,utf-8\n\n", serv, serv);

	send_func(send_msg);	
}

void telia_logout() 
{	
	fd_set check_sockfd;
	struct timeval c_tv;
	int retval;

	FD_ZERO(&check_sockfd);
	FD_SET(sockfd, &check_sockfd);

	c_tv.tv_sec = 1;
	c_tv.tv_usec = 0;

	sprintf(send_msg, "GET /sd/logout HTTP/1.0\n" \
	"Referer: http://%s/sd/init\n" \
	"Connection: Keep-Alive\n" \
	"User-Agent: Mozilla/4.73 [en] (X11; U; Linux 2.4.0 i686)\n" \
	"Host: %s\n" \
	"Accept: image/gif, image/x-xbitmap, image/jpeg, " \
	"image/pjpeg, image/png, */*\n" \
	"Accept-Encoding: gzip\n" \
	"Accept-Language: en\n" \
	"Accept-Charset: iso-8859-1,*,utf-8\n\n", serv, serv);

	send_func(send_msg);

	sleep(1);

	if((read(sockfd, get_msg, sizeof(get_msg))) == -1) {
		perror("read");
		exit(1);
	}

	if((retval = select(1, &check_sockfd, NULL, NULL, &c_tv))== -1) {
		fprintf(stderr,"\t/sd/logout doesn't respond, could not log out!\n");
	}

	if(strstr(get_msg, "avslutat") == NULL) {
		fprintf(stderr,"\tTelia Broadband: LOGIN FAILED\n");
		exit(1);
	}

	printf("\tTelia Broadband: SUCCESSFUL LOGOUT\n");
}


void send_func(const char *send_msg_to_server) 
{
	if((send(sockfd, send_msg_to_server, strlen(send_msg_to_server), 0)) == -1) {
		perror("send");
		exit(1);
	}
}

void log_login(int check)
{
        struct tm *timep;
        time_t the_time;

        (void) time(&the_time);
        timep=localtime(&the_time);
	
	if(check) {	
		if(!telia_login(1)) {
			for(i=0; i < 3; i++) {
				close(sockfd);

				if ((sockfd = socket(PF_INET, SOCK_STREAM, 0)) == -1) {
					perror("socket");
					exit(1);
				}

				if (connect(sockfd, (struct sockaddr *)&address, sizeof(address)) == -1) {
					perror("read");
					exit(1);
				}
	
				sleep(5);
		
                                if(telia_login(1)) {
                                        login_sw=1;
                                        break; 
                                }
			}
		}
	} else {
		if(!telia_login(0)) {
			for(i=0; i < 3; i++) {
				close(sockfd);

				if ((sockfd = socket(PF_INET, SOCK_STREAM, 0)) == -1) {
					perror("socket");
					exit(1);
				}

				if (connect(sockfd, (struct sockaddr *)&address, sizeof(address)) == -1) {
					exit(1);
				} 

				sleep(10);

				if(telia_login(0)) {
					login_sw=1;
					break;
				}
 
			}
		}
	}

	if(!login_sw) {
		if(check) fprintf(stderr,"\tTelia Broadband: AVBRYTER !\n");
		openlog("qADSL ", LOG_PID, LOG_USER);
		syslog(LOG_ERR,"Failed to login on telia (%02d:%02d:%02d)\n",timep->tm_hour, timep->tm_min, timep->tm_sec);
		exit(1);
	} else {
                openlog("qADSL ", LOG_PID, LOG_USER);
                syslog(LOG_INFO,"Logged in on Telia (%02d:%02d:%02d)\n",timep->tm_hour, timep->tm_min, timep->tm_sec);
	}
}
