/*
 * To change C++ Comments of style '//' to '/*...*/'
 * 
 * Compiled with
 *     gcc
 *
 *          -[py]
 */
#include <stdio.h>
int main(int argc, char *argv[])
{
    FILE *fp1, *fp2;
    int c, LastC=0, CPPComment = 0, CComment = 0, escape = 0;
    if(argc != 3) {
	fprintf(stderr,"Usage: %s <Cpp file> <C file>\n", argv[0]);
	return -1;
    }
    if( (fp1 = fopen(argv[1], "r")) == NULL ) {
	fprintf(stderr,"Can't open file %s\n", argv[1]);
	return -11;
    }
    if( (fp2 = fopen(argv[2], "w")) == NULL ) {
	fprintf(stderr, "Can't open file %s for writing\n", argv[2]);
	return -1;
    }
    while( (c = fgetc(fp1)) != EOF ) {
	switch(c) {
	case '\n':
	    if(CPPComment) {
		fputc('*', fp2);
		fputc('/', fp2);
		CPPComment = 0;
	    }
	    break;
	case '*':
	    if(CComment || CPPComment) break;
	    if(LastC == '/') CComment = 1;
	    break;
	case '/':
	    if(CComment) {
		if(LastC == '*') {
		    CComment = 0;
		}
		break;
	    }
	    if(CPPComment) break;
	    if(LastC == '/') {
		CPPComment = 1;
		fputc('*', fp2);
		escape = 1;
	    }
	    break;
	}
	if(!escape) {
	    fputc(c, fp2);
	    LastC = c;
	}
	else
	    escape = 0;
    }
    return 0;
}
