/*
 * Copyright (c) 1990 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

/*
 * $Id: options.h,v 1.14 1995/04/18 22:02:06 mcooper Exp agc $
 */
#ifndef OPTIONS_H_
#define OPTIONS_H_

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <stdio.h>

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#define Num_Opts(o)	(sizeof(o)/sizeof(OptionDescRec))
#define HELPSTR		"-help"
#define __		(caddr_t)

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

/*
 * Values for OptionDescRec.flags.
 */
#define NoArg		0x001	/* No argument for this option.  Use
				   OptionDescRec.value. */
#define IsArg		0x002	/* Value is the option string itself */
#define SepArg		0x004	/* Value is in next argument in argv */
#define StickyArg	0x008	/* Value is characters immediately following 
				   option */
#define SkipArg		0x010	/* Ignore this option and the next argument in 
				   argv */
#define SkipLine	0x020	/* Ignore this option and the rest of argv */
#define SkipNArgs	0x040	/* Ignore this option and the next 
				   OptionDescRes.value arguments in argv */
#define ArgHidden	0x080	/* Don't show in usage or help messages */

/*
 * Option description record.
 */
typedef struct {
    char	*option;		/* Option string in argv	    */
    int		 flags;			/* Flag bits			    */
    int		(*cvtarg)();		/* Function to convert argument     */
    caddr_t	 valp;			/* Variable to set		    */
    caddr_t	 value;			/* Default value to provide	    */
    char	*usage;			/* Usage message		    */
    char	*desc;			/* Description message		    */
} OptionDescRec, *OptionDescList;

OptionDescRec  *FindOption();
int 		OptBool();
int 		OptInt();
int 		OptLong();
int 		OptShort();
int 		OptStr();
int 		ParseOptions();
void 		HelpOptions();
void 		UsageOptions();

#ifdef HAVE_STDARG_H
void 		UserError(char *fmt, ...);
#else
void 		UserError();
#endif	/* HAVE_STDARG_H */

extern char *OptionChars;

#ifndef HAVE_STRERROR
extern int errno;
extern char *sys_errlist[];
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#else
extern long strtol();
extern char *strcpy();
#endif

#endif /* !OPTIONS_H_ */
