#ifndef lint
static char RCSid[] = 
"$Id: tty.c,v 6.3 1997/04/11 13:13:27 agc Exp agc $";

static char copyright[] =
"@(#) Copyright (c) 1990-1995 Michael A. Cooper.\n\
 All rights reserved.\n";
#endif

/*
 * Copyright (c) 1990-1995 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

/*
 * Terminal interface routines
 */

#include "config.h"
#include "qterm.h"
#include <stdio.h>

#ifdef HAVE_TERMIOS_H
#include <termios.h>
#else
#ifdef HAVE_TERMIO_H
#include <termio.h>
#else
#include <sys/file.h>
#include <sgttyb.h>
#endif /* HAVE_TERMIO_H */
#endif /* HAVE_TERMIOS_H */

#if	!defined(STDIN_FILENO)
#define STDIN_FILENO		0
#endif

#ifdef HAVE_TERMIOS_H
/*
 * POSIX set terminal modes function
 */
struct termios			OrigTty;

int SetTtyModes()
{
    struct termios		newtty;

    if (tcgetattr(STDIN_FILENO, &OrigTty) != 0) {
	Error("Cannot get tty modes: %s.", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    newtty = OrigTty;
    newtty.c_iflag &= ~(INLCR|IGNCR);	/* ignore CR */
    newtty.c_lflag &= ~(ECHO);		/* noecho */
    newtty.c_lflag &= ~(ICANON);	/* crmode */
    newtty.c_cc[VMIN] = 1;		/* crmode */
    newtty.c_cc[VTIME] = 0;		/* crmode */

    if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &newtty) != 0) {
	Error("Cannot set tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#else
#ifdef HAVE_TERMIO_H
/*
 * System V set terminal modes function
 */
struct termio			OrigTty;

int SetTtyModes()
{
    struct termio		newtty;

    if (ioctl(STDIN_FILENO, TCGETA, &OrigTty) < 0) {
	Error("Cannot get tty modes: %s.", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    newtty = OrigTty;
    newtty.c_iflag &= ~(INLCR|IGNCR);	/* ignore CR */
    newtty.c_lflag &= ~ECHO;		/* noecho */
    newtty.c_lflag &= ~ICANON;		/* crmode */
    newtty.c_cc[VMIN] = 1;		/* crmode */
    newtty.c_cc[VTIME] = 0;		/* crmode */

    if (ioctl(STDIN_FILENO, TCSETAF, &newtty) < 0) {
	Error("Cannot set tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#else
/*
 * BSD set terminal modes function
 */
struct sgttyb			OrigTty;

int SetTtyModes()
{
    struct sgttyb		newtty;

    if (ioctl(STDIN_FILENO, TIOCGETP, &OrigTty) < 0) {
	Error("Cannot get tty modes: %s.", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    newtty = OrigTty;
    newtty.sg_flags |= CBREAK;		/* crmode */
    newtty.sg_flags &= ~ECHO;		/* noecho */

    if (ioctl(STDIN_FILENO, TIOCSETP, &newtty) < 0) {
	Error("Cannot set tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif /* HAVE_TERMIO_H */
#endif /* HAVE_TERMIOS_H */

#ifdef HAVE_TERMIOS_H
/*
 * POSIX restore terminal modes
 */
int UnSetTtyModes()
{
    if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &OrigTty) != 0) {
	Error("Cannot restore tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#else
#ifdef HAVE_TERMIO_H
/*
 * System V restore terminal modes
 */
int UnSetTtyModes()
{
    if (ioctl(STDIN_FILENO, TCSETAF, &OrigTty) < 0) {
	Error("Cannot restore tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#else
/*
 * BSD restore terminal modes
 */
int UnSetTtyModes()
{
    if (ioctl(STDIN_FILENO, TIOCSETP, &OrigTty) < 0) {
	Error("Cannot restore tty modes: %s", SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    return(0);
}
#endif /* HAVE_TERMIO_H */
#endif /* HAVE_TERMIOS_H */
