#! /bin/sh
#
# dict-install	For Cistron Radius 1.6.7, we're supporting
#		the move of the dictionary files to
#		/usr/local/share.
#
#		This will be the default for a new install, but
#		an existing installation will not be changed.
#
#		$Id: dict-install.sh,v 1.1 2003/04/10 14:17:11 miquels Exp $
#

umask 022
set -e

SRCDIR=$1
RADDBDIR=$2
SHAREDIR=$3

cd $SRCDIR

NEWTYPE=yes

if [ -f $RADDBDIR/dictionary ]
then
	if grep -q '^ATTRIBUTE.*User-Name' $RADDBDIR/dictionary
	then
		NEWTYPE=no
	fi
fi

if [ $NEWTYPE = yes ]
then
	DESTDIR=$SHAREDIR
else
	DESTDIR=$RADDBDIR
fi

if [ ! -d $DESTDIR ]
then
	mkdir -p $DESTDIR
fi

if [ $NEWTYPE ] && [ ! -f $RADDBDIR/dictionary ]
then
	sed -e "s!SHAREDIR!$SHAREDIR!" < dictionary > $RADDBDIR/dictionary
fi

echo "Creating/updating dictionary files in $DESTDIR"

for i in dictionary.*
do
	if [ $NEWTYPE = yes ]
	then
		cp $i $DESTDIR/$i
		continue
	fi

	if [ $i = dictionary.standard ]
	then
		orig=dictionary
	else
		orig=$i
	fi
	if [ "`find $i -newer $DESTDIR/$orig`" ]
	then
		echo "** $DESTDIR/$orig"
		NEWER=yes
	fi
done

if [ "$NEWER" = "yes" ]
then
	echo "** The samples in $SRCDIR are newer than these files"
	echo "** Please investigate and copy manually if appropriate"
fi

