/****************************************************/
/* Bibliotheque d'image 3d                          */
/* image_3d.h                                       */
/*                                                  */
/* Ecrit par : Daniel Lacroix (all rights reserved) */
/*                                                  */
/****************************************************/

#ifndef __IMAGE_3D_H__
#define __IMAGE_3D_H__

/* une matrice est un tableau de 16 int32, les matrices */
/* sont donc de 4 par 4. Les valeurs sont repartie a des*/
/* offset comme suit                                    */
/* | 0  1  2  3| */
/* | 4  5  6  7| */
/* | 8  9 10 11| */
/* |12 13 14 15| */
/* les valeurs dans la matrice sont multiplier par 1024 */
/* pour avoir des nombres a virgules fixes              */

/* nombre de bit apres la virgule dans les matrices d'ou *1024 */
#define MAT_SHL    10
/* nombre de bit apres la virgule dans les vecteurs normals */
#define NORMAL_SHL 10

/* definition d'un point dans un repere 3d */
typedef struct {
  int32 x,y,z;   /* on veut le signe */
} dot_3d;

/* definition d'une couleur */
typedef struct {
  uint8 r,g,b;
} color;

/* definition d'un polygone */
typedef struct {
  uint32 pt1,pt2,pt3,normal;
  color  col1,col2,col3;
} face;

/* definition d'un objet 3d */
typedef struct {
  /* numero d'identifiant de l'objet (utilise dans obj_buf) */
  uint32 id;
  /* nombre de polygone de cet objet */
  uint32 nb_face;
  /* definition de tout les polygones */
  face   *face;
  /* definition de tout les points (utilise dans les polygones) */
  dot_3d *dot;
  /* vecteur normaux (utilise dans les polygones) */
  dot_3d *normal;
  /* transformation a appliquer sur l'objet (null si aucune) */
  int32  *obj_mat;
  
} obj_3d;

typedef struct _obj_list obj_list;

/* definition d'une liste d'objets 3d */
struct _obj_list {
  obj_3d   *obj;
  obj_list *next;
};

typedef struct {
  image the_image;
  /* zbuffer pour decider si un point est cache ou pas */
  int32  *zbuf;
  /* indique les objects visibles en chaque point */
  uint32 *obj_buf;
  /* matrice de transformation a appliquer sur tout les objets (null si aucune) */
  int32  *global_mat;
  /* utile pour les calculs */
  int32  *x1,*x2;
  int32  *z1,*z2;
  uint8  *COLR1,*COLR2,*COLG1,*COLG2,*COLB1,*COLB2;
  /* liste des objets */
  obj_list list;
  /* defini le pixel qui sert de fond */
  pix background;
} image_3d;

/* transforme le point psrc en pdst avec la matrice pmat */
/* il est possible d'utiliser le meme point pour pdst et */
/* psrc (il et alors ecrit sur lui meme).                */
void trans_pix(dot_3d *pdst, dot_3d *psrc, int32 *pmat);

/* multipile la matrice p1 par p2, la matrice resultante est pdst         */
/* ATTENTION, pdst ne doit pas pointer sur les meme matrices que p1 et p2 */
void mul_mat(int32 *pdst, int32 *p1, int32 *p2);

/* calcul le vecteur normal pdst au plan forme de p1,p2 et p3 */
/* pdst est normalise a 2**NORMAL_SHL                         */
void normal(dot_3d *pdst, dot_3d *p1, dot_3d *p2, dot_3d *p3);

/* genere une matrice de translation dans pmat pour translater */
/* du vecteur (0,0,0) vers vecteur                             */
void move_mat(dot_3d *vecteur, int32 *pmat);

/* genere une matrice de zoom de factor. factor = 1024 => aucun changement */
void zoom_mat(int32 factor, int32 *pmat);

/* genere une matrice de rotation autour de l'axe x          */
/* angle est compris entre 0 (0 degres) et 1023 (359 degres) */
void x_rot_mat(int32 angle, int32 *pmat);

/* genere une matrice de rotation autour de l'axe y          */
/* angle est compris entre 0 (0 degres) et 1023 (359 degres) */
void y_rot_mat(int32 angle, int32 *pmat);

/* genere une matrice de rotation autour de l'axe z          */
/* angle est compris entre 0 (0 degres) et 1023 (359 degres) */
void z_rot_mat(int32 angle, int32 *pmat);

/* cree une nouvelle image_3d */
image_3d *image_3d_new(int32 width, int32 height);

/* choisi le type de pixel pour le fond */
void image_3d_set_bg(image_3d *pimage_3d, pix ppix);

/* choisi la matrice de transformation qui s'applique a tout les objets */
/* la matrice n'est pas recopie, toute modification de l'original et    */
/* donc repercute. Sa deallocation et aussi a la charge de l'appelant   */
void image_3d_set_global_mat(image_3d *pimage_3d, int32 *pmat);

/* ajoute un objet 3d a l'image 3d, l'objet n'est pas recopie, toute */
/* modification sur l'original et donc repercute. L'objet et donc    */
/* sa deallocation son a la charge de l'appelant.                    */
void image_3d_prepend_obj(image_3d *pimage_3d, obj_3d *obj);

/* A FINIR DE CORRIGER AU DELA */

void h_ligne_shade(int32 x1, int32 z1, uint8 colR1, uint8 colG1, uint8 colB1,
  int32 x2, int32 z2, uint8 colR2, uint8 colG2, uint8 colB2, int32 y);

void Triangle(dot_3d pix1,dot_3d pix2,dot_3d pix3,color col1,color col2,color col3);

void DrawObj(uint32 NbFace,dot_3d *PtrVert,face *PtrFace,dot_3d *Normal);

#endif /* __IMAGE_3D_H__ */
