/*****************************************************/
/* Image avec effet de feu                           */
/* image_fire.h                                      */
/*                                                   */
/* Ecrit par : Daniel Lacroix (all rights reserved)  */
/*                                                   */
/*****************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <image_fire.h>
#include <color.h>
#include <stdlib.h>
#include <math.h>

pix   *gradient;
uint8 *fire_buf,*fire_buf2;
uint32 fire_width, fire_height;

void fire_init(uint32 width, uint32 height)
{ uint32 i;

  /* la taille du buffer feu est plus grande car on ne peut calculer les coins */
  fire_width  = width+2;
  fire_height = height+4;

  /* table de gradient de couleur */
  if((gradient = (pix *)malloc(256*sizeof(pix))) == NULL)
  { perror("malloc failed "); exit(1); }

  for(i = 0; i < 256; i++)
  {
    gradient[i] = COL(
      (uint8)(255* (sin(i*M_PI_2/256))),
      (uint8)(255* (sin(i*M_PI_2/256))/3.0),
      (uint8)(255* (sin(i*M_PI_2/256))/2.0)
    );
  }
  
  /* buffer ou est represente le feu */
  if((fire_buf = (uint8 *)malloc(fire_width*fire_height*sizeof(uint8))) == NULL)
  { perror("malloc failed "); exit(1); }

  if((fire_buf2 = (uint8 *)malloc(fire_width*fire_height*sizeof(uint8))) == NULL)
  { perror("malloc failed "); exit(1); }

  for(i = 0; i < fire_width * fire_height; i++)
  { fire_buf[i] = 0; }
}

void fire_close(void)
{
  free(gradient); free(fire_buf); free(fire_buf2);
}

void fire_next(void)
{ int32 x,y,i;
  uint8 *fire_buf_tmp;

  /* la nouvelle ligne de feu */
  for(i = 0; i < fire_width; i++)
  {
    x = (int32) (((float)fire_width)*((float)rand())/(RAND_MAX+1.0));
    fire_buf[(fire_height-3)*fire_width + x] = 255;
  }

  for(y = 1; y < fire_height-1; y++)
  {
    for(x = 1; x < fire_width-1; x++)
    {
      fire_buf2[(y-1) * fire_width + x] =
        (fire_buf[(y-1) * fire_width + x-1] +
	 fire_buf[(y)   * fire_width + x-1] +
	 fire_buf[(y+1) * fire_width + x-1] +
	 fire_buf[(y-1) * fire_width + x  ] +
	 fire_buf[(y+1) * fire_width + x  ] +
	 fire_buf[(y-1) * fire_width + x+1] +
	 fire_buf[(y)   * fire_width + x+1] +
	 fire_buf[(y+1) * fire_width + x+1])>>3;
      if(fire_buf2[(y-1) * fire_width + x]) fire_buf2[(y-1) * fire_width + x]--;
    }
  }
  fire_buf_tmp = fire_buf;
  fire_buf     = fire_buf2;
  fire_buf2    = fire_buf_tmp;
}

void image_fire_new(image *pimage)
{ int32 x,y;

  for(y = 0; y < MIN(pimage->height,fire_height-2); y++)
  {
    for(x = 0; x < MIN(pimage->width,fire_width-2); x++)
    {
      pimage->buf[y * pimage->width + x] = gradient[fire_buf[y * fire_width + x]];
    }
  }
}
