/***********************************************************/
/* Pour cree une image a partir d'un fichier BMP (Windows) */
/* image_from_bmp.c                                        */
/*                                                         */
/* Ecrit par : Daniel Lacroix (all rights reserved)        */
/*                                                         */
/***********************************************************/

/* INCOMPLET, une petite partie des BMP est vraiment traite */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <string.h>
#include <image_from_bmp.h>

typedef struct tagBITMAPFILEHEADER {
    char    bfType[2];      /*the type of file. This member must be BM.*/
    uint8   bfSize[4];      /*the size of the file, in bytes.*/
    uint8   bfReserved1[2]; /*Reserved; must be set to zero.*/
    uint8   bfReserved2[2]; /*Reserved; must be set to zero.*/
    uint8   bfOffBits[4];   /*the byte offset from the BITMAPFILEHEADER structure*/
} BITMAPFILEHEADER;

enum{BI_RGB,BI_RLE8,BI_RLE4};
typedef struct tagBITMAPINFOHEADER {
    uint8   biSize[4];       /*the number of bytes required by the
                               BITMAPINFOHEADER structure.*/
    uint8   biWidth[4];      /*the width of the bitmap, in pixels.*/
    uint8   biHeight[4];     /*the height of the bitmap, in pixels.*/
    uint8   biPlanes[2];     /*the number of planes for the target device. This
                               member must be set to 1.*/
    uint8   biBitCount[2];   /* the number of bits per pixel. This value must
                                be 1, 4, 8, or 24.*/
    uint8   biCompression[4];/* the type of compression for a compressed 
      bitmap. It can be one of the following values:
      BI_RGB  the bitmap is not compressed. 

      BI_RLE8 run-length encoded format for bitmaps with 8 bits per pixel. 
              The compression format is a 2-byte format consisting of a count
              byte followed by a byte containing a color index.

      BI_RLE4 run-length encoded format for bitmaps with 4 bits per pixel.
              The compression format is a 2-byte format consisting of a count
              byte followed by two word-length color indexes.*/
    
    uint8   biSizeImage[4];  /*the size, in bytes, of the image. It is valid to
                               set this member to zero if the bitmap is in the 
			       BI_RGB format.*/
    int8    biXPelsPerMeter[4];/*the horizontal resolution, in pixels per meter,of
                               the target device for the bitmap. An application
			       can use this value to select a bitmap from a 
			       resource group that best matches the 
			       characteristics of the current device.*/
    int8    biYPelsPerMeter[4];/* the vertical resolution, in pixels per meter, of
                                the target device for the bitmap.*/
    uint8   biClrUsed[4];    /* number of color indexes in the color table
                                actually used by the bitmap. If this value is 
				zero, the bitmap uses the maximum number of 
				colors corresponding to the value of the 
				biBitCount member.*/
    uint8   biClrImportant[4];/*the number of color indexes that are considered
                               important for displaying the bitmap. If this
			       value is zero, all colors are important.*/
} BITMAPINFOHEADER;

typedef struct tagRGBQUAD {
    uint8 rgbBlue;  /* the intensity of blue in the color. */
    uint8 rgbGreen; /* the intensity of green in the color.*/
    uint8 rgbRed;   /* the intensity of red in the color.  */
    uint8 rgbReserved;   /* Not used; must be set to zero. */
} RGBQUAD;

typedef struct tagBITMAPINFO {
    BITMAPINFOHEADER bmiHeader; /* a BITMAPINFOHEADER structure that contains
                                   information about the dimensions and color
				   format of a DIB. */
    RGBQUAD          bmiColors[1]; /* an array of RGBQUAD structures that
                                      define the colors in the bitmap.*/
} BITMAPINFO;

/* Renvoi l'image ou NULL si impossible */
image *image_new_from_bmp(char *file_name)
{ int handle;
  int file_size;
  char *buf;
  image *vimage;
  int i,offset,x,y;
  int32 width,height;
  BITMAPFILEHEADER *vBITMAPFILEHEADER;
  BITMAPINFOHEADER *vBITMAPINFOHEADER;
  unsigned char    *vdata;

  if((handle = open(file_name,O_RDONLY)) == -1) return(NULL);
  if((file_size = lseek(handle, 0, SEEK_END)) == -1) 
  { close(handle); return(NULL); }
  if(lseek(handle, 0, SEEK_SET) == -1)
  { close(handle); return(NULL); }
  if((file_size > MAX_BMP_FILE_SIZE) || 
     (file_size < sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) ))
  { close(handle); return(NULL); }
  if((buf = (char *)malloc(file_size)) == NULL)
  { perror("malloc failed."); exit(1); }
  if(read(handle, buf, file_size) == -1)
  { free(buf); close(handle); return(NULL); }
  close(handle);
    
  vBITMAPFILEHEADER = (BITMAPFILEHEADER *)buf;
  vBITMAPINFOHEADER = (BITMAPINFOHEADER *)(buf+sizeof(BITMAPFILEHEADER));
  vdata = (unsigned char *)(buf+sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER));

  if(strncmp(vBITMAPFILEHEADER->bfType,"BM",2)) /* ce n'est pas un BMP */
  { free(buf); return(NULL); }

  width  = (((uint32)vBITMAPINFOHEADER->biWidth[3])<<24) |
           (((uint32)vBITMAPINFOHEADER->biWidth[2])<<16) |
           (((uint32)vBITMAPINFOHEADER->biWidth[1])<<8)  |
           ((uint32)vBITMAPINFOHEADER->biWidth[0]);
  height = (((uint32)vBITMAPINFOHEADER->biHeight[3])<<24) |
           (((uint32)vBITMAPINFOHEADER->biHeight[2])<<16) |
           (((uint32)vBITMAPINFOHEADER->biHeight[1])<<8)  |
           ((uint32)vBITMAPINFOHEADER->biHeight[0]);
  
  vimage = image_new(width,height);

  offset = 0;
  for(y=height-1;y>=0;y--)
  {
    for(x=0;x<width;x++)
    {
      i = x+(y*width);
      vimage->buf[i] = COL(vdata[offset+2],vdata[offset+1], vdata[offset]);
      offset += 3;
    }
    if(offset & 3) offset = (offset+4) &(~3);
  }
  
  free(buf);
  return(vimage);
}
