#include "Precomp.h"
#include "ReiserFileSystem.h"
#include "reiserfs.h"

ReiserFileSystem::ReiserFileSystem(const DWORD disk, const LONGLONG startingOffset, const LONGLONG length)
    :   m_Disk(disk, startingOffset, length)
{
    m_Partition = NULL;
}

ReiserFileSystem::~ReiserFileSystem()
{
    delete m_Partition;
}

HANDLE ReiserFileSystem::OpenFile(LPCTSTR szFilename) const
{
    // STUPID FUCKIN CONST SHIT MAN!
    ((ReiserFileSystem*)this)->MakeSurePartitionIsOpen();

    TRACE(("OpenFile '%s'\n", szFilename ))

    LPRFS_FILE_DATA h = m_Partition->GetFile(szFilename);
    if( h )
    {
        return (HANDLE) h;
    } 
    return INVALID_HANDLE_VALUE;
}

void ReiserFileSystem::ReadFile(HANDLE hFile, LPVOID lpBuffer, DWORD NumberOfBytesToRead, DWORD& NumberOfBytesRead) const
{
    LPRFS_FILE_DATA h = (LPRFS_FILE_DATA) hFile;
    NumberOfBytesRead = 0;
    if( h->dwReadPos < h->dwSize )
    {
        if( ( NumberOfBytesToRead + h->dwReadPos ) > h->dwSize )
        {
            NumberOfBytesToRead = h->dwSize - h->dwReadPos;
        }
        CopyMemory((LPBYTE)lpBuffer, h->bMemory+h->dwReadPos, NumberOfBytesToRead );
        h->dwReadPos += NumberOfBytesToRead;
        NumberOfBytesRead = NumberOfBytesToRead;
    }
    throw "DONE";

}

void ReiserFileSystem::CloseFile(HANDLE hFile) const
{
    if( hFile && (hFile != INVALID_HANDLE_VALUE) )
        delete (LPRFS_FILE_DATA) hFile;
}

void ReiserFileSystem::MakeSurePartitionIsOpen()
{
    if( m_Partition == NULL )
    {
        m_Partition = new ReiserFsPartition(&m_Disk);
        if( !m_Partition->Open() )
        {
            delete m_Partition;
            m_Partition = NULL;
        }
    }
}

HANDLE ReiserFileSystem::FindFirstFile(LPCTSTR szPath) const
{
    // STUPID FUCKIN CONST SHIT MAN!
    ((ReiserFileSystem*)this)->MakeSurePartitionIsOpen();

    TRACE(("FindFirstFile '%s'\n", szPath ))

    PList* h = new PList;
    if( h )
    {
        if( m_Partition->ListDir(h,szPath) )
        {
            return (HANDLE) h;
        } 
        delete h;
    }
    return INVALID_HANDLE_VALUE;
}

bool ReiserFileSystem::FindNextFile(HANDLE hFind, UNIX_FILEINFO& FileInfo) const
{
    PList* h = (PList*) hFind;
    ReiserFsFileInfo* fi = (ReiserFsFileInfo*) h->m_pHead;
    if( fi )
    {
	    FileInfo.i_mode = fi->m_stat.sd_mode;		/* File mode (permissions)*/
	    FileInfo.i_uid = fi->m_stat.sd_uid;		/* Low 16 bits of Owner Uid */
	    FileInfo.i_gid = fi->m_stat.sd_gid;		/* Low 16 bits of Group Id */
	    FileInfo.i_size = fi->m_stat.sd_size;		/* Size in bytes */
	    FileInfo.i_atime = fi->m_stat.sd_atime;	/* Access time */
	    FileInfo.i_ctime = fi->m_stat.sd_mtime;	/* Creation time */
	    FileInfo.i_mtime = fi->m_stat.sd_ctime;	/* Modification time */
        strncpy( FileInfo.szFileName, fi->m_strName, UNIX_FILENAME_LENGTH );
        h->Delete(fi);
        return true;
    }
    return false;
}

void ReiserFileSystem::CloseFind(HANDLE hFind) const
{
    if( hFind && (hFind != INVALID_HANDLE_VALUE) )
        delete (PList*) hFind;
}
