/*
 * Copyright (c) 1987, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*#include "config.h"*/

#ifndef lint
static const char sccsid[] = "@(#)addbytes.c	8.4 (Berkeley) 5/4/94";
#endif	/* not lint */

#include "curses.h"

#define	SYNCH_IN	{y = win->cury; x = win->curx;}
#define	SYNCH_OUT	{win->cury = y; win->curx = x;}

/*
 * waddbytes --
 *	Add the character to the current position in the given window.
 */
int
__waddbytes(win, bytes, count, so)
	register WINDOW *win;
	register const char *bytes;
	register int count;
	int so;
#ifndef MULTIBYTE
{
	static char blanks[] = "        ";
	register int c, newx, x, y;
	char stand;
	__LINE *lp;

	SYNCH_IN;

#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES('%c') at (%d, %d)\n", c, y, x);
#endif
	while (count--) {
		c = *bytes++;
		switch (c) {
		case '\t':
			SYNCH_OUT;
			if (waddbytes(win, blanks, 8 - (x % 8)) == ERR)
				return (ERR);
			SYNCH_IN;
			break;

		default:
#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES(%0.2o, %d, %d)\n", win, y, x);
#endif
			
			lp = win->lines[y];
			if (lp->flags & __ISPASTEOL) {
				lp->flags &= ~__ISPASTEOL;
newline:			if (y == win->maxy - 1) {
					if (win->flags & __SCROLLOK) {
						SYNCH_OUT;
						scroll(win);
						SYNCH_IN;
						lp = win->lines[y];
					        x = 0;
					} else
						return (ERR);
				} else {
					y++;
					lp = win->lines[y];
					x = 0;
				}
				if (c == '\n')
					break;
			}
				
			stand = '\0';
			if (win->flags & __WSTANDOUT || so)
				stand |= __STANDOUT;
#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES: 1: y = %d, x = %d, firstch = %d, lastch = %d\n",
	    y, x, *win->lines[y]->firstchp, *win->lines[y]->lastchp);
#endif
			if (lp->line[x].ch != c || 
			    !(lp->line[x].attr & stand)) {
				newx = x + win->ch_off;
				if (!(lp->flags & __ISDIRTY)) {
					lp->flags |= __ISDIRTY;
					*lp->firstchp = *lp->lastchp = newx;
				}
				else if (newx < *lp->firstchp)
					*lp->firstchp = newx;
				else if (newx > *lp->lastchp)
					*lp->lastchp = newx;
#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES: change gives f/l: %d/%d [%d/%d]\n",
	    *lp->firstchp, *lp->lastchp,
	    *lp->firstchp - win->ch_off,
	    *lp->lastchp - win->ch_off);
#endif
			}
			lp->line[x].ch = c;
			if (stand)
				lp->line[x].attr |= __STANDOUT;
			else
				lp->line[x].attr &= ~__STANDOUT;
			if (x == win->maxx - 1)
				lp->flags |= __ISPASTEOL;
			else
				x++;
#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES: 2: y = %d, x = %d, firstch = %d, lastch = %d\n",
	    y, x, *win->lines[y]->firstchp, *win->lines[y]->lastchp);
#endif
			break;
		case '\n':
			SYNCH_OUT;
			wclrtoeol(win);
			SYNCH_IN;
			if (!NONL)
				x = 0;
			goto newline;
		case '\r':
			x = 0;
			break;
		case '\b':
			if (--x < 0)
				x = 0;
			break;
		}
	}
	SYNCH_OUT;
	return (OK);
}
#else /*MULTIBYTE*/
{
	static char blanks[] = "        ";
	register int c, newx, x, y;
	__LINE *lp;
	__LDATA newch;
	__LDATA newch0;
	enum {ASCII, MB7, MB8} kstate;
	char designation;
	int is96;
	int ismb;

	/* initilize */
	kstate = ASCII;
	designation = '\0';
	is96 = 0;
	ismb = 0;

	SYNCH_IN;

#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES('%c') at (%d, %d)\n", c, y, x);
#endif
	while (count--) {
		c = *bytes++;
		switch (c) {
		case '\t':
			SYNCH_OUT;
			if (waddbytes(win, blanks, 8 - (x % 8)) == ERR)
				return (ERR);
			SYNCH_IN;
			break;
		case '\033':
			if (2 <= count && bytes[0] == '(' && bytes[1] == 'B') {
				designation = '\0';
				count -= 2;
				bytes += 2;
				break;
			} else if (2 <= count && strchr("(,", bytes[0])
			    && 0x30 <= bytes[1] && bytes[1] <= 0x7f) {
				designation = bytes[1];
				is96 = (bytes[0] == ',');
				ismb = 0;
				count -= 2;
				bytes += 2;
				break;
			} else if (2 <= count && bytes[0] == '$'
			    && strchr("@AB", bytes[1])) {
				designation = bytes[1];
				is96 = 0;
				ismb = 1;
				count -= 2;
				bytes += 2;
				break;
			} else if (3 <= count && bytes[0] == '$'
			    && strchr("(,", bytes[1])
			    && 0x30 <= bytes[2] && bytes[2] <= 0x7f) {
				designation = bytes[2];
				is96 = (bytes[1] == ',');
				ismb = 1;
				count -= 3;
				bytes += 3;
				break;
			}
			/* fall through */

		default:
#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES(%0.2o, %d, %d)\n", win, y, x);
#endif
			
			lp = win->lines[y];
			if (lp->flags & __ISPASTEOL) {
				lp->flags &= ~__ISPASTEOL;
newline:			if (y == win->maxy - 1) {
					if (win->flags & __SCROLLOK) {
						SYNCH_OUT;
						scroll(win);
						SYNCH_IN;
						lp = win->lines[y];
					        x = 0;
					} else
						return (ERR);
				} else {
					y++;
					lp = win->lines[y];
					x = 0;
				}
				if (c == '\n')
					break;
			}

#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES: 1: y = %d, x = %d, firstch = %d, lastch = %d\n",
	    y, x, *win->lines[y]->firstchp, *win->lines[y]->lastchp);
#endif

			memcpy(&newch, &lp->line[x], __LDATASIZE);

			/*
			 * Create buffer for new character.
			 */
			newch.ch = c;
			if (win->flags & __WSTANDOUT || so)
				newch.attr |= __STANDOUT;
			else
				newch.attr &= ~__STANDOUT;
			newch.attr &= ~(__MBFIRST | __MBSECOND | __MBDESIG  | __MB96);
			newch.desig = '\0';
			switch (kstate) {
			case ASCII:
				if (designation) {
					newch.attr |= __MBDESIG;
					newch.attr |= (is96 ? __MB96 : 0);
					newch.desig = designation;
					if (1 <= count && ismb) {
						newch.attr |= __MBFIRST;
						kstate = MB7;
					}
				} else if (c & 0x80) {
					if (1 <= count) {
						newch.attr |= __MBFIRST;
						kstate = MB8;
					}
				}
				break;
			case MB7:
				newch.attr |= __MBDESIG;
				newch.attr |= (is96 ? __MB96 : 0);
				newch.desig = designation;
				/* fall through */
			case MB8:
				newch.attr |= __MBSECOND;
				kstate = ASCII;
				break;
			}

			/*
			 * Displaying multibyte char across start-of-line
			 * or end-of-line is illegal.  Protect ourself against
			 * that situation.
			 */
			if (x == 0 && (newch.attr & __MBSECOND)) {
				newch.ch = ' ';
				newch.attr &= ~__MBALL;
				newch.desig = '\0';
			} else if (x == win->maxx - 1
				&& (newch.attr & __MBFIRST)) {
				newch.ch = ' ';
				newch.attr &= ~__MBALL;
				newch.desig = '\0';
			}

#define	UPDATE(x)	\
    {								\
	newx = (x) + win->ch_off;				\
	if (!(lp->flags & __ISDIRTY)) {				\
		lp->flags |= __ISDIRTY;				\
		*lp->firstchp = *lp->lastchp = newx;		\
	} else if (newx < *lp->firstchp)			\
		*lp->firstchp = newx;				\
	else if (newx > *lp->lastchp)				\
		*lp->lastchp = newx;				\
    }

			/*
			 * Perform update, only if it is needed.
			 *
			 * 1. If we got first part of multibyte char,
			 *    update will be delayed till the next round.
			 * 2. If we got second part of multibyte char,
			 *    and there is a change, update both part.
			 * 3. If we got singlebyte char, and there is a change,
			 *    update.
			 *
			 * While doing update, we might overwrite first/second
			 * part of multibyte char only.  Since it is illegal
			 * to do so, we'll erase the countarpart by space.
			 */
			if (newch.attr & __MBFIRST) {
				/* update it later. */
				memcpy(&newch0, &newch, __LDATASIZE);
			} else if ((newch.attr & __MBSECOND)
			 && (memcmp(&newch0, &lp->line[x - 1], __LDATASIZE)
			  || memcmp(&newch, &lp->line[x], __LDATASIZE))) {
				UPDATE(x - 1);
				UPDATE(x);

				if (0 <= x - 2
				 && (lp->line[x-1].attr & __MBSECOND)) {
					lp->line[x - 2].ch = ' ';
					lp->line[x - 2].attr = 0;
					lp->line[x - 2].desig = 0;

					UPDATE(x - 2);
				}
				if (x + 1 < win->maxx
				 && (lp->line[x].attr & __MBFIRST)) {
					lp->line[x + 1].ch = ' ';
					lp->line[x + 1].attr = 0;
					lp->line[x + 1].desig = 0;

					UPDATE(x + 1);
				}

#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES: change gives f/l: %d/%d [%d/%d]\n",
	    *lp->firstchp, *lp->lastchp,
	    *lp->firstchp - win->ch_off,
	    *lp->lastchp - win->ch_off);
#endif

				memcpy(&lp->line[x - 1], &newch0, __LDATASIZE);
				memcpy(&lp->line[x], &newch, __LDATASIZE);
			} else if (memcmp(&newch, &lp->line[x], __LDATASIZE)) {
				UPDATE(x);

				if (0 <= x - 1
				 && (lp->line[x].attr & __MBSECOND)) {
					lp->line[x - 1].ch = ' ';
					lp->line[x - 1].attr = 0;
					lp->line[x - 1].desig = 0;

					UPDATE(x - 1);
				}
				if (x + 1 < win->maxx
				 && (lp->line[x].attr & __MBFIRST)) {
					lp->line[x + 1].ch = ' ';
					lp->line[x + 1].attr = 0;
					lp->line[x + 1].desig = 0;

					UPDATE(x + 1);
				}

#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES: change gives f/l: %d/%d [%d/%d]\n",
	    *lp->firstchp, *lp->lastchp,
	    *lp->firstchp - win->ch_off,
	    *lp->lastchp - win->ch_off);
#endif

				memcpy(&lp->line[x], &newch, __LDATASIZE);
			}
			if (x == win->maxx - 1)
				lp->flags |= __ISPASTEOL;
			else
				x++;
#ifdef CURSES_DEBUG
	__CTRACE("ADDBYTES: 2: y = %d, x = %d, firstch = %d, lastch = %d\n",
	    y, x, *win->lines[y]->firstchp, *win->lines[y]->lastchp);
#endif
			break;
		case '\n':
			SYNCH_OUT;
			wclrtoeol(win);
			SYNCH_IN;
			if (!NONL)
				x = 0;
			goto newline;
		case '\r':
			x = 0;
			break;
		case '\b':
			if (--x < 0)
				x = 0;
			break;
		}
	}
	SYNCH_OUT;
	return (OK);
}
#endif /*MULTIBYTE*/
