#! /usr/bin/perl

die if (scalar(@ARGV) != 3);
$curdir = $ARGV[0];
$srcdir = $ARGV[1];
$localedir = $ARGV[2];

$originals = <<EOF;
big5
en_US.ascii
en_US.iso-8859-1
en_US.iso-8859-1+
en_US.utf2
euctw
ja_JP.ctext
ja_JP.eucJP
ja_JP.iso-2022-jp
ja_JP.iso-2022-jp-2
ja_JP.sjis
ko_KR.eucKR
lt_LN.iso-8859-2
ru_SU.CP866
ru_SU.KOI8-R
EOF

$links = <<EOF;
en_US.ascii
	lt_LN
en_US.iso-8859-1
	da_DK de_AT de_CH de_DE en_AU en_CA en_GB en_ES fi_FI fr_BE fr_CA
	fr_CH fr_FR hr_HR is_IS it_CH it_IT lt_LN nl_BE nl_NL no_NO pt_PT
	sv_SE
lt_LN.iso-8859-2
	hr_HR
ja_JP.iso-2022-jp-2
	en_US
ru_SU.CP866
	ru_RU
ru_SU.KOI8-R
	ru_RU
EOF

if (! -d $localedir) {
	print STDERR "mkdir $localedir\n";
	mkdir($localedir, 0755) || die;
}

# generate originals
foreach $i (split("\n", $originals)) {
	print STDERR "generating LC_CTYPE for $i...";
	if (! -f "$srcdir/$i") {
		print STDERR "no source file, skipping\n";
		next;
	}

	mkdir("$localedir/$i", 0755) if (! -d "$localedir/$i");
	unlink "$localedir/$i/LC_CTYPE";
	system "cpp -I$curdir $srcdir/$i 2>/dev/null | sed -e '/^#/d' | $curdir/mklocale > $localedir/$i/LC_CTYPE";
	print STDERR " done\n";
}

# generate links
foreach $i (split("\n", $links)) {
	if ($i =~ /^[^\t]/) {
		$linksrc = $i if (-d "$localedir/$i"
					&& -f "$localedir/$i/LC_CTYPE");
		if ($linksrc =~ /\.([^.]+)$/) {
			$encoding = $1;
		}
		next;
	}

	$i =~ s/^\s+//;
	$i =~ s/\s+$//;
	foreach $j (split(/\s+/, $i)) {
		$out = "$j.$encoding";
		print STDERR "generating LC_CTYPE for $out -> $linksrc...";
		if ($linksrc eq '') {
			print STDERR "no source file, skipping\n";
			next;
		}
		mkdir("$localedir/$out", 0755) if (! -d "$localedir/$out");
		unlink "$localedir/$out/LC_CTYPE";
		system "( chdir $localedir/$out/; ln -s ../$linksrc/LC_CTYPE)";
		print STDERR " done\n";
	}
}
