#include <sys/types.h>

#include <errno.h>
#include <rune.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>

rune_t	_EUCTW_sgetrune __P((const char *, size_t, char const **, void *));
int	_EUCTW_sputrune __P((rune_t, char *, size_t, char **, void *));

int
_EUCTW_init(rl)
	_RuneLocale *rl;
{
	rl->sgetrune = _EUCTW_sgetrune;
	rl->sputrune = _EUCTW_sputrune;
	rl->initstate = NULL;
	rl->sizestate = 0;
	rl->packstate = NULL;
	rl->unpackstate = NULL;

	_CurrentRuneLocale = rl;
	__mb_cur_max = 4;
	return (0);
}

#define	_SS2	0x008e
#define	_SS3	0x008f

static inline int
_euc_set(c)
	u_int c;
{
	c &= 0xff;

	return ((c & 0x80) ? (c == _SS2 ? 2 : 1) : 0);
}

static inline int
_euc_count(set)
	int set;
{
	switch (set) {
	case 0:
		return 1;
	case 1:
		return 2;
	case 2:
		return 4;
	case 3:
		abort();
		/*NOTREACHED*/
	}
}

rune_t
_EUCTW_sgetrune(string, n, result, state)
	const char *string;
	size_t n;
	char const **result;
	void *state;
{
	rune_t rune = 0;
	rune_t runemask = 0;
	int len, set;

	if (n < 1 || (len = _euc_count(set = _euc_set(*string))) > n) {
		if (result)
			*result = string;
		return (_INVALID_RUNE);
	}
	switch (set) {
	case 2:
		if ((u_char)string[1] < 0xa1 || 0xa7 < (u_char)string[1]) {
			if (result)
				*result = string;
			return (_INVALID_RUNE);
		}
		--len;
		++string;
		runemask = ('G' + *string - 0xa1) << 24;
		--len;
		++string;
		break;
	case 1:
		runemask = 'G' << 24;
		break;
	}
	while (len-- > 0)
		rune = (rune << 8) | ((u_int)(*string++) & 0x7f);
	rune |= runemask;
	if (result)
		*result = string;
	return (rune);
}

int
_EUCTW_sputrune(c, string, n, result, state)
	rune_t c;
	char *string, **result;
	size_t n;
	void *state;
{
	rune_t cs = c & 0x7f000080;
	rune_t v;
	int i, len, clen;

	clen = 1;
	if (c & 0x00007f00)
		clen = 2;
	if ((c & 0x007f0000) && !(c & 0x00800000))
		clen = 3;

	if (clen == 1 && cs == 0x00000000) {
		/* ASCII */
		len = 1;
		if (n < len)
			goto notenough;
		v = c & 0x0000007f;
		goto output;
	}
	if (clen == 2 && cs == ('G' << 24)) {
		/* CNS-11643-1 */
		len = 2;
		if (n < len)
			goto notenough;
		v = c & 0x00007f7f;
		v |= 0x00008080;
		goto output;
	}
	if (clen == 2 && 'H' <= (cs >> 24) && (cs >> 24) <= 'M') {
		/* CNS-11643-[2-7] */
		len = 4;
		if (n < len)
			goto notenough;
		*string++ = _SS2;
		*string++ = (cs >> 24) - 'H' + 0xa2;
		v = c & 0x00007f7f;
		v |= 0x00008080;
		goto output;
	}

	abort();

output:
	i = clen;
	while (i-- > 0)
		*string++ = (v >> (i << 3)) & 0xff;

	if (*result)
		*result = string;
	return len;

notenough:
	if (*result)
		*result = NULL;
	return len;
}
