'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH mib n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
mib \- Load and query SNMP MIB definitions.
.BE

.SH DESCRIPTION

The \fBmib\fR command allows to load and query definitions contained
in SNMP Management Information Base (MIB) specifications (RFC 1155,
RFC 1212, RFC 1902 and RFC 1903). Queries are usually formulated for a
specific node in the global MIB tree. The \fBmib\fR command also
allows to format/scan MIB values from/to their underlying primitive
representation.

.SH MIB NODE NAMES
A MIB node is either identified by the globally unique object
identifier in dotted notation (e.g. 1.3.6.1.2.1.1.1) or by its
descriptive name (e.g. sysDescr). However, simple names are only
unique for a single MIB module. A globally unique name is therefore
the combination of the MIB module name and the name of a MIB node
defined in the module (e.g. SNMPv2-MIB!sysDescr). The ! character
separates the optional MIB module name from the node name.

It is also legal to have hexadecimal sub-identifier in an object
identifier. A colon instead of a dot is used to indicate that the
following sub-identifier is a hexadecimal value. You can also use a dot
followed by the 0x prefix. This is useful to encode character strings
in an object identifier. As an example, the object identifier
1.3.6.1.4.1.0x627:74:75:62:73 will be accepted and converted to
1.3.6.1.4.1.1575.116.117.98.115.

It is suggested to use the object identifier notation whenever
possible in scripts because it is globally unique and fast. Globally
unique names (like SNMPv2-MIB!sysDescr) are also a good and fast
choice. Simple names may lead to ambiguities and can result is slower
lookups if the name can not be found in the underlying hash table.
Composed simple names (like system.sysDescr) make ambiguities less
likely but they may cause substantial overhead.

.SH MIB COMMAND
.TP
.B mib load \fIfile\fR

The \fBmib load\fR command loads the MIB definitions contained in
\fIfile\fR. The file should contain a valid MIB definition. The
built-in parser reads the \fIfile\fR. Parsing errors are written to
stderr. The MIB file is usually located at the file system position
defined by the \fIfile\fR argument. However, if \fIfile\fR is a simple
file name and it does not exist in the current directory, than it will
be searched in $tnm(library)/site and $tnm(library)/mibs in this
order. A condensed format of the MIB definition is saved in a platform
specific sub-directory below $tnm(library) to speed up future load
commands. Note, this requires write permissions for the platform
specific sub-directory.

The Tnm extension automatically loads all MIB files named in the
global Tcl variable $tnm(mibs). This allows to pre-define a set of
useful MIB definitions. The default is the set of IETF MIBs. It is
possible to bypass the auto-loading mechanism if the first \fBmib\fR 
command is a \fBmib load\fR command. Note that the \fBsnmp\fR command 
may also invoke \fBmib\fR commands.

.TP
.B mib \fR[\fI-exact\fR]\fB name \fIlabel\fR
The \fBmib name\fR command returns the short name associated with a
node in the MIB tree. The \fIlabel\fR may be a node name in one of the
formats discussed above. The -exact option forces strict lookups where
it is not allowed that \fIlabel\fR contains an instance
identifier. For example, \fBmib name 1.3.6.1.2.1.1.3.0\fR will return
sysUpTime.0 while \fBmib -exact name 1.3.6.1.2.1.1.3.0\fR will fail.

.TP
.B mib \fR[\fI-exact\fR]\fB oid \fIlabel\fR
The \fBmib oid\fR command is the counterpart to the \fBmib name\fR
command and returns the object identifier of the MIB node identified
by \fIlabel\fR. The \fIlabel\fR may be a node name in one of the
formats discussed above. The -exact option forces strict lookups where
it is not allowed that \fIlabel\fR contains an instance identifier.
If a \fIlabel\fR is not unique within the loaded MIB definitions, the
object identifier of the first matching MIB node will be returned.

.TP
.B mib \fR[\fI-exact\fR]\fB module \fIlabel\fR
The \fBmib module\fR command returns the name of the module which
defines the MIB node identified by \fIlabel\fR. The \fIlabel\fR may be
a node name in one of the formats discussed above. The -exact option
forces strict lookups where it is not allowed that \fIlabel\fR
contains an instance identifier.

.TP
.B mib \fR[\fI-exact\fR]\fB macro \fIlabel\fR
The \fBmib macro\fR command returns the name of the ASN.1 macro which
has been used to define the MIB node identified by \fIlabel\fR. The
\fIlabel\fR may be a node name in one of the formats discussed
above. The -exact option forces strict lookups where it is not allowed
that \fIlabel\fR contains an instance identifier.

.TP
.B mib \fR[\fI-exact\fR]\fB syntax \fIlabel\fR
The \fBmib syntax\fR command returns the ASN.1 syntax associated with
a MIB node or an empty string if the node identified by \fIlabel\fR
has no associated ASN.1 syntax. The \fIlabel\fR may be a node name in
one of the formats discussed above. The -exact option forces strict
lookups where it is not allowed that \fIlabel\fR contains an instance
identifier. The syntax name returned is the syntax as defined in the
macro. This might be the name of a textual-convention. The \fBmib
tc\fR command can be used to get the underlying base syntax which is
used to encode values on the network.

.TP
.B mib \fR[\fI-exact\fR]\fB description \fIlabel\fR
The \fBmib description\fR command returns the textual description of
the MIB node identified by \fIlabel\fR. The \fIlabel\fR may be a node
name in one of the formats discussed above. The -exact option forces
strict lookups where it is not allowed that \fIlabel\fR contains an
instance identifier.

.TP
.B mib \fR[\fI-exact\fR]\fB successor \fIlabel\fR
The \fBmib successor\fR command returns a list of all known successors
of the MIB node identified by \fIlabel\fR. The \fIlabel\fR may be a
node name in one of the formats discussed above. The -exact option
forces strict lookups where it is not allowed that \fIlabel\fR
contains an instance identifier. The format of the result depends on
the format of \fIlabel\fR: If \fIlabel\fR is an object identifier,
then the result will be a list of object identifier. The result is a
list of names if \fIlabel\fR is a name of a MIB node.

.TP
.B mib \fR[\fI-exact\fR]\fB parent \fIlabel\fR 
The \fBmib parent\fR command returns the parent node of the MIB node
identified by \fIlabel\fR. The \fIlabel\fR may be a node name in one
of the formats discussed above. The -exact option forces strict
lookups where it is not allowed that \fIlabel\fR contains an instance
identifier. The format of the result depends on the format of
\fIlabel\fR: If \fIlabel\fR is an object identifier, then the result
is the object identifier of the parent node. The result is the name
of the parent node if \fIlabel\fR is a name of a MIB node.

.TP
.B mib \fR[\fI-exact\fR]\fB access \fIlabel\fR
The \fBmib access\fR command returns the max-access for a MIB node or
an empty string if there is no access associated with the MIB node
identified by \fIlabel\fR. The \fIlabel\fR may be a node name in one
of the formats discussed above. The -exact option forces strict
lookups where it is not allowed that \fIlabel\fR contains an instance
identifier. The returned access mode is one of the values
not-accessible, read-only, read-create, read-write, write-only.

.TP
.B mib \fR[\fI-exact\fR]\fB index \fIlabel\fR
The \fBmib index\fR command returns the list of MIB names which are
used as a key in a conceptual table or an empty result if the MIB node
identified by \fIlabel\fR does not correspond to a MIB table. The
\fIlabel\fR may be a node name in one of the formats discussed
above. The -exact option forces strict lookups where it is not allowed
that \fIlabel\fR contains an instance identifier.

.TP
.B mib \fR[\fI-exact\fR]\fB tc \fIlabel\fR
The \fBmib tc\fR command returns a Tcl list which describes the
textual convention associated with the MIB node identified by
\fIlabel\fR. The result is an empty string if the MIB node does not
make use of a textual convention. The \fIlabel\fR may be a node name
in one of the formats discussed above. The -exact option forces strict
lookups where it is not allowed that \fIlabel\fR contains an instance
identifier.

The list contains the following elements: the name of the textual
convention, the name of the underlying ASN.1 type, the format string
(display hint), a list of name value pairs used to convert enumerations
to integer values, the MIB module which contains the definition of
the textual convention and the file which contains the definition.

.TP
.B mib \fR[\fI-exact\fR]\fB file \fIlabel\fR
The \fBmib file\fR command returns the file name that contains the
definition of the MIB node identified by \fIlabel\fR. The \fIlabel\fR
may be a node name in one of the formats discussed above. The -exact
option forces strict lookups where it is not allowed that \fIlabel\fR
contains an instance identifier.

.TP
.B mib format \fIlabel\fR \fIvalue\fR
The \fBmib format\fR command can be used to apply a textual convention
that is defined for the MIB node identified by \fIlabel\fR to
\fIvalue\fR. This command is used internally to return readable values
for SNMP request and may be helpful in situations where it is
appropriate to apply these formating rules directly. The \fBmib
format\fR command can be used to render integer enumerations, to apply
display hints, to render time tick values and to convert object
identifier into globally unique names. The \fIlabel\fR may be a node
name in one of the formats discussed above. The -exact option forces
strict lookups where it is not allowed that \fIlabel\fR contains an
instance identifier.

.TP
.B mib scan \fIlabel\fR \fIvalue\fR
The \fBmib scan\fR command implements the inverse operation for the
\fBmib format\fR command described above. It converts a rendered value
into the underlying base string representation. This command may be
useful in situations where you want to operate on the primitive format
rather than the readable representation. The \fBmib scan\fR command
returns the \fIvalue\fR unaltered if no conversions apply. The
\fIlabel\fR may be a node name in one of the formats discussed
above. The -exact option forces strict lookups where it is not allowed
that \fIlabel\fR contains an instance identifier.

.TP
.B mib walk \fIvarName label body\fR
The \fBmib walk\fR command evaluates the Tcl script \fIbody\fR for
each known MIB node below the node identified by \fIlabel\fR. The
\fBmib walk\fR command allows to walk entire MIB subtrees. Every nodes
in a subtree identified by \fBlabel\fR is assigned to \fIvarName\fR
before the \fIbody\fR is evaluated. The value assigned to
\fIvarName\fR depends on the format of \fIlabel\fR: If \fIlabel\fR is
an object identifier, then the value will be an object identifier. The
value of \fIvarName\fR is the name of a MIB node if \fIlabel\fR is a
name of a MIB node.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
Sven Schmidt <vschmidt@ibr.cs.tu-bs.de>
.br
Erik Schoenfelder <schoenfr@gaertner.de>
.br
