/*
 * tnmInt.h --
 *
 *	Declarations of things used internally by the Tnm extension.
 *
 * Copyright (c) 1993-1996 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TNMINT
#define _TNMINT

#include <stdio.h>

#ifndef _TNM
#include "tnm.h"
#endif

#ifndef _TNMPORT
#include "tnmPort.h"
#endif

/*
 *----------------------------------------------------------------
 * The following functions are not officially exported by Tcl. 
 * They are used anyway because they make this code simpler and 
 * platform independent.
 *----------------------------------------------------------------
 */

#if TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION == 5 && ! defined(Tcl_Ckfree)
#define TnmGetTime TclGetTime
#else
#define TnmGetTime TclpGetTime
#endif

#define TnmCreateDirectory	TclpCreateDirectory
#if TCL_MAJOR_VERSION == 8 && TCL_MINOR_VERSION == 8 && TCL_RELEASE_SERIAL > 2 
#define TnmStat			TclStat
#else
#define TnmStat			stat
#endif

#if TCL_MAJOR_VERSION == 8
#define Tcl_File int
#define Tcl_GetFile(a,b) (int)a
#define Tcl_GetFileInfo(a,b) a
#define Tcl_FreeFile(a)
#endif

EXTERN void
TclpGetTime		_ANSI_ARGS_((Tcl_Time *timePtr));

EXTERN int
TnmCreateDirectory	_ANSI_ARGS_((char *path));

EXTERN int
TnmStat			_ANSI_ARGS_((CONST char *path, struct stat *buf));

EXTERN int
TnmMkDir		_ANSI_ARGS_((Tcl_Interp *interp, char *pathname));

/*
 *----------------------------------------------------------------
 * These functions provide the platform independent initialization
 * points. They are called from platform specific dynamic link
 * entry points.
 *----------------------------------------------------------------
 */

EXTERN int
TnmInit			_ANSI_ARGS_((Tcl_Interp *interp));

EXTERN int
TnmSafeInit		_ANSI_ARGS_((Tcl_Interp *interp));

/*
 *----------------------------------------------------------------
 * The following structure describes simple tables that map 
 * integer keys to string values and vice versa. This is usually 
 * used to map error codes or similar tokens to strings.
 *----------------------------------------------------------------
 */

typedef struct TnmTable {
    unsigned key;
    char *value;
} TnmTable;

EXTERN char *
TnmGetTableValue	_ANSI_ARGS_((TnmTable *table, unsigned key));

EXTERN int
TnmGetTableKey		_ANSI_ARGS_((TnmTable *table, char *value));

EXTERN char *
TnmGetTableValues	_ANSI_ARGS_((TnmTable *table));

/*
 *----------------------------------------------------------------
 * A simple mechanism to handle object configuration options.
 * This is not as flexible as the Tk option handling mechanism
 * but it fits our needs.
 *----------------------------------------------------------------
 */

typedef char * (TnmGetConfigProc) _ANSI_ARGS_((Tcl_Interp *interp,
        ClientData clientData, int option));
typedef int (TnmSetConfigProc) _ANSI_ARGS_((Tcl_Interp *interp,
        ClientData clientData, int option, char *value));

typedef struct TnmConfig {
    TnmTable *optionTable;
    TnmSetConfigProc *setOption;
    TnmGetConfigProc *getOption;
} TnmConfig;

EXTERN int
TnmSetConfig		_ANSI_ARGS_((Tcl_Interp *interp, TnmConfig *config,
				     ClientData obj, int argc, char **argv));
EXTERN int
TnmGetConfig		_ANSI_ARGS_((Tcl_Interp *interp, TnmConfig *config,
				     ClientData obj, int argc, char **argv));

/*
 *----------------------------------------------------------------
 * Functions to convert common string arguments into an
 * internal format with additional error checks.
 *----------------------------------------------------------------
 */

EXTERN int 
TnmGetUnsigned		_ANSI_ARGS_((Tcl_Interp *interp, char *string,
				     int *intPtr));
EXTERN int 
TnmGetPositive		_ANSI_ARGS_((Tcl_Interp *interp, char *string,
				     int *intPtr));
EXTERN int
TnmSetIPAddress		_ANSI_ARGS_((Tcl_Interp *interp, char *name,
				     struct sockaddr_in *addr));
EXTERN char *
TnmGetIPName		_ANSI_ARGS_((Tcl_Interp *interp,
				     struct sockaddr_in *addr));
EXTERN int
TnmSetIPPort		_ANSI_ARGS_((Tcl_Interp *interp, char *protocol,
				     char *port, struct sockaddr_in *addr));
EXTERN char *
TnmGetIPPort		_ANSI_ARGS_((Tcl_Interp *interp, char *protocol,
				     struct sockaddr_in *addr));
EXTERN int
TnmValidateIpHostName	_ANSI_ARGS_((Tcl_Interp *interp, char *name));

EXTERN int
TnmValidateIpAddress	_ANSI_ARGS_((Tcl_Interp *interp, char *address));

/*
 *----------------------------------------------------------------
 * The following defines are taken from the UNIX syslog facility.
 * Not all of them may be supported on all platforms.
 *----------------------------------------------------------------
 */

#define	TNM_LOG_EMERG	0	/* system is unusable */
#define	TNM_LOG_ALERT	1	/* action must be taken immediately */
#define	TNM_LOG_CRIT	2	/* critical conditions */
#define	TNM_LOG_ERR	3	/* error conditions */
#define	TNM_LOG_WARNING	4	/* warning conditions */
#define	TNM_LOG_NOTICE	5	/* normal but significant condition */
#define	TNM_LOG_INFO	6	/* informational */
#define	TNM_LOG_DEBUG	7	/* debug-level messages */

EXTERN TnmTable tnmLogTable[];

EXTERN int 
TnmWriteLogMessage	_ANSI_ARGS_((Tcl_Interp *interp, int level,
				     char *message));

EXTERN void
TnmWriteMessage		_ANSI_ARGS_((Tcl_Interp *interp, char *msg));

/*
 *----------------------------------------------------------------
 * The following defines are used to distinguish the ICMP packet
 * types supported by the icmp command.
 *----------------------------------------------------------------
 */

#define TNM_ICMP_ERROR		0x01
#define TNM_ICMP_FINAL_HOP	0x02

typedef struct TnmIcmpTarget {
    struct sockaddr_in dst;	/* The address of the ICMP target. */
    struct sockaddr_in res;	/* The address contained in the response. */
    union {
	unsigned rtt;		/* The round trip time in ms. */
	int tdiff;		/* The time stamp difference. */
	int mask;		/* The address mask. */
    } u;
    int flags;			/* Some flags (see above). */
} TnmIcmpTarget;

#define TNM_ICMP_ECHO		1
#define TNM_ICMP_MASK		2
#define TNM_ICMP_TIMESTAMP	3
#define TNM_ICMP_TTL		4
#define TNM_ICMP_TRACE		5

typedef struct TnmIcmpRequest {
    int type;			/* The ICMP request type (see above). */
    int ttl;			/* The time-to-live value for this request. */
    int timeout;		/* The timeout value (ms) for this request. */
    int retries;		/* The retry value for this request. */
    int delay;			/* The delay value (ms) for this request. */
    int size;			/* The size of the ICMP packet. */
    int argc;			/* The number of targets for this request. */
    char **argv;		/* The names of the targets. */
    TnmIcmpTarget *targets;	/* The vector of targets. */
    struct TnmIcmpRequest *nextPtr;	/* Next queued request. */
} TnmIcmpRequest;

EXTERN int
TnmIcmp			_ANSI_ARGS_((Tcl_Interp *interp, 
				     TnmIcmpRequest *icmpPtr));

/*
 *----------------------------------------------------------------
 * The following funtions are used internally to access sockets
 * in a platform independent way. These functions return the value
 * TNM_SOCKET_ERROR as an error result and set the errno variable
 * in a way that allows to use Tcl_PosixError().
 *----------------------------------------------------------------
 */

#define TNM_SOCKET_ERROR -1

EXTERN int
TnmSocket		_ANSI_ARGS_((int domain, int type, int protocol));

EXTERN int
TnmSocketBind		_ANSI_ARGS_((int s, struct sockaddr *name,
				     int namelen));
EXTERN int
TnmSocketSendTo		_ANSI_ARGS_((int s, char *buf, int len, int flags,
				     struct sockaddr *to, int tolen));
EXTERN int
TnmSocketRecvFrom	_ANSI_ARGS_((int s, char *buf, int len, int flags,
				     struct sockaddr *from, int *fromlen));
EXTERN int
TnmSocketClose		_ANSI_ARGS_((int s));

#endif /* _TNMINT */
