#ifndef _INCLUDE_CACHE_H_
#define _INCLUDE_CACHE_H_

#include <time.h>
#include "main.h"

#define CACHE_HTML 1
#define CACHE_EXE 2
#define CACHE_DIR_HTML "output"
#define CACHE_DIR_EXE "bin"

enum {
	CACHERULE_NEVER,
	CACHERULE_TIME, 
	CACHERULE_NOINPUT
};

enum {
	CACHE_EXEC,
	CACHE_OUTPUT,
	CACHE_BOTH
};

#ifndef _HSML_LANG_
extern char cache;
extern char cacherule;
extern char *pwd;
extern char *tmp;

void cache_init(void);

bool cache_should_output(char *);
bool cache_should_exec(char *);
void cache_print(char *);
void cache_output_add(char *, char *);
void cache_exec_add(char *, char *);
void cache_exec(char *, int);
bool cache_makedir_r(char *);
#endif

#endif
