
#include "HsmlLang.h"
#include "Cache.h"

char lang[] = "c";
char file[] = ".c.html";
char cmd[] = PATH_CC;
char *args[] = {0, "-xc", "-w", "-o", 0, 0, 0};

bool init(void)
{
	args[0] = cmd;
//	args[0] = get_path_from_env();
}

char *get_path_from_env(void)
{
//	return cmd = getenv("PATH_CC");
}

void show_config(void)
{
	printf("C hsml sublang module\n");
	printf("lang name: %s\nlang file extension: %s\nlang compile command: %s\n",
		lang, file, cmd);
}

void print_begin(char *buf)
{
	strcat(buf, "printf(\"");
}

void print_end(char *buf)
{
	strcat(buf, "\\n\");\n");
}

void print_end_nl(char *buf)
{
	strcat(buf, "\");\n");
}

void code_begin(char *buf)
{
	strcat(buf, "#include <stdio.h>\n"
				"main(){\n");
}

void code_end(char *buf)
{
	strcat(buf, "\n}\n");
}

void codevar(char *buf, char *p)
{
	printf("printf(\"codevar not allowed\\n\");");
}

void exec(char *file, char *buf, char *tmp)
{
	char *args2[2];
	char codefile[PATH_STRING_LEN];
	char exe[PATH_STRING_LEN];
	int fd;
	int bytes, status;
	
	do {
		bytes = snprintf(codefile, PATH_STRING_LEN, "%s/%s.%d.%d", tmp, file, time(0), rand());
		if(bytes >= PATH_STRING_LEN) {
			printf("C source file path too long\n");
			return;
		}
		fd = open(codefile, O_WRONLY | O_CREAT | O_EXCL, S_IRUSR);
	} while(fd == -1 && errno == EEXIST);
	if (fd == -1) printf("Cannot write C source to: '%s'\n",codefile);
	else {
		write(fd, buf, strlen(buf));
		close(fd);
		bytes = snprintf(exe, PATH_STRING_LEN, "%s/%s.%d.%d", tmp, file, time(0), rand()+1);
		if(bytes >= PATH_STRING_LEN) {
			printf("C binnary file path too long\n");
			return;
		}
		
		args[4]=exe;
		args[5]=codefile;
		
		if(!fork())
		{
			close(2); dup2(1,2);
			execve(args[0], args, environ);
			printf("Could not exec C compiler\n");
			exit(2);
		}
		wait(&status);
		unlink(codefile);
		
		if(status)
		{
			if(status == 1)
			{
				printf("Code error in script %s\n", file);
				exit(1);

				}
			else return;
		}
		
		args2[0] = exe;
		args2[1] = 0;
		if(cache && (cacherule == CACHERULE_TIME || cacherule == CACHERULE_NOINPUT && !strcmp("", getenv("ARGS"))))
		{
			if(!fork())
			{
				fd = open(codefile, O_WRONLY | O_CREAT);
				if(fd){ close(1); dup2(fd,1);}
				close(2); dup2(1,2);
				execve(args2[0], args2, environ);
				perror("Could not exec binnary C file");
				close(fd);
				unlink(codefile);
				exit(1);
			}
			wait(0);
			
			cache_output_add(codefile, file);
			cache_print(file);
		}
		else {
			if(!fork())
			{
				close(2); dup2(1,2);
				execve(args2[0], args2, environ);
				exit(1);
			}
			wait(0);
		}
		if(cacherule) cache_exec_add(exe, file);
		else unlink(exe);
		exit(0);
	}
}

void cache_exec(char *path, char *tmp)
{
	char *args[2];
	char full_path[PATH_STRING_LEN];
	char output[PATH_STRING_LEN];
	int fd;
	int bytes;
	
	bytes = snprintf(full_path,PATH_STRING_LEN, "%s/%s/%s", tmp, CACHE_DIR_EXE, path);
	if(bytes >= PATH_STRING_LEN) {
		printf("C binnary file path too long\n");
		return;
	}
	
	args[0] = full_path;
	args[1] = 0;
	
	if(cache && (cacherule == CACHERULE_TIME || cacherule == CACHERULE_NOINPUT && !strcmp("", getenv("ARGS"))))
	{
		bytes = snprintf(output, PATH_STRING_LEN, "%s/%s.%d.%d", tmp, path, time(0), rand());
		if(bytes >= PATH_STRING_LEN) {
			printf("HTML output file path too long\n");
			return;
		}
		if(!fork())
		{
			fd = open(output, O_WRONLY | O_CREAT);
			if(fd){ close(1); dup2(fd,1);}
			close(2); dup2(1,2);
			execve(args[0], args, environ);
			perror("Could not exec binnary C file from cache");
			close(fd);
			unlink(output);
			exit(1);
		}
		wait(0);
		cache_output_add(output, path);
		cache_print(path);
		exit(0);
	}
	else {
		close(2);
		dup2(1,2);
		execve(args[0], args, environ);
		perror("Could not exec binnary C file from cache");
		exit(1);
	}
}
