/*
 * This code is part of Screws project.
 * Copylefted by pancake@phreaker.net at 2003
 */

#include "Error.h"

/* Error strings array */
const char *SCREWS_errlist[]=
{
	"",
	"Fatal error, please take psicological help",
	"Config file not found",
	"Fatal error caused by previous errors",
	"Cannot set signal handlers",
	"Error forking",
	"Permision denied. Cannot run in daemon mode",
	"Cannot set process permisions ((e)uid/(e)gid)",
	"Cannot change to a directory",
	"Cannot set this new priority",
	"Cannot set process limits",
	"Child died by previous errors",
	"Cannot create socket",
	"Cannot bind socket",
	"Cannot listen on this socket",
	"Cannot get_host_by_name()",
	"Accept function returns an ill socket",
	"Not yet implemented",
	"Out of memory. Cannot malloc",
	"SSL not supported on directio mode",
	"Too many childrens working",
	"Integer Overflow attempt catched",
	"HTTPLEN:?",
	"Cannot open log file",
	"Connection timeout",
	"ErrPtr points to an unexistent position"
};

/* Error call func */
int
Error(str,err)
	char *str;
	unsigned int err;
{
	char *cwd;
	if ( err==ERROR_CHDIR )
	{
		cwd=(char*)getcwd((char*)0,0); // Use static instead of alloc
		if (cwd)
		{
			printf("CWD : %s",cwd);
			free(cwd);
		}
	}

	if ( err==ERROR_VOID ) return 0;

	if ( (err>ERROR_NULL) && (err<ERROR_LASTONE) )
	{
		printf("[E] *** [%s] %s.\n",str,SCREWS_errlist[err-1]);
		return err;
	}
	return 1;
}
