.TH CSIOD 1C LOCAL 
.SH NAME
csiod \- a compiler/linker for siod
.SH SYNOPSIS
.B csiod [:o=outfile] [:m=flag] [:v=flag] [:i=val] [:p=fasl] [:e=false] 
         infile ...
.SH DESCRIPTION
.I csiod
Creates the outfile, default a.out, by loading all
the expressions from the input files, and then saving the
result in fast-loading format. A "#! interpreter-name" style
header is written to the output file using information
from the optional flag arguments.

In non-unix environments, which lack the "#!" convention,
alternative techniques are used. Under WIN32 and VMS a bootstrap-exe file
is utilized. 

.RE
.SS COMMAND LINE OPTIONS
.TP 8
.BI :m=flag
The
.I flag
defaults to 2, causing the procedure main to be invoked. Use
a value of 3 for cgi scripts.
.TP
.BI :v=flag
The 
.I flag
defaults to "01" causing errors to be reported. A value of "0"
supresses error messages, higher values cause more messages.
Use a value of "1" or "0" for cgi scripts.
.TP
.BI :i=val
The 
.I val
defaults to whatever was used in the compilation of the csiod
command itself, which is /usr/local/bin/siod by default.
.TP
.BI :p=parser
The
.I parser
can be fasl or read and controls the output format of the data of the
compiler. The read format data is human readable, the fasl format data
is binary and in cases where there are many references to the same
symbol name is more compact and faster to load.

.TP
:BI :e=evalflag
The .I evalflag
defaults to false, if true then each file being compiled is loaded
with regular evaluation semantics first, then loaded again to obtain
forms for compilation. Currently this sort of thing matters only
for uses of #.read-time-eval but would be important if the compiler
was extended to do macroexpansions or other optimizations.

.SH SEE ALSO
the man pages for siod
http://people.delphi.com/gjc/siod.html
.SH AUTHOR
George Carrette, GJC\@delphi.com
