/* *******************************************************************
** Copyright (c) 2000-2011 Seiji Kaneko. All rights reserved.
** Copyright (c) 2000 earthian@tama.or.jp. All rights reserved
** Everyone is permitted to use this program in source and binary
** form, with or without modification if and only if the following
** conditions are met:
** 1. Redistributions of source code must retain the above copyright
**   notice, copyright notice written in source code, additional list
**   of conditions and the following disclaimer.
** 2. Redistributions in machine readable form must reproduce the 
**   above copyright notice and the following disclaimer in the
**   documentation or other material provided with the distribution.
** 3. Neither the name of the copyright holders nor the names of its 
**   contributors may be used to endorse or promote products derived 
**   from this software without specific prior written permission.
**********************************************************************
** Disclaimer: This software is provided and distributed AS iS, 
**	without any implicit or explicit warranties, and not
**	guaranteed to be error-free. In no event shall the author be
**	liable for any direct, indirect or incidental damages,
**	including, but not limited to, loss of data, use or profits
**	responsibility for any direct or indirect damages or results
**	arising by using whole or a part of this software.
**********************************************************************
    in_code_table.c	input-side converter code table
    $Id: in_code_table.c,v 1.138 2012/01/04 14:28:27 seiji Exp seiji $
*/

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include "skf.h"
#include "skf_fileio.h"
#include "oconv.h"
#include "convert.h"

#ifdef UNI_DECOMPOSE
#include "unicode_compose.c"
#endif

#ifndef FAST_MULT
/* ---------------------------------------------------- */
/* 94 multiplication table 				*/
/* ---------------------------------------------------- */
const int mul94[94] = {
    0,94,188,282,376,470,564,658,
    752,846,940,1034,1128,1222,1316,1410,
    1504,1598,1692,1786,1880,1974,2068,2162,
    2256,2350,2444,2538,2632,2726,2820,2914,
    3008,3102,3196,3290,3384,3478,3572,3666,
    3760,3854,3948,4042,4136,4230,4324,4418,
    4512,4606,4700,4794,4888,4982,5076,5170,
    5264,5358,5452,5546,5640,5734,5828,5922,
    6016,6110,6204,6298,6392,6486,6580,6674,
    6768,6862,6956,7050,7144,7238,7332,7426,
    7520,7614,7708,7802,7896,7990,8084,8178,
    8272,8366,8460,8554,8648,8742
};
#endif

#if !defined(OUTPUT_DYNAMIC_TABLE)
#include "in_table_defs.h"
#endif

/* ---------------------------------------------------- */
/* 94 character code group				*/
/* ---------------------------------------------------- */
unsigned short ascii_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f
};

unsigned short iso646_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x00a4,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x00af,0x007f
};

unsigned short ecma114_sp_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x00a3,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x00a7,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x00a1,0x00d1,0x00bf,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x00b0,0x00f1,0x00e7,0x007e,0x007f
};

unsigned short bs4730_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x00a3,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f
};

unsigned short nfz62010_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x00a3,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x00e0,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x00b0,0x00e7,0x00a7,0x005e,0x005f,
  0x00b5,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x00e9,0x00f9,0x00e8,0x00a8,0x007f
};

unsigned short natsfset_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x2002,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x00c4,0x00d6,0x00c5,0x25a0,0x005f,
  0x2003,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x00e4,0x00f6,0x00e5,0x00ad,0x007f
};

unsigned short natsdset_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x00ab,0x00bb,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x2002,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x00c6,0x00d8,0x00c5,0x25a0,0x005f,
  0x2003,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x00e6,0x00f8,0x00e5,0x00ad,0x007f
};

unsigned short din66003_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x00a7,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x00c4,0x00d6,0x00dc,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x00e4,0x00f6,0x00fc,0x00df,0x007f
};

unsigned short sen8502b_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x00a4,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x00c4,0x00d6,0x00c5,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x00e4,0x00f6,0x00e5,0x00af,0x007f
};

unsigned short sen8502c_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x00a4,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x00c9,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x00c4,0x00d6,0x00c5,0x00dc,0x005f,
  0x00e9,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x00e4,0x00f6,0x00e5,0x00fc,0x007f
};

/* JIS X-0201 left side			*/
unsigned short x201_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x00a5,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x203e,0x007f
};

/* JIS X-0201 right side		*/
unsigned short x201_r_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0000,0xff61,0xff62,0xff63,0xff64,0xff65,0xff66,0xff67,
  0xff68,0xff69,0xff6a,0xff6b,0xff6c,0xff6d,0xff6e,0xff6f,
  0xff70,0xff71,0xff72,0xff73,0xff74,0xff75,0xff76,0xff77,
  0xff78,0xff79,0xff7a,0xff7b,0xff7c,0xff7d,0xff7e,0xff7f,
  0xff80,0xff81,0xff82,0xff83,0xff84,0xff85,0xff86,0xff87,
  0xff88,0xff89,0xff8a,0xff8b,0xff8c,0xff8d,0xff8e,0xff8f,
  0xff90,0xff91,0xff92,0xff93,0xff94,0xff95,0xff96,0xff97,
  0xff98,0xff99,0xff9a,0xff9b,0xff9c,0xff9d,0xff9e,0xff9f,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

unsigned short gb198880_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x00a5,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x203e,0x007f
};

/* KS X-1003 */
unsigned short ks_x1003_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x20a9,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x203e,0x007f
};

/* ---------------------------------------------------- */
/* 96 character code group				*/
/* ---------------------------------------------------- */
unsigned short iso8859_1_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,
  0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,
  0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,
  0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,
  0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,
  0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,
  0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff
};

unsigned short iso8859_2_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0104,0x02d8,0x0141,0x00a4,0x013d,0x015a,0x00a7,
  0x00a8,0x0160,0x015e,0x0164,0x0179,0x00ad,0x017d,0x017b,
  0x00b0,0x0105,0x02db,0x0142,0x00b4,0x013e,0x015b,0x02c7,
  0x00b8,0x0161,0x015f,0x0165,0x017a,0x02dd,0x017e,0x017c,
  0x0154,0x00c1,0x00c2,0x0102,0x00c4,0x0139,0x0106,0x00c7,
  0x010c,0x00c9,0x0118,0x00cb,0x011a,0x00cd,0x00ce,0x010e,
  0x0110,0x0143,0x0147,0x00d3,0x00d4,0x0150,0x00d6,0x00d7,
  0x0158,0x016e,0x00da,0x0170,0x00dc,0x00dd,0x0162,0x00df,
  0x0155,0x00e1,0x00e2,0x0103,0x00e4,0x013a,0x0107,0x00e7,
  0x010d,0x00e9,0x0119,0x00eb,0x011b,0x00ed,0x00ee,0x010f,
  0x0111,0x0144,0x0148,0x00f3,0x00f4,0x0151,0x00f6,0x00f7,
  0x0159,0x016f,0x00fa,0x0171,0x00fc,0x00fd,0x0163,0x02d9
};

unsigned short iso8859_3_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0126,0x02d8,0x00a3,0x00a4,0x0000,0x0124,0x00a7,
  0x00a8,0x0130,0x015e,0x011e,0x0134,0x00ad,0x0000,0x017b,
  0x00b0,0x0127,0x00b2,0x00b3,0x00b4,0x00b5,0x0125,0x00b7,
  0x00b8,0x0131,0x015f,0x011f,0x0135,0x00bd,0x0000,0x017c,
  0x00c0,0x00c1,0x00c2,0x0000,0x00c4,0x010a,0x0108,0x00c7,
  0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x0000,0x00d1,0x00d2,0x00d3,0x00d4,0x0120,0x00d6,0x00d7,
  0x011c,0x00d9,0x00da,0x00db,0x00dc,0x016c,0x015c,0x00df,
  0x00e0,0x00e1,0x00e2,0x0000,0x00e4,0x010b,0x0109,0x00e7,
  0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x0000,0x00f1,0x00f2,0x00f3,0x00f4,0x0121,0x00f6,0x00f7,
  0x011d,0x00f9,0x00fa,0x00fb,0x00fc,0x016d,0x015d,0x02d9
};

unsigned short iso8859_4_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0104,0x0138,0x0156,0x00a4,0x0128,0x013b,0x00a7,
  0x00a8,0x0160,0x0112,0x0122,0x0166,0x00ad,0x017d,0x00af,
  0x00b0,0x0105,0x02db,0x0157,0x00b4,0x0129,0x013c,0x02c7,
  0x00b8,0x0161,0x0113,0x0123,0x0167,0x014a,0x017e,0x014b,
  0x0100,0x00c1,0x00c2,0x00c3,0x00c4,0x0139,0x00c6,0x012e,
  0x010c,0x00c9,0x0118,0x00cb,0x0116,0x00cd,0x00ce,0x012a,
  0x0110,0x0145,0x014c,0x0136,0x00d4,0x00d5,0x00d6,0x00d7,
  0x00d8,0x0172,0x00da,0x00db,0x00dc,0x0168,0x016a,0x00df,
  0x0101,0x00e1,0x00e2,0x00e3,0x00e4,0x013a,0x00e6,0x012f,
  0x010d,0x00e9,0x0119,0x00eb,0x0117,0x00ed,0x00ee,0x012b,
  0x0111,0x0146,0x014d,0x0137,0x00f4,0x00f5,0x00f6,0x00f7,
  0x00f8,0x0173,0x00fa,0x00fb,0x00fc,0x0169,0x016b,0x02d9
};

unsigned short iso8859_5_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0401,0x0402,0x0403,0x0404,0x0405,0x0406,0x0407,
  0x0408,0x0409,0x040a,0x040b,0x040c,0x00ad,0x040e,0x040f,
  0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0416,0x0417,
  0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,0x041f,
  0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,0x0426,0x0427,
  0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,0x042f,
  0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0436,0x0437,
  0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,
  0x0440,0x0441,0x0442,0x0443,0x0444,0x0445,0x0446,0x0447,
  0x0448,0x0449,0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,
  0x2116,0x0451,0x0452,0x0453,0x0454,0x0455,0x0456,0x0457,
  0x0458,0x0459,0x045a,0x045b,0x045c,0x00a7,0x045e,0x045f
};

unsigned short iso8859_6_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0000,0x0000,0x0000,0x00a4,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x060c,0x00ad,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x061b,0x0000,0x0000,0x0000,0x061f,
  0x0000,0x0621,0x0622,0x0623,0x0624,0x0625,0x0626,0x0627,
  0x0628,0x0629,0x062a,0x062b,0x062c,0x062d,0x062e,0x062f,
  0x0630,0x0631,0x0632,0x0633,0x0634,0x0635,0x0636,0x0637,
  0x0638,0x0639,0x063a,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0640,0x0641,0x0642,0x0643,0x0644,0x0645,0x0646,0x0647,
  0x0648,0x0649,0x064a,0x064b,0x064c,0x064d,0x064e,0x064f,
  0x0650,0x0651,0x0652,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

unsigned short iso8859_7_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x2018,0x2019,0x00a3,0x0000,0x0000,0x00a6,0x00a7,
  0x00a8,0x00a9,0x0000,0x00ab,0x00ac,0x00ad,0x0000,0x2015,
  0x00b0,0x00b1,0x00b2,0x00b3,0x0384,0x0385,0x0386,0x00b7,
  0x0388,0x0389,0x038a,0x00bb,0x038c,0x00bd,0x038e,0x038f,
  0x0390,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,
  0x0398,0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,0x039f,
  0x03a0,0x03a1,0x0000,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,
  0x03a8,0x03a9,0x03aa,0x03ab,0x03ac,0x03ad,0x03ae,0x03af,
  0x03b0,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,
  0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,0x03bf,
  0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,
  0x03c8,0x03c9,0x03ca,0x03cb,0x03cc,0x03cd,0x03ce,0x0000
};

unsigned short iso8859_8_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0000,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,
  0x00a8,0x00a9,0x00d7,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,
  0x00b8,0x00b9,0x00f7,0x00bb,0x00bc,0x00bd,0x00be,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2017,
  0x05d0,0x05d1,0x05d2,0x05d3,0x05d4,0x05d5,0x05d6,0x05d7,
  0x05d8,0x05d9,0x05da,0x05db,0x05dc,0x05dd,0x05de,0x05df,
  0x05e0,0x05e1,0x05e2,0x05e3,0x05e4,0x05e5,0x05e6,0x05e7,
  0x05e8,0x05e9,0x05ea,0x0000,0x0000,0x0000,0x0000,0x200f
};

unsigned short iso8859_9_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,
  0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,
  0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,
  0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x011e,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,
  0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x0130,0x015e,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,
  0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x011f,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,
  0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x0131,0x015f,0x00ff
};

unsigned short iso8859_10_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0104,0x0112,0x0122,0x012a,0x0128,0x0136,0x00a7,
  0x013b,0x0110,0x0160,0x0166,0x017d,0x00ad,0x016a,0x014a,
  0x00b0,0x0105,0x0113,0x0123,0x012b,0x0129,0x0137,0x00b7,
  0x013c,0x0111,0x0161,0x0167,0x017e,0x2015,0x016b,0x014b,
  0x0100,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x012e,
  0x010c,0x00c9,0x0118,0x00cb,0x0116,0x00cd,0x00ce,0x00cf,
  0x00d0,0x0145,0x014c,0x00d3,0x00d4,0x00d5,0x00d6,0x016a,
  0x00d8,0x0172,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x0101,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x012f,
  0x010d,0x00e9,0x0119,0x00eb,0x0117,0x00ed,0x00ee,0x00ef,
  0x00f0,0x0146,0x014d,0x00f3,0x00f4,0x00f5,0x00f6,0x016b,
  0x00f8,0x0173,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x0138
};

unsigned short iso8859_13_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x201d,0x00a2,0x00a3,0x00a4,0x201e,0x00a6,0x00a7,
  0x00d8,0x00a9,0x0156,0x00ab,0x00ac,0x00ad,0x00ae,0x00c6,
  0x00b0,0x00b1,0x00b2,0x00b3,0x201c,0x00b5,0x00b6,0x00b7,
  0x00f8,0x00b9,0x0157,0x00bb,0x00bc,0x00bd,0x00be,0x00e6,
  0x0104,0x012e,0x0100,0x0106,0x00c4,0x00c5,0x0118,0x0112,
  0x010c,0x00c9,0x0179,0x0116,0x0122,0x0136,0x012a,0x013b,
  0x0160,0x0143,0x0145,0x00d3,0x014c,0x00d5,0x00d6,0x00d7,
  0x0172,0x0141,0x015a,0x016a,0x00dc,0x017b,0x017d,0x00df,
  0x0105,0x012f,0x0101,0x0107,0x00e4,0x00e5,0x0119,0x0113,
  0x010d,0x00e9,0x017a,0x0117,0x0123,0x0137,0x012b,0x013c,
  0x0161,0x0144,0x0146,0x00f3,0x014d,0x00f5,0x00f6,0x00f7,
  0x0173,0x0142,0x015b,0x016b,0x00fc,0x017c,0x017e,0x2019
};

unsigned short iso8859_14_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x1e02,0x1e03,0x00a3,0x010a,0x010b,0x1e0a,0x00a7,
  0x1e80,0x00a9,0x1e82,0x1e0b,0x1ef2,0x00ad,0x00ae,0x0178,
  0x1e1e,0x1e1f,0x0120,0x0121,0x1e40,0x1e41,0x00b6,0x1e56,
  0x1e81,0x1e57,0x1e83,0x1e60,0x1ef3,0x1e84,0x1e85,0x1e61,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,
  0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x0174,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x1e6a,
  0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x0176,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,
  0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x0175,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x1e6b,
  0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x0177,0x00ff
};

unsigned short iso8859_15_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x00a1,0x00a2,0x00a3,0x20ac,0x00a5,0x0160,0x00a7,
  0x0161,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x017d,0x00b5,0x00b6,0x00b7,
  0x017e,0x00b9,0x00ba,0x00bb,0x0152,0x0153,0x0178,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,
  0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,
  0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,
  0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,
  0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff
};

unsigned short iso8859_16_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0104,0x0105,0x0141,0x20ac,0x201e,0x0160,0x00a7,
  0x0161,0x00a9,0x0218,0x00ab,0x0179,0x00ad,0x017a,0x017b,
  0x00b0,0x00b1,0x010c,0x0142,0x017d,0x201d,0x00b6,0x00b7,
  0x017e,0x010d,0x0219,0x00bb,0x0152,0x0153,0x0178,0x017c,
  0x00c0,0x00c1,0x00c2,0x0102,0x00c4,0x0106,0x00c6,0x00c7,
  0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x010e,
  0x0110,0x0143,0x00d2,0x00d3,0x00d4,0x0150,0x00d6,0x015a,
  0x0170,0x00d9,0x00da,0x00db,0x00dc,0x0118,0x021a,0x00df,
  0x00e0,0x00e1,0x00e2,0x0103,0x00e4,0x0107,0x00e6,0x00e7,
  0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x0111,0x0144,0x00f2,0x00f3,0x00f4,0x0151,0x00f6,0x015b,
  0x0171,0x00f9,0x00fa,0x00fb,0x00fc,0x0119,0x021b,0x00ff
};

unsigned short ecma94_c_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0452,0x0453,0x0451,0x0454,0x0455,0x0456,0x0457,
  0x0458,0x0459,0x045a,0x045b,0x045c,0x00ad,0x045e,0x045f,
  0x2116,0x0402,0x0403,0x0401,0x0404,0x0405,0x0406,0x0407,
  0x0408,0x0409,0x040a,0x040b,0x040c,0x00a4,0x040e,0x040f,
  0x044e,0x0430,0x0431,0x0446,0x0434,0x0435,0x0444,0x0433,
  0x0445,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,
  0x043f,0x044f,0x0440,0x0441,0x0442,0x0443,0x0436,0x0432,
  0x044c,0x044b,0x0437,0x0448,0x044d,0x0449,0x0447,0x044a,
  0x042e,0x0410,0x0411,0x0426,0x0414,0x0415,0x0424,0x0413,
  0x0425,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,
  0x041f,0x042f,0x0420,0x0421,0x0422,0x0423,0x0416,0x0412,
  0x042c,0x042b,0x0417,0x0428,0x042d,0x0429,0x0427,0x042a
};

unsigned short tis620_2533_uni_byte[128] = {
  0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
  0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,
  0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
  0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,
  0x00a0,0x0e01,0x0e02,0x0e03,0x0e04,0x0e05,0x0e06,0x0e07,
  0x0e08,0x0e09,0x0e0a,0x0e0b,0x0e0c,0x0e0d,0x0e0e,0x0e0f,
  0x0e10,0x0e11,0x0e12,0x0e13,0x0e14,0x0e15,0x0e16,0x0e17,
  0x0e18,0x0e19,0x0e1a,0x0e1b,0x0e1c,0x0e1d,0x0e1e,0x0e1f,
  0x0e20,0x0e21,0x0e22,0x0e23,0x0e24,0x0e25,0x0e26,0x0e27,
  0x0e28,0x0e29,0x0e2a,0x0e2b,0x0e2c,0x0e2d,0x0e2e,0x0e2f,
  0x0e30,0x0e31,0x0e32,0x0e33,0x0e34,0x0e35,0x0e36,0x0e37,
  0x0e38,0x0e39,0x0e3a,0x0000,0x0000,0x0000,0x0000,0x0e3f,
  0x0e40,0x0e41,0x0e42,0x0e43,0x0e44,0x0e45,0x0e46,0x0e47,
  0x0e48,0x0e49,0x0e4a,0x0e4b,0x0e4c,0x0e4d,0x0e4e,0x0e4f,
  0x0e50,0x0e51,0x0e52,0x0e53,0x0e54,0x0e55,0x0e56,0x0e57,
  0x0e58,0x0e59,0x0e5a,0x0e5b,0x0000,0x0000,0x0000,0x0000
};

unsigned short tcvn5712_uni_byte[128] = {
  0x00c0,0x1ea2,0x00c3,0x00c1,0x1ea0,0x1eb6,0x1eac,0x00c8,
  0x1eba,0x1ebc,0x00c9,0x1eb8,0x1ec6,0x00cc,0x1ec8,0x0128,
  0x00cd,0x1eca,0x00d2,0x1ece,0x00d5,0x00d3,0x1ecc,0x1ed8,
  0x1edc,0x1ede,0x1ee0,0x1eda,0x1ee2,0x00d9,0x1ee6,0x0168,
  0x00a0,0x0102,0x00c2,0x00ca,0x00d4,0x01a0,0x01af,0x0110,
  0x0103,0x00e2,0x00ea,0x00f4,0x01a1,0x01b0,0x0111,0x1eb0,
  0x02cb,0x02c0,0x02dc,0x02ca,0x0323,0x00e0,0x1ea3,0x00e3,
  0x00e1,0x1ea1,0x1eb2,0x1eb1,0x1eb3,0x1eb5,0x1eaf,0x1eb4,
  0x1eae,0x1ea6,0x1ea8,0x1eaa,0x1ea4,0x1ec0,0x1eb7,0x1ea7,
  0x1ea9,0x1eab,0x1ea5,0x1ead,0x00e8,0x1ec2,0x1ebb,0x1ebd,
  0x00e9,0x1eb9,0x1ec1,0x1ec3,0x1ec5,0x1ebf,0x1ec7,0x00ec,
  0x1ec9,0x1ec4,0x1ebe,0x1ed2,0x0129,0x00ed,0x1ecb,0x00f2,
  0x1ed4,0x1ecf,0x00f5,0x00f3,0x1ecd,0x1ed3,0x1ed5,0x1ed7,
  0x1ed1,0x1ed9,0x1edd,0x1edf,0x1ee1,0x1edb,0x1ee3,0x00f9,
  0x1ed6,0x1ee7,0x0169,0x00fa,0x1ee5,0x1eeb,0x1eed,0x1eef,
  0x1ee9,0x1ef1,0x1ef3,0x1ef7,0x1ef9,0x00fd,0x1ef5,0x1ed0
};

/* ---------------------------------------------------- */
/* non ISO character code group				*/
/* ---------------------------------------------------- */
unsigned short koi8_uni_byte[128] = {
  0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
  0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
  0x2591,0x2592,0x2593,0x2320,0x25a0,0x2219,0x221a,0x2248,
  0x2264,0x2265,0x00a0,0x2321,0x00b0,0x00b2,0x00b7,0x00f7,
  0x2550,0x2551,0x2552,0x0451,0x2553,0x2554,0x2555,0x2556,
  0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,
  0x255f,0x2560,0x2561,0x0401,0x2562,0x2563,0x2564,0x2565,
  0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x00a9,
  0x044e,0x0430,0x0431,0x0446,0x0434,0x0435,0x0444,0x0433,
  0x0445,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,
  0x043f,0x044f,0x0440,0x0441,0x0442,0x0443,0x0436,0x0432,
  0x044c,0x044b,0x0437,0x0448,0x044d,0x0449,0x0447,0x044a,
  0x042e,0x0410,0x0411,0x0426,0x0414,0x0415,0x0424,0x0413,
  0x0425,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,
  0x041f,0x042f,0x0420,0x0421,0x0422,0x0423,0x0416,0x0412,
  0x042c,0x042b,0x0417,0x0428,0x042d,0x0429,0x0427,0x042a
};

unsigned short koi8_u_uni_byte[128] = {
  0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
  0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
  0x2591,0x2592,0x2593,0x2320,0x25a0,0x2219,0x221a,0x2248,
  0x2264,0x2265,0x00a0,0x2321,0x00b0,0x00b2,0x00b7,0x00f7,
  0x2550,0x2551,0x2552,0x0451,0x0454,0x2554,0x0456,0x0457,
  0x2557,0x2558,0x2559,0x255a,0x255b,0x0491,0x255d,0x255e,
  0x255f,0x2560,0x2561,0x0401,0x0404,0x2563,0x0406,0x0407,
  0x2566,0x2567,0x2568,0x2569,0x256a,0x0490,0x256c,0x00a9,
  0x044e,0x0430,0x0431,0x0446,0x0434,0x0435,0x0444,0x0433,
  0x0445,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,
  0x043f,0x044f,0x0440,0x0441,0x0442,0x0443,0x0436,0x0432,
  0x044c,0x044b,0x0437,0x0448,0x044d,0x0449,0x0447,0x044a,
  0x042e,0x0410,0x0411,0x0426,0x0414,0x0415,0x0424,0x0413,
  0x0425,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,
  0x041f,0x042f,0x0420,0x0421,0x0422,0x0423,0x0416,0x0412,
  0x042c,0x042b,0x0417,0x0428,0x042d,0x0429,0x0427,0x042a
};

unsigned short cp1251_u_uni_byte[128] = {
  0x0402,0x0403,0x201a,0x0453, 0x201e,0x2026,0x2020,0x2021,
  0x20ac,0x2030,0x0409,0x2039, 0x040a,0x040c,0x040b,0x040f,
  0x0452,0x2018,0x2019,0x201c, 0x201d,0x2022,0x2013,0x2014,
  0x0000,0x2122,0x0459,0x203a, 0x045a,0x045c,0x045b,0x045f,
  0x00a0,0x040e,0x045e,0x0408, 0x00a4,0x0490,0x00a6,0x00a7,
  0x0401,0x00a9,0x0404,0x00ab, 0x00ac,0x00ad,0x00ae,0x0407,
  0x00b0,0x00b1,0x0406,0x0456, 0x0491,0x00b5,0x00b6,0x00b7,
  0x0451,0x2116,0x0454,0x00bb, 0x0458,0x0405,0x0455,0x0457,
  0x0410,0x0411,0x0412,0x0413, 0x0414,0x0415,0x0416,0x0417,
  0x0418,0x0419,0x041a,0x041b, 0x041c,0x041d,0x041e,0x041f,
  0x0420,0x0421,0x0422,0x0423, 0x0424,0x0425,0x0426,0x0427,
  0x0428,0x0429,0x042a,0x042b, 0x042c,0x042d,0x042e,0x042f,
  0x0430,0x0431,0x0432,0x0433, 0x0434,0x0435,0x0436,0x0437,
  0x0438,0x0439,0x043a,0x043b, 0x043c,0x043d,0x043e,0x043f,
  0x0440,0x0441,0x0442,0x0443, 0x0444,0x0445,0x0446,0x0447,
  0x0448,0x0449,0x044a,0x044b, 0x044c,0x044d,0x044e,0x044f
};

unsigned short mac_roman_uni_byte[128] = {
  0x00c4,0x00c5,0x00c7,0x00c9,0x00d1,0x00d6,0x00dc,0x00e1,
  0x00e0,0x00e2,0x00e4,0x00e3,0x00e5,0x00e7,0x00e9,0x00e8,
  0x00ea,0x00eb,0x00ed,0x00ec,0x00ee,0x00ef,0x00f1,0x00f3,
  0x00f2,0x00f4,0x00f6,0x00f5,0x00fa,0x00f9,0x00fb,0x00fc,
  0x2020,0x00b0,0x00a2,0x00a3,0x00a7,0x2022,0x00b6,0x00df,
  0x00ae,0x00a9,0x2122,0x00b4,0x00a8,0x2260,0x00c6,0x00d8,
  0x221e,0x00b1,0x2264,0x2265,0x00a5,0x00b5,0x2202,0x2211,
  0x220f,0x03c0,0x222b,0x00aa,0x00ba,0x03a9,0x00e6,0x00f8,
  0x00bf,0x00a1,0x00ac,0x221a,0x0192,0x2248,0x2206,0x00ab,
  0x00bb,0x2026,0x00a0,0x00c0,0x00c3,0x00d5,0x0152,0x0153,
  0x2013,0x2014,0x201c,0x201d,0x2018,0x2019,0x00f7,0x25ca,
  0x00ff,0x0178,0x2044,0x20ac,0x2039,0x203a,0xfb01,0xfb02,
  0x2021,0x00b7,0x201a,0x201e,0x2030,0x00c2,0x00ca,0x00c1,
  0x00cb,0x00c8,0x00cd,0x00ce,0x00cf,0x00cc,0x00d3,0x00d4,
  0xf8ff,0x00d2,0x00da,0x00db,0x00d9,0x0131,0x02c6,0x02dc,
  0x00af,0x02d8,0x02d9,0x02da,0x00b8,0x02dd,0x02db,0x02c7
};

unsigned short cp437_ms_uni_byte[128] = {
  0x00c7,0x00fc,0x00e9,0x00e2,0x00e4,0x00e0,0x00e5,0x00e7,
  0x00ea,0x00eb,0x00e8,0x00ef,0x00ee,0x00ec,0x00c4,0x00c5,
  0x00c9,0x00e6,0x00c6,0x00f4,0x00f6,0x00f2,0x00fb,0x00f9,
  0x00ff,0x00d6,0x00dc,0x00a2,0x00a3,0x00a5,0x20a7,0x0192,
  0x00e1,0x00ed,0x00f3,0x00fa,0x00f1,0x00d1,0x00aa,0x00ba,
  0x00bf,0x2310,0x00ac,0x00bd,0x00bc,0x00a1,0x00ab,0x00bb,
  0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
  0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
  0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
  0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
  0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
  0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
  0x03b1,0x00df,0x0393,0x03c0,0x03a3,0x03c3,0x00b5,0x03c4,
  0x03a6,0x0398,0x03a9,0x03b4,0x221e,0x03c6,0x03b5,0x2229,
  0x2261,0x00b1,0x2265,0x2264,0x2320,0x2321,0x00f7,0x2248,
  0x00b0,0x2219,0x00b7,0x221a,0x207f,0x00b2,0x25a0,0x00a0
};

/* --- EBCDIK code table --------------------------------- */
/* EBCDIK(Hitachi) -> Unic*ode				   */
/* ------------------------------------------------------- */
unsigned short ebcdik40[256] = {	/* Hitachi	   */
	0x00,0x01,0x02,0x03,0x00,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x00,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x1c,0x00,0x00,0x0a,0x00,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x1e,0x00,0x00, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0xff61,0xff62,0xff63, 		    /* 0x40-7 */
	0xff64,0xff65,0xff66,0xff67,
	0xff68,0xff69,0x5b,0x2e,0x3c,0x28,0x2b,0x21,
	0x26,0xff6a,0xff6b,0xff6c,0xff6d,0xff6e,0xff6f,0x00,/* 0x50-7 */
	0xff70,0x61,0x5d,0x24,0x2a,0x29,0x3b,0x5e,
	0x2d,0x2f,0x62,0x63,0x64,0x65,0x66,0x67, /* 0x60-7 */
	0x68,0x69,0x7c,0x2c,0x25,0x5f,0x3e,0x3f,
	0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70,0x71, /* 0x70-7 */
	0x72,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0x73,0xff71,0xff72,0xff73, 		/* 0x80-7 */
	0xff74,0xff75,0xff76,0xff77,
	0xff78,0xff79,0xff7a,0x74,0xff7b,0xff7c,0xff7d,0xff7e,
	0xff7f,0xff80,0xff81,0xff82, 		/* 0x90-7 */
	0xff83,0xff84,0xff85,0xff86,
	0xff87,0xff88,0xff89,0x75,0x76,0xff8a,0xff8b,0xff8c,
	0x77,0x7e,0xff8d,0xff8e, 		/* 0xa0-7 */
	0xff8f,0xff90,0xff91,0xff92,
	0xff93,0xff94,0xff95,0x78,0xff96,0xff97,0xff98,0xff99,
	0x79,0x7a,0x00,0x00,0x00,0x00,0x00,0x00, /* 0xb0-7 */
	0x00,0x00,0xff9a,0xff9b,0xff9c,0xff9d,0xff9e,0xff9f,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
	0xa5,0x00,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0x00,0x00,0x00,0x00,0x00,0xff
};

unsigned short ebcdic40[256] = {	/* IBM 930	   */
	0x00,0x01,0x02,0x03,0x9c,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x8f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x00,0x00,0x00,0x0a,0x17,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x00,0x00,0x04, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0xff61,0xff62,0xff63,		 /* 0x40-7 */
	0xff64,0xff65,0xff66,0xff67,
	0xff68,0xff69,0xa3,0x2e,0x3c,0x28,0x2b,0x7c,
	0x26,0xff6a,0xff6b,0xff6c,0xff6d,0xff6e,0xff6f,0x00,/* 0x50-7 */
	0xff70,0x00,0x21,0xa5,0x2a,0x29,0x3b,0xac,
	0x2d,0x2f,0x61,0x62,0x63,0x64,0x65,0x66, /* 0x60-7 */
	0x67,0x68,0x00,0x2c,0x25,0x5f,0x3e,0x3f,
	0x5b,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f, /* 0x70-7 */
	0x70,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0x5d,0xff71,0xff72,0xff73, 		 /* 0x80-7 */
	0xff74,0xff75,0xff76,0xff77,
	0xff78,0xff79,0xff7a,0x71,0xff7b,0xff7c,0xff7d,0xff7e,
	0xff7f,0xff80,0xff81,0xff82, 		 /* 0x90-7 */
	0xff83,0xff84,0xff85,0xff86,
	0xff87,0xff88,0xff89,0x72,0x00,0xff8a,0xff8b,0xff8c,
	0x7e,0x203e,0xff8d,0xff8e, 		 /* 0xa0-7 */
	0xff8f,0xff90,0xff91,0xff92,
	0xff93,0xff94,0xff95,0x73,0xff96,0xff97,0xff98,0xff99,
	0x5e,0xa2,0x5c,0x74,0x75,0x76,0x77,0x78, /* 0xb0-7 */
	0x79,0x7a,0xff9a,0xff9b,0xff9c,0xff9d,0xff9e,0xff9f,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
	0x24,0x00,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0x00,0x00,0x00,0x00,0x00,0x00
};

unsigned short ebcdicn40[256] = {	/* NEC		   */
	0x00,0x01,0x02,0x03,0x00,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x00,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x1c,0x00,0x00,0x0a,0x00,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x1e,0x00,0x00, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0xff61,0xff62,0xff63, 		 /* 0x40-3 */
	0xff64,0xff65,0xff66,0xff67,
	0xff68,0xff69,0x5b,0x2e,0x3c,0x28,0x2b,0x21,
	0x26,0xff6a,0xff6b,0xff6c,0xff6d,0xff6e,0xff6f,0x61,/* 0x50-7 */
	0xff70,0x62,0x5d,0xa5,0x2a,0x29,0x3b,0x5e,
	0x2d,0x2f,0x63,0x64,0x65,0x66,0x67,0x68, /* 0x60-7 */
	0x69,0x6a,0x7c,0x2c,0x25,0x5f,0x3e,0x3f,
	0x6b,0x6c,0x6d,0x6e,0x6f,0x70,0x71,0x72, /* 0x70-7 */
	0x73,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0x74,0xff71,0xff72,0xff73, 		 /* 0x80-7 */
	0xff74,0xff75,0xff76,0xff77,
	0xff78,0xff79,0xff7a,0x75,0xff7b,0xff7c,0xff7d,0xff7e,
	0xff7f,0xff80,0xff81,0xff82, 		 /* 0x90-7 */
	0xff83,0xff84,0xff85,0xff86,
	0xff87,0xff88,0xff89,0x76,0x77,0xff8a,0xff8b,0xff8c,
	0x78,0x00,0xff8d,0xff8e,0xff8f,0xff90,0xff91,0xff92,/* 0xa0-7 */
	0xff93,0xff94,0xff95,0x79,0xff96,0xff97,0xff98,0xff99,
	0x7a,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0xb0-7 */
	0x00,0x00,0xff9a,0xff9b,0xff9c,0xff9d,0xff9e,0xff9f,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
	0x24,0x00,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0x00,0x00,0x00,0x00,0x00,0xff
};

unsigned short ebcdics40[256] = { /* Fujitsu EBCDIC SMALL LATIN  */
	0x00,0x01,0x02,0x03,0x00,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x00,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x1c,0x00,0x00,0x0a,0x00,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x1e,0x00,0x00, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0x00,0xff61,0xff62,0xff63,0xff64,0xff65,0xff66,/* 0x40-7 */
	0xff67,0xff68,0xa3,0x2e,0x3c,0x28,0x2b,0x21,
	0x26,0xff69,0xff6a,0xff6b, 		 /* 0x50-3 */
	0xff6c,0xff6d,0xff6e,0xff6f,
	0xff70,0xff71,0x5d,0xa5,0x2a,0x29,0x3b,0x5e,
	0x2d,0x2f,0xff72,0xff73,0xff74,0xff75,0xff76,0xff77,/* 0x60-7 */
	0xff78,0xff79,0x7c,0x2c,0x25,0x5f,0x3e,0x3f,
	0xff7a,0xff7b,0xff7c,0xff7d,		 /* 0x70-3 */
	0xff7e,0xff7f,0xff80,0xff81,
	0xff82,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0xff83,0x61,0x62,0x63,0x64,0x65,0x66,0x67, /* 0x80-7 */
	0x68,0x69,0xff84,0xff85,0xff86,0xff87,0xff88,0xff89,
	0xff8a,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70, /* 0x90-7 */
	0x71,0x72,0xff8b,0xff8c,0xff8d,0xff8e,0xff8f,0xff90,
	0xff91,0x7e,0x73,0x74,0x75,0x76,0x77,0x78, /* 0xa0-7 */
	0x79,0x7a,0xff92,0xff93,0xff94,0xff95,0xff96,0xff97,
	0xff98,0xff99,0xff9a,0xff9b,		 /* 0xb0-7 */
	0xff9c,0xff9d,0xff9e,0xff9f,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
	0xa5,0x00,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0x00,0x00,0x00,0x00,0x00,0xff
};

unsigned short ebcdic41[256] = {	/* IBM 933	   */
	0x00,0x01,0x02,0x03,0x9c,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x8f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x00,0x00,0x00,0x0a,0x17,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x00,0x00,0x04, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0x00,0xffa0,0xffa1,		 /* 0x40-7 */
	0xffa2,0xffa3,0xffa4,0xffa5,
	0xffa6,0xffa7,0xa2,0x2e,0x3c,0x28,0x2b,0x7c,
	0x26,0x00,0xffa8,0xffa9,		 /* 0x50-7 */
	0xffaa,0xffab,0xffac,0xffad,
	0xffae,0xffaf,0x21,0x24,0x2a,0x29,0x3b,0xac,
	0x2d,0x2f,0xffb0,0xffb1,		 /* 0x60-7 */
	0xffb2,0xffb3,0xffb4,0xffb5,
	0xffb6,0xffb7,0xa6,0x2c,0x25,0x5f,0x3e,0x3f,
	0x5b,0x00,0xffb8,0xffb9,		 /* 0x70-7 */
	0xffba,0xffbb,0xffbc,0xffbd,
	0xffbe,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0x5d,0x61,0x62,0x63,0x64,0x65,0x66,0x67, /* 0x80-7 */
	0x68,0x69,0xffc2,0xffc3,0xffc4,0xffc5,0xffc6,0xffc7,
	0x00,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70, /* 0x90-7 */
	0x71,0x72,0xffca,0xffcb,0xffcc,0xffcd,0xffce,0xffcf,
	0x203e,0x7e,0x73,0x74,0x75,0x76,0x77,0x78, /* 0xa0-7 */
	0x79,0x7a,0xffd2,0xffd3,0xffd4,0xffd5,0xffd6,0xffd7,
	0x5e,0x00,0x5c,0x00,0x00,0x00,0x00,0x00, /* 0xb0-7 */
	0x00,0x00,0xffda,0xffdb,0xffdc,0x00,0x00,0x00,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
	0x20a9,0x00,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0x00,0x00,0x00,0x00,0x00,0x00
};

unsigned short ebcdic42[256] = {	/* IBM 935	   */
	0x00,0x01,0x02,0x03,0x9c,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x8f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x00,0x00,0x00,0x0a,0x17,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x00,0x00,0x04, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x40-7 */
	0x00,0x00,0xa2,0x2e,0x3c,0x28,0x2b,0x7c,
	0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x50-7 */
	0x00,0x00,0x21,0xa5,0x2a,0x29,0x3b,0xac,
	0x2d,0x2f,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x60-7 */
	0x00,0x00,0xa6,0x2c,0x25,0x5f,0x3e,0x3f,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x70-7 */
	0x00,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0x00,0x61,0x62,0x63,0x64,0x65,0x66,0x67, /* 0x80-7 */
	0x68,0x69,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70, /* 0x90-7 */
	0x71,0x72,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x7e,0x73,0x74,0x75,0x76,0x77,0x78, /* 0xa0-7 */
	0x79,0x7a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x5e,0x00,0x5c,0x00,0x00,0x00,0x00,0x00, /* 0xb0-7 */
	0x00,0x00,0x5b,0x5d,0x00,0x00,0x00,0x00,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
	0x24,0x00,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0x00,0x00,0x00,0x00,0x00,0x00
};

unsigned short ebcdic43[256] = {	/* IBM 937	   */
	0x00,0x01,0x02,0x03,0x9c,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x8f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x00,0x00,0x00,0x0a,0x17,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x00,0x00,0x04, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x40-7 */
	0x00,0x00,0xa2,0x2e,0x3c,0x28,0x2b,0x7c,
	0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x50-7 */
	0x00,0x00,0x21,0x24,0x2a,0x29,0x3b,0xac,
	0x2d,0x2f,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x60-7 */
	0x00,0x00,0xa6,0x2c,0x25,0x5f,0x3e,0x3f,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0x70-7 */
	0x00,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0x00,0x61,0x62,0x63,0x64,0x65,0x66,0x67, /* 0x80-7 */
	0x68,0x69,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70, /* 0x90-7 */
	0x71,0x72,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x7e,0x73,0x74,0x75,0x76,0x77,0x78, /* 0xa0-7 */
	0x79,0x7a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x5e,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* 0xb0-7 */
	0x00,0x00,0x5b,0x5d,0x00,0x00,0x00,0x00,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
	0x5c,0x00,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0x00,0x00,0x00,0x00,0x00,0x00
};

unsigned short ebcdic44[256] = {	/* IBM 037	   */
	0x00,0x01,0x02,0x03,0x9c,0x09,0x00,0x7f, /* 0x00-7 */
	0x00,0x00,0x00,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x00,0x0a,0x08,0x00, /* 0x10-7 */
	0x18,0x19,0x00,0x8f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x00,0x00,0x00,0x00,0x0a,0x17,0x1b, /* 0x20-7 */
	0x00,0x00,0x00,0x00,0x00,0x05,0x06,0x07,
	0x00,0x00,0x16,0x00,0x00,0x00,0x00,0x04, /* 0x30-7 */
	0x00,0x00,0x00,0x00,0x14,0x15,0x00,0x1a,
	0x20,0xa0,0xe2,0xe4,0xe0,0xe1,0xe3,0xe5, /* 0x40-7 */
	0xe7,0xf1,0xa2,0x2e,0x3c,0x28,0x2b,0x7c,
	0x26,0xe9,0xea,0xeb,0xe8,0xed,0xee,0xef, /* 0x50-7 */
	0xec,0xdf,0x21,0x24,0x2a,0x29,0x3b,0xac,
	0x2d,0x2f,0xc2,0xc4,0xc0,0xc1,0xc3,0xc5, /* 0x60-7 */
	0xc7,0xd1,0xa6,0x2c,0x25,0x5f,0x3e,0x3f,
	0xf8,0xc9,0xca,0xcb,0xc8,0xcd,0xce,0xcf, /* 0x70-7 */
	0xcc,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,
	0xd8,0x61,0x62,0x63,0x64,0x65,0x66,0x67, /* 0x80-7 */
	0x68,0x69,0xab,0xbb,0xf0,0xfd,0xfe,0xb1,
	0xb0,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70, /* 0x90-7 */
	0x71,0x72,0xaa,0xba,0xe6,0xb8,0xc6,0xa4,
	0xb5,0x7e,0x73,0x74,0x75,0x76,0x77,0x78, /* 0xa0-7 */
	0x79,0x7a,0xa1,0xbf,0xd0,0xdd,0xde,0xae,
	0x5e,0xa3,0xa5,0xb7,0xa9,0xa7,0xb6,0xbc, /* 0xb0-7 */
	0xbd,0xbe,0x5b,0x5d,0xaf,0xa8,0xb4,0xd7,
	0x7b,0x41,0x42,0x43,0x44,0x45,0x46,0x47, /* 0xc0-7 */
	0x48,0x49,0xad,0xf4,0xf6,0xf2,0xf3,0xf5,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50, /* 0xd0-7 */
	0x51,0x52,0xb9,0xfb,0xfc,0xf9,0xfa,0xff,
	0x5c,0xf7,0x53,0x54,0x55,0x56,0x57,0x58, /* 0xe0-7 */
	0x59,0x5a,0xb2,0xd4,0xd6,0xd2,0xd3,0xd5,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, /* 0xf0-7 */
	0x38,0x39,0xb3,0xdb,0xdc,0xd9,0xda,0x00
};

#if !defined(OUTPUT_DYNAMIC_TABLE)
/* ---------------------------------------------------- */
/* conversion support tables 				*/
/* ---------------------------------------------------- */
/* --------------------------------------------------------------- */
/* X0201 kana to ucs2						   */
/* --------------------------------------------------------------- */
const unsigned char uni_t_x201[63] = 
{
         0x02,0x0c,0x0d,0x01,0xfb,0xf2,0xa1,
    0xa3,0xa5,0xa7,0xa9,0xe3,0xe5,0xe7,0xc3,
    0xfc,0xa2,0xa4,0xa6,0xa8,0xaa,0xab,0xad,
    0xaf,0xb1,0xb3,0xb5,0xb7,0xb9,0xbb,0xbd,
    0xbf,0xc1,0xc4,0xc6,0xc8,0xca,0xcb,0xcc,
    0xcd,0xce,0xcf,0xd2,0xd5,0xd8,0xdb,0xde,
    0xdf,0xe0,0xe1,0xe2,0xe4,0xe6,0xe8,0xe9,
    0xea,0xeb,0xec,0xed,0xef,0xf3,0x99,0x9a
};

/* ---------------------------------------------------- */
/* IBM gaiji area					*/
/* ---------------------------------------------------- */
unsigned short uni_k_ibm_fa[28] = {
    0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
    0x2178, 0x2179, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165,
    0x2166, 0x2167, 0x2168, 0x2169, 0xffe2, 0xffe4, 0xff07, 0xff02,
    0x3231, 0x2116, 0x2121, 0x2235
};

/* ---------------------------------------------------- */
/* Table registry: entries				*/
/* ---------------------------------------------------- */

/* --------------------------------------------------------------- */
/* ESC-(-? : iso sequence (1) for domestic character set	   */
/* --------------------------------------------------------------- */
struct iso_byte_defs iso_unibyte_defs[] = {
  {'J',1,128,x201_uni_byte,FALSE,NULL,L_NU,NULL,
	"JIS X0201 Roman","jis_c6220-1969-ro"},
  {'@',1,128,iso646_uni_byte,FALSE,NULL,L_NU,NULL,"ISO 646 IRV","iso646irv"},
  {'A',1,128,bs4730_uni_byte,FALSE,NULL,L_GB,NULL,"BS 4730(UK)","bs_4730"},
/* Note : Do not move ascii. Used in esc_process.c		   */
  {'B',1,128,ascii_uni_byte,FALSE,NULL,L_NU,NULL,"ASCII(ANSI X3.4)","ascii"},
  {'C',1,128,natsfset_uni_byte,COD_USS,NULL,L_SV,NULL,
	"NATS for Finland/Sweden","nats-sefi"},
  {'E',1,128,natsdset_uni_byte,COD_USS,NULL,L_DK,NULL,
	"NATS for Denmark/Norway","nats-dano"},
  {'G',1,128,sen8502b_uni_byte,FALSE,NULL,L_SV,NULL,
	"ISO 646 Swedish(SEN 850200-B)","sen_850200_b"},
  {'H',1,128,sen8502c_uni_byte,FALSE,NULL,L_SV,NULL,
	"ISO 646 Swedish(SEN 850200-C)","sen_850200_c"},
  {'I',1,128,x201_r_uni_byte,COD_IS_KANA,NULL,L_JP,NULL,
	"JIS X0201 Kana","jis_c6220-1969-jp"},
  {'K',1,128,din66003_uni_byte,FALSE,NULL,L_DE,NULL,
	"ISO 646 German(DIN66003)","din_66003"},
  {'R',1,128,nfz62010_uni_byte,FALSE,NULL,L_FR,NULL,
	"ISO 646 French(obsolete)",NULL},
  {'T',1,128,gb198880_uni_byte,FALSE,NULL,L_ZH,
	NULL,"GB 1988-80","gb_1988"},
  {'W',1,128,iso646_inis_s_uni_byte,FALSE,NULL,L_NU,
	NULL,"ISO 646 INIS subset","inis"},
  {'Z',1,128,ecma114_sp_uni_byte,FALSE,NULL,L_ES,NULL,
	"ECMA114 Spanish","es"},
  {'f',1,128,nfz62010_uni_byte,FALSE,NULL,L_FR,NULL,
	"ISO 646 French(NF Z 62-010)","nfz62010"},
/* dynamic loading area */
  {'D',1,128,nats_add_uni_byte,FALSE,NULL,L_NU,NULL,
	"NATS additional for Finland/Sweden","nats-sefi-add"},
  {'F',1,128,nats_add_den_uni_byte,FALSE,NULL,L_NU,NULL,
	"NATS additional for Denmark","nats-dano-add"},
  {'L',1,128,iso646_po_o_uni_byte,FALSE,NULL,L_PT,NULL,
	"ISO 646 Portuguese(Olivetti)","pt"},
 {'M',1,128,din31625_uni_byte,FALSE,NULL,L_NU,NULL,
	"DIN 31625-ISO6438","din31625"},
  {'N',1,128,iso5427_uni_byte,FALSE,NULL,L_RU,NULL,
	"ISO 5427(Basic)","iso_5427"},
  {'O',1,128,din31624_uni_byte,FALSE,NULL,L_NU,NULL,"DIN 31624","din31624"},
  {'P',1,128,iso5426_80_uni_byte,FALSE,NULL,L_NU,NULL,
	"ISO 5426(Extension)","iso5426-ext"},
  {'Q',1,128,iso5427_s_uni_byte,FALSE,NULL,L_NU,NULL,
	"ISO 5427(Extension)","iso5427:1981"},
  {'S',1,128,iso5428_1_uni_byte,FALSE,NULL,L_EL,NULL,
	"ISO 5428-1976 Biblio Greek set","iso5428:1980"},
  {'U',1,128,ecma114_gr_uni_byte,FALSE,NULL,L_EL,NULL,
	"ECMA114 Greek(Honeywell-Bull)","latin-greek-1"},
  {'V',1,128,uk_tele_uni_byte,FALSE,NULL,L_NU,NULL,"UK Teletext",
	"bs_viewdata"},
  {'X',1,128,NULL,FALSE,NULL,L_NU,NULL,"ISO 5428-1980","iso5428"},
  {'Y',1,128,iso646_it_o_uni_byte,FALSE,NULL,L_IT,NULL,
	"ISO 646 Itarian(Olivetti)","it"},
  {'[',1,128,ecma114_gr2_uni_byte,FALSE,NULL,L_EL,NULL,
	"ISO 646 Greek(Olivetti)","greek7-old"},
  {0x5c,1,128,oli_greek_uni_byte,FALSE,NULL,L_EL,NULL,
	"ISO 646 Latin-Greek(Olivetti)","latin-greek"},
  {']',1,128,inis_ns_uni_byte,FALSE,NULL,L_NU,NULL,
	"INIS non-standard","inis-8"},
 {'^',1,128,inis_cyl_uni_byte,FALSE,NULL,L_RU,NULL,
	"INIS Cyrillic","inis-cyrillic"},
 {'_',1,128,codar_u_uni_byte,FALSE,NULL,L_AR,NULL,"Arabes codar-U","codar-u"},
 {0x60,1,128,iso646_ns4551_uni_byte,FALSE,NULL,L_NO,NULL,
	"NS-4551(Norwegian)-v1","ns4551-1"},
  {'b',1,128,videotex_sp1_uni_byte,FALSE,NULL,L_NU,NULL,
	"CCITT Videotex 1st Supplementary","videotex-suppl"},
 {'c',1,128,NULL,FALSE,NULL,L_NU,NULL,"CCITT Videotex 2nd Supplementary",NULL},
 {'d',1,128,NULL,FALSE,NULL,L_NU,NULL,"CCITT Videotex 3rd Supplementary",NULL},
  {'e',1,128,apl_uni_byte,FALSE,NULL,L_NU,NULL,"APL Canada","apl"},
  {'g',1,128,iso646_po_i_uni_byte,FALSE,NULL,L_PT,NULL,
	"ISO 646 Portuguese(IBM)","pt2"},
  {'h',1,128,iso646_sp_i_uni_byte,FALSE,NULL,L_ES,NULL,
	"ISO 646 Spanish(IBM)","es2"},
 {'i',1,128,msz7795_uni_byte,FALSE,NULL,L_HU,NULL,
	"Hungarian MSZ 7795/3","msz_7795.3"},
  {'k',1,128,iso9036_uni_byte,FALSE,NULL,L_AR,NULL,
	"ISO 9036(Arabic/ASMO449)","asmo_449"},
  {'l',1,128,iso6937_sp2_uni_byte,FALSE,NULL,L_NU,NULL,
	"ISO 6937/2 Supplementary 2","iso-ir-90"},
  {'m',1,128,x9010_a_uni_byte,FALSE,NULL,L_JP,NULL,
	"JIS X9010 OCR-A","jis_c6229-1984-a"},
  {'n',1,128,x201_uni_byte,FALSE,NULL,L_JP,NULL,
	"JIS X9010 OCR-B","jis_c6229-1984-b"},
  {'o',1,128,x9010_ba_uni_byte,FALSE,NULL,L_JP,NULL,
	"JIS X9010 OCR-B addition","jis_c6229-1984-b-add"},
  {'p',1,128,x9010_h_uni_byte,FALSE,NULL,L_JP,NULL,
	"JIS X9010 OCR-Handwriting","jis_c6229-1984-hand"},
  {'q',1,128,x9010_oa_uni_byte,FALSE,NULL,L_JP,NULL,
	"JIS X9010 OCR-Additional","jis_c6229-1984-hand-add"},
 {'r',1,128,x201_r_uni_byte,COD_IS_KANA,NULL,L_JP,NULL,
	"JIS X9010 OCR-kana","jis_c6229-1984-kana"},
 {'s',1,128,x9010_e13_uni_byte,FALSE,NULL,L_NU,NULL,
	"JIS X9010 OCR-e13b","iso_2033-1983"},
 {'u',1,128,t61_1_uni_byte,FALSE,NULL,L_NU,NULL,
	"CCITT Teletext Rec.T61-1st","t.61-7bit"},
 {'v',1,128,t61_2_uni_byte,FALSE,NULL,L_NU,NULL,
	"CCITT Teletext Rec.T61-2nd","t.61-8bit"},
 {'w',1,128,csa_z243_1_uni_byte,FALSE,NULL,L_NU,NULL,
	"CSA Z243.4 1st set","csa-z243.4-1985-1"},
 {'x',1,128,csa_z243_2_uni_byte,FALSE,NULL,L_NU,NULL,
	"CSA Z243.4 2nd set","csa-z243.4-1985-2"},
 {'y',1,128,NULL,FALSE,NULL,L_NU,NULL,"CCITT Mosaic Rec.T101",NULL},
 {'z',1,128,serb_slov_uni_byte,FALSE,NULL,L_SL,NULL,
	"Serbocroatian-Slovenian Cyrillic JUS_I.B1.002","jus_i.b1.002"},
 {'{',1,128,serb_uni_byte,FALSE,NULL,L_SR,NULL,
	"Serbocroatian Cyrillic","jus_i.b1.003-serb"},
 {'|',1,128,ccitt_mt101_2_uni_byte,FALSE,NULL,L_NU,NULL,
	"CCITT Mosaic Rec.T101-2nd","t.101-g2"},
 {'}',1,128,macd_uni_byte,FALSE,NULL,L_NU,NULL,
	"Macedonian Cyrillic","jus_i.b1.004-mac"},
 {0x61,1,128,iso646_ns4551_2_uni_byte,FALSE,NULL,L_NO,NULL,
	"NS-4551(Norwegian)-v2","ns4551-2"},
 {0x00,0,0,NULL,FALSE,NULL,L_NU,NULL,NULL,NULL}   /* is last entry   */
};

#define x0201_index 		0	/* @ISOBYTEDEFINDEX@ */
#define iso646_irv_index 	1	/* @ISOBYTEDEFINDEX@ */
#define bs4730_index 		2	/* @ISOBYTEDEFINDEX@ */
#define ascii_index 		3	/* @ISOBYTEDEFINDEX@ */
#define nats_f_a_index 		4	/* @ISOBYTEDEFINDEX@ */
#define nats_d_a_index 		5	/* @ISOBYTEDEFINDEX@ */
#define sen8502_b_index		6	/* @ISOBYTEDEFINDEX@ */
#define sen8502_c_index		7	/* @ISOBYTEDEFINDEX@ */
#define x0201r_index 		8	/* @ISOBYTEDEFINDEX@ */
#define din66083_index 		9	/* @ISOBYTEDEFINDEX@ */
#define nfz62010_old_index 	10	/* @ISOBYTEDEFINDEX@ */
#define gb198880_index	 	11	/* @ISOBYTEDEFINDEX@ */
#define inis_iso646_index	12	/* @ISOBYTEDEFINDEX@ */
#define ecma114_sp_index	13	/* @ISOBYTEDEFINDEX@ */
#define nfz62010_index 		14	/* @ISOBYTEDEFINDEX@ */
#define nats_a_index		15	/* @ISOBYTEDEFINDEX@ */
#define nats_ad_index		16	/* @ISOBYTEDEFINDEX@ */
#define iso646_p_index		17	/* @ISOBYTEDEFINDEX@ */
#define din31625_index		18	/* @ISOBYTEDEFINDEX@ */
#define iso5427b_index		19	/* @ISOBYTEDEFINDEX@ */
#define din31624_index		20	/* @ISOBYTEDEFINDEX@ */
#define iso5426_index		21	/* @ISOBYTEDEFINDEX@ */
#define iso5427e_index		22	/* @ISOBYTEDEFINDEX@ */
#define bib_gr_index		23	/* @ISOBYTEDEFINDEX@ */
#define ecma_gr_b_index		24	/* @ISOBYTEDEFINDEX@ */
#define uk_tele_index		25	/* @ISOBYTEDEFINDEX@ */
#define iso5428_index		26	/* @ISOBYTEDEFINDEX@ */
#define iso646_it_index		27	/* @ISOBYTEDEFINDEX@ */
#define iso646_gro_index	28	/* @ISOBYTEDEFINDEX@ */
#define iso646_lgo_index	29	/* @ISOBYTEDEFINDEX@ */
#define inis_ns_index		30	/* @ISOBYTEDEFINDEX@ */
#define inis_cr_index		31	/* @ISOBYTEDEFINDEX@ */
#define arabes_index		32	/* @ISOBYTEDEFINDEX@ */
#define ns4551_index		33	/* @ISOBYTEDEFINDEX@ */
#define videotex_1s_index	34	/* @ISOBYTEDEFINDEX@ */
#define videotex_2s_index	35	/* @ISOBYTEDEFINDEX@ */
#define videotex_3s_index	36	/* @ISOBYTEDEFINDEX@ */
#define apl_can_index		37	/* @ISOBYTEDEFINDEX@ */
#define iso646_pri_index	38	/* @ISOBYTEDEFINDEX@ */
#define iso646_spi_index	39	/* @ISOBYTEDEFINDEX@ */
#define iso646_hui_index	40	/* @ISOBYTEDEFINDEX@ */
#define iso9036_index		41	/* @ISOBYTEDEFINDEX@ */
#define iso6937_sp2_index	42	/* @ISOBYTEDEFINDEX@ */
#define x9010_a_index		43	/* @ISOBYTEDEFINDEX@ */
#define x9010_b_index		44	/* @ISOBYTEDEFINDEX@ */
#define x9010_ba_index		45	/* @ISOBYTEDEFINDEX@ */
#define x9010_ocr_index		46	/* @ISOBYTEDEFINDEX@ */
#define x9010_ocre_index	47	/* @ISOBYTEDEFINDEX@ */
#define x9010_k_index		48	/* @ISOBYTEDEFINDEX@ */
#define x9010_e_index		49	/* @ISOBYTEDEFINDEX@ */
#define teletxt_t61_1_index	50	/* @ISOBYTEDEFINDEX@ */
#define teletxt_t61_2_index	51	/* @ISOBYTEDEFINDEX@ */
#define csa_z243_1_index	52	/* @ISOBYTEDEFINDEX@ */
#define csa_z243_2_index	53	/* @ISOBYTEDEFINDEX@ */
#define mosaic_t101_index	54	/* @ISOBYTEDEFINDEX@ */
#define serb_slov_index		55	/* @ISOBYTEDEFINDEX@ */
#define serb_cyr_index		56	/* @ISOBYTEDEFINDEX@ */
#define mosaic_t101_2_index	57	/* @ISOBYTEDEFINDEX@ */
#define macedonian_index	58	/* @ISOBYTEDEFINDEX@ */
#define ns4551_2_index		59	/* @ISOBYTEDEFINDEX@ */
#define iso_unibyte_tail	60	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* ESC-'-'-? : iso-2022 96 character set			   */
/* --------------------------------------------------------------- */
struct iso_byte_defs iso_iso8859_defs[] = {
  {'@',1,128,ecma94_c_uni_byte,COD_SET96,NULL,L_RU,NULL,
	"ECMA-94 Cyrillic","ecma-cyrillic"},
  {'A',1,128,iso8859_1_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-1",
	"iso-8859-1"},
  {'B',1,128,iso8859_2_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-2",
	"iso-8859-2"},
  {'C',1,128,iso8859_3_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-3",
	"iso-8859-3"},
  {'D',1,128,iso8859_4_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-4",
	"iso-8859-4"},
  {'L',1,128,iso8859_5_uni_byte,COD_SET96,NULL,L_RU,NULL,"ISO 8859-5",
	"iso-8859-5"},
  {'G',1,128,iso8859_6_uni_byte,COD_SET96,NULL,L_AR,NULL,"ISO 8859-6",
	"iso-8859-6"},
  {'F',1,128,iso8859_7_uni_byte,COD_SET96,NULL,L_EL,NULL,"ISO 8859-7",
	"iso-8859-7"},
  {'H',1,128,iso8859_8_uni_byte,COD_SET96,NULL,L_HE,NULL,"ISO 8859-8",
	"iso-8859-8"},
  {'M',1,128,iso8859_9_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-9",
	"iso-8859-9"},
  {'T',1,128,tis620_2533_uni_byte,COD_SET96,NULL,L_TH,NULL,
	"ISO 8859-11/TIS 620","tis-620"},
  {'V',1,128,iso8859_10_uni_byte,COD_SET96,NULL,L_IS,NULL,"ISO 8859-10",
	"iso-8859-10"},
  {'Y',1,128,iso8859_13_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-13",
	"iso-8859-13"},
  {'Z',1,128,tcvn5712_uni_byte,COD_SET96,NULL,L_VI,NULL,
	"TCVN 5712(VSCII-II)","tcvn"},
  {'_',1,128,iso8859_14_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-14",
	"iso-8859-14"},
  {'b',1,128,iso8859_15_uni_byte,COD_SET96,NULL,L_NU,NULL,"ISO 8859-15",
	"iso-8859-15"},
  {'f',1,128,iso8859_16_uni_byte,COD_SET96,NULL,L_RO,NULL,"ISO 8859-16",
	"iso-8859-16"},
/* dynamic loading area */
  {'E',1,128,csa_z243_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"CSA Z243.4 Supplementary","csa-z243.4-1985-gr"},
  {'I',1,128,csn369103_uni_byte,COD_SET96,NULL,L_CS,NULL,
	"CSN 369103 Czechoslovak","csn_369103"},
  {'J',1,128,iso6937_a1_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 6937/2 + Addendum 1","iso_6937-2-add"},
  {'K',1,128,tech_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"Technical Set(Philips)","iec_p27-1"},
  {'N',1,128,iso6937_2_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 6937/2 Residual","iso_6937-2-25"},
  {'O',1,128,gost19768_uni_byte,COD_SET96,NULL,L_RU,NULL,
	"Cyrillic GOST 19768-74","gost_19768-74"},
  {'P',1,128,iso8859_sp_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 8859 supplement","iso8859-supp"},
  {'Q',1,128,box_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 10367 Box Drawing","iso_10367-box"},
  {'R',1,128,iso6937_sp_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 6937 Supplement","iso_6937-supp"},
  {'S',1,128,ir164_uni_byte,COD_SET96,NULL,L_HE,NULL,
	"CCITT Hebrew(ISO-IR-164)","ir164"},
  {'U',1,128,ir167_uni_byte,COD_SET96,NULL,L_AR,NULL,
	"Arabic/French/German(ISO-IR-167)","ir167"},
  {'X',1,128,iso4873_sami_uni_byte,COD_SET96,NULL,L_SE,NULL,
	"Sami Supplement(ISO-4873)","latin-lap"},
  {'[',1,128,iec1289_uni_byte,COD_SET96,NULL,L_SE,NULL,
	"IEC 1289 Technical set","iec1289"},
  {0x5c,1,128,iso8859_1w_uni_byte,COD_SET96,NULL,L_CY,NULL,
	"ISO 8859-1 Welsh Variant","iso8859-1-welsh"},
  {']',1,128,sami_sp1_uni_byte,COD_SET96,NULL,L_SE,NULL,
	"Sami(Norwegian) Supplement Latin","sami-nor-supp"},
  {'^',1,128,ir197_uni_byte,COD_SET96,NULL,L_HE,NULL,
	"Latin/Hebrew(ISO-IR-198)","ir198"},
  {0x60,1,128,uralic_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"Uralic supplementary Cyrillic","uralic-supp"},
  {'a',1,128,volg_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"Volgaic supplementary Cyrillic","volgaic-supp"},
  {'c',1,128,iso8859_1e_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 8859-1 with Euro","iso8859-1-euro"},
  {'d',1,128,iso8859_4e_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 8859-4 with Euro","iso8859-4-euro"},
  {'e',1,128,iso8859_13e_uni_byte,COD_SET96,NULL,L_NU,NULL,
	"ISO 8859-13 with Euro","iso8859-13-euro"},
  {'g',1,128,is434_uni_byte,COD_SET96,NULL,L_GA,NULL,
	"Irish Ogham(I.S.434)","is434"},
  {'h',1,128,sami_sp2_uni_byte,COD_SET96,NULL,L_SE,NULL,
	"Sami(Finnish) Supplement Latin","sami-fin-supp"},
  {'i',1,128,rh_greek_uni_byte,COD_SET96,NULL,L_EL,NULL,
	"Right-hand Latin/Greek","latin-greek8"},
  {'j',1,128,si1311_uni_byte,COD_SET96,NULL,L_HE,NULL,
	"Latin/Heblew for 8-bit","latin-hebrew8"},
  {'}',1,128,NULL,COD_SET96,NULL,L_NU,NULL,
	"CCITT Mosaic Rec.101 Set.3",NULL},
  {0x00,0,0,NULL,COD_SET96,NULL,L_NU,NULL,NULL,NULL}	/* is last entry   */
};

#define ecma113_c_index  0	/* @ISOBYTEDEFINDEX@ */
#define iso8859_1_index 1	/* @ISOBYTEDEFINDEX@ */
#define iso8859_2_index 2	/* @ISOBYTEDEFINDEX@ */
#define iso8859_3_index 3	/* @ISOBYTEDEFINDEX@ */
#define iso8859_4_index 4	/* @ISOBYTEDEFINDEX@ */
#define iso8859_5_index 5	/* @ISOBYTEDEFINDEX@ */
#define iso8859_6_index 6	/* @ISOBYTEDEFINDEX@ */
#define iso8859_7_index 7	/* @ISOBYTEDEFINDEX@ */
#define iso8859_8_index 8	/* @ISOBYTEDEFINDEX@ */
#define iso8859_9_index 9	/* @ISOBYTEDEFINDEX@ */
#define iso8859_11_index 10	/* @ISOBYTEDEFINDEX@ */
#define iso8859_10_index 11	/* @ISOBYTEDEFINDEX@ */
#define iso8859_13_index 12	/* @ISOBYTEDEFINDEX@ */
#define tcvn5712_index	 13	/* @ISOBYTEDEFINDEX@ */
#define iso8859_14_index 14	/* @ISOBYTEDEFINDEX@ */
#define iso8859_15_index 15	/* @ISOBYTEDEFINDEX@ */
#define iso8859_16_index 16	/* @ISOBYTEDEFINDEX@ */
#define csa243_index	 17	/* @ISOBYTEDEFINDEX@ */
#define csn369103_index  18	/* @ISOBYTEDEFINDEX@ */
#define iso6937_a1_index 19	/* @ISOBYTEDEFINDEX@ */
#define techset_p_index  20	/* @ISOBYTEDEFINDEX@ */
#define iso6937_a2_index 21	/* @ISOBYTEDEFINDEX@ */
#define gost19768_index  22	/* @ISOBYTEDEFINDEX@ */
#define iso8859_s_index  23	/* @ISOBYTEDEFINDEX@ */
#define iso10367_index   24	/* @ISOBYTEDEFINDEX@ */
#define iso6937_s_index  25	/* @ISOBYTEDEFINDEX@ */
#define ir164_index	 26	/* @ISOBYTEDEFINDEX@ */
#define ir167_index	 27	/* @ISOBYTEDEFINDEX@ */
#define iso4873_index	 28	/* @ISOBYTEDEFINDEX@ */
#define iec1289_index	 29	/* @ISOBYTEDEFINDEX@ */
#define iso8859_1w_index 30	/* @ISOBYTEDEFINDEX@ */
#define sami_supl_index	 31	/* @ISOBYTEDEFINDEX@ */
#define ir197_index	 32	/* @ISOBYTEDEFINDEX@ */
#define uralic_supl_index 33	/* @ISOBYTEDEFINDEX@ */
#define volg_supl_index  34	/* @ISOBYTEDEFINDEX@ */
#define iso8859_1e_index 35	/* @ISOBYTEDEFINDEX@ */
#define iso8859_4e_index 36	/* @ISOBYTEDEFINDEX@ */
#define iso8859_13e_index 37	/* @ISOBYTEDEFINDEX@ */
#define irish_ogham_index 38	/* @ISOBYTEDEFINDEX@ */
#define sami_supl2_index 39	/* @ISOBYTEDEFINDEX@ */
#define rh_greek_index   40	/* @ISOBYTEDEFINDEX@ */
#define heblew_8bit_index 41	/* @ISOBYTEDEFINDEX@ */
#define mosaic_101_3_index 42	/* @ISOBYTEDEFINDEX@ */
#define iso8859_tail	43	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* Regional code without iso-2022 calling sequences		   */
/* --------------------------------------------------------------- */
struct iso_byte_defs misc_byte_defs[] = {
 {0x21,1,256,ebcdik40,COD_NISO,NULL,L_JA,NULL,"EBCDIK(Hitachi)",NULL},
 {0x22,1,256,ebcdic40,COD_NISO,NULL,L_JA,NULL,"EBCDIC(IBM Kana)",NULL},
 {0x23,1,256,ebcdicn40,COD_NISO,NULL,L_JA,NULL,"EBCDIC(NEC Kana)",NULL},
 {0x24,1,256,ebcdics40,COD_NISO,NULL,L_JA,NULL,"EBCDIC(Fujitsu Latin)",NULL},
 {0x2f,1,256,ebcdic44,COD_NISO,NULL,L_NU,NULL,"IBM-037(SBCS)","ibm037"},
 {0x26,1,256,ebcdic41,COD_NISO,NULL,M_KO,NULL,"IBM-933(SBCS)",NULL},
 {0x27,1,256,ebcdic42,COD_NISO,NULL,M_ZH,NULL,"IBM-935(SBCS)",NULL},
 {0x28,1,256,ebcdic43,COD_NISO,NULL,M_ZH,NULL,"IBM-937(SBCS)",NULL},

 {0x29,1,128,koi8_uni_byte,COD_NISO,NULL,L_RU,NULL,"KOI-8 R","koi8"},
 {0x2a,1,128,koi8_u_uni_byte,COD_NISO,NULL,L_UK,NULL,"KOI-8 U","koi8u"},
 {0x2b,1,128,cp437_ms_uni_byte,COD_NISO,NULL,L_JP,NULL,"MS cp437","cp437"},
 {0x2c,1,128,cp1251_u_uni_byte,COD_NISO,NULL,L_BG,NULL,
	"MS cp1251 Cyrillic","windows-1251"},
 {0x2d,1,128,ks_x1003_uni_byte,COD_NISO,NULL,L_KO,NULL,
	"KS X 1003","ksc5636"},
 {0x2e,1,128,mac_roman_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"Mac roman","macintosh"},
/* dynamic loading area */
 {0x52,1,128,vpsl_uni_byte,COD_NISO,NULL,L_VI,NULL,"Vietnamese VPS",NULL},
 {0x53,1,128,armiscii_uni_byte,COD_NISO,NULL,L_HY,NULL,
	"Armenian Armiscii8","armiscii8"},
 {0x55,1,128,vpsr_uni_byte,COD_NISO,NULL,L_VI,NULL,
	"Vietnamese VPS(R)",NULL},
 {0x54,1,128,geostd8_uni_byte,COD_NISO,NULL,L_KA,NULL,
	"Georgian GEOSTD8","geostd8"},
 {0x56,1,128,cp850_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"IBM cp850 Latin-1","cp850"},
 {0x57,1,128,cp1252_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"MS cp1252 Windows-latin1","windows-1252"},
 {0x58,1,128,cp1253_uni_byte,COD_NISO,NULL,L_EL,NULL,
	"MS cp1253 Windows-greek","windows-1253"},
 {0x59,1,128,cp1254_uni_byte,COD_NISO,NULL,L_TR,NULL,
	"MS cp1254 Windows-turkish","windows-1254"},
 {0x5a,1,128,cp1255_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"MS cp1255 Hebrew-2","windows-1255"},
 {0x64,1,256,iso11548_uni_byte,COD_NISO,NULL,L_KK,NULL,
	"ISO 11548-1","iso11548-1"},
 {0x65,1,128,brf_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"Braille Formatted(Duxbury BRF)","brf"},
 {0x66,1,128,cp1250_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"MS cp1250 Latin-2","windows-1250"},
 {0x68,1,128,cp874_uni_byte,COD_NISO,NULL,L_TH,NULL,
	"MS cp874 Thai","Windows-874"},
 {0x69,1,128,cp869_uni_byte,COD_NISO,NULL,L_ID,NULL,
	"IBM cp869 Greek 2 - Indonesian","ibm869"},
 {0x6a,1,192,vni_uni_byte,COD_NISO,NULL,M_VI,NULL,"Vietnamese VNI",NULL},
 {0x6b,1,128,cp866_uni_byte,COD_NISO,NULL,L_RU,NULL,
	"MS cp866 Russian","cp866"},
 {0x6c,1,128,cp865_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"IBM cp865 Nordic","cp865"},
 {0x6d,1,128,cp864_uni_byte,COD_NISO,NULL,L_AR,NULL,
	"IBM cp864 Arabic","cp864"},
 {0x6e,1,128,cp863_uni_byte,COD_NISO,NULL,L_FR,NULL,
	"IBM cp863 Canadian French","cp863"},
 {0x6f,1,128,cp862_uni_byte,COD_NISO,NULL,L_HE,NULL,
	"MS cp862 Hebrew","dos-862"},
 {0x70,1,128,cp861_uni_byte,COD_NISO,NULL,L_IS,NULL,
	"IBM cp861 Icelandic","cp861"},
 {0x71,1,128,cp860_uni_byte,COD_NISO,NULL,L_PT,NULL,
	"IBM cp860 Portuguese","cp860"},
 {0x72,1,128,cp857_uni_byte,COD_NISO,NULL,L_TR,NULL,
	"IBM cp857 Turkish","cp857"},
 {0x73,1,128,cp855_uni_byte,COD_NISO,NULL,L_RU,NULL,
	"IBM cp855 Cyrillic","cp855"},
 {0x74,1,128,cp852_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"IBM cp852 Latin-2","ibm852"},
 {0x75,1,128,cp1258_uni_byte,COD_NISO,NULL,M_VI,NULL,
	"MS cp1258 Vietnamese","windows-1258"},
 {0x76,1,128,viscii_uni_byte,COD_NISO,NULL,M_VI,NULL,
	"RFC-1456 VISCII Left","visciil"},
 {0x77,1,128,visciir_uni_byte,COD_NISO,NULL,M_VI,NULL,
	"RFC-1456 VISCII Right","visciir"},
 {0x78,1,146,visciiq_uni_byte,COD_NISO,NULL,M_VI,NULL,
	"RFC-1456 VISCII VIQR-map",NULL},
 {0x79,1,128,cp737_uni_byte,COD_NISO,NULL,L_EL,NULL,
	"IBM cp737 Greek","cp737"},
 {0x7a,1,128,cp775_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"IBM cp775 Baltic Rim","ibm775"},
 {0x7b,1,128,cp853_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"MS cp853 Multilingual Latin 3","cp853"},
 {0x7c,1,128,cp895_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"MS cp895 Kamenicky CS","cp895"},
 {0x7d,1,128,gsm0338_uni_byte,COD_NISO,NULL,L_NU,NULL,
	"GSM 03.38","gsm3.38"},
#ifdef TSCII_SUPPORT
 {0x67,1,128,tscii_uni_byte,COD_NISO,NULL,L_TA,NULL,
	"Tamil TSCII 1.7","tscii"},
#endif
/* Note: spare character 0x40-0x52, 0x5b-0x63 0x7b-0x7e */
/* Dummy entry */
  {0x00,0,0,NULL,COD_NISO,NULL,L_NU,NULL,NULL,NULL} /* is last entry */
};

#define ebcdik_index	0	/* @ISOBYTEDEFINDEX@ */
#define ebcdic_index	1	/* @ISOBYTEDEFINDEX@ */
#define ebcdicn_index	2	/* @ISOBYTEDEFINDEX@ */
#define ebcdics_index	3	/* @ISOBYTEDEFINDEX@ */
#define ebcdice_index	4	/* @ISOBYTEDEFINDEX@ */
#define ebcdick_index	5	/* @ISOBYTEDEFINDEX@ */
#define ebcdicz_index	6	/* @ISOBYTEDEFINDEX@ */
#define ebcdict_index	7	/* @ISOBYTEDEFINDEX@ */
#define koi8_index	8    /* Russian cyrillic @ISOBYTEDEFINDEX@ */
#define koi8_u_index	9    /* Ukrainian cyrillic @ISOBYTEDEFINDEX@ */
#define cp437_index	10	/* @ISOBYTEDEFINDEX@ */
#define ms_cp1251_index	11	/* @ISOBYTEDEFINDEX@ */
#define ksx1003_index	12	/* @ISOBYTEDEFINDEX@ */
#define mac_roman_index	13	/* @ISOBYTEDEFINDEX@ */
#define vpsl_index	14	/* @ISOBYTEDEFINDEX@ */
#define armiscii_index	15	/* @ISOBYTEDEFINDEX@ */
#define vpsr_index	16	/* @ISOBYTEDEFINDEX@ */
#define geostd_index	17	/* @ISOBYTEDEFINDEX@ */
#define cp850_index	18	/* @ISOBYTEDEFINDEX@ */
#define cp1252_index	19	/* @ISOBYTEDEFINDEX@ */
#define cp1253_index	20	/* @ISOBYTEDEFINDEX@ */
#define cp1254_index	21	/* @ISOBYTEDEFINDEX@ */
#define cp1255_index	22	/* @ISOBYTEDEFINDEX@ */
#define iso11548_index	23	/* @ISOBYTEDEFINDEX@ */
#define brf_index	24	/* @ISOBYTEDEFINDEX@ */
#define cp1250_index	25	/* @ISOBYTEDEFINDEX@ */
#define cp874_index	26	/* @ISOBYTEDEFINDEX@ */
#define cp869_index	27	/* @ISOBYTEDEFINDEX@ */
#define vni_index	28	/* @ISOBYTEDEFINDEX@ */
#define cp866_index	29	/* @ISOBYTEDEFINDEX@ */
#define cp865_index	30	/* @ISOBYTEDEFINDEX@ */
#define cp864_index	31	/* @ISOBYTEDEFINDEX@ */
#define cp863_index	32	/* @ISOBYTEDEFINDEX@ */
#define cp861_index	33	/* @ISOBYTEDEFINDEX@ */
#define cp862_index	34	/* @ISOBYTEDEFINDEX@ */
#define cp860_index	35	/* @ISOBYTEDEFINDEX@ */
#define cp857_index	36	/* @ISOBYTEDEFINDEX@ */
#define cp855_index	37	/* @ISOBYTEDEFINDEX@ */
#define cp852_index	38	/* @ISOBYTEDEFINDEX@ */
#define cp1258_index	39	/* @ISOBYTEDEFINDEX@ */
#define viscii_index	40	/* @ISOBYTEDEFINDEX@ */
#define visciir_index	41	/* @ISOBYTEDEFINDEX@ */
#define visciiq_index	42	/* @ISOBYTEDEFINDEX@ */
#define cp737_index	43	/* @ISOBYTEDEFINDEX@ */
#define cp775_index	44	/* @ISOBYTEDEFINDEX@ */
#define cp853_index	45	/* @ISOBYTEDEFINDEX@ */
#define cp895_index	46	/* @ISOBYTEDEFINDEX@ */
#define gsm0338_index	47	/* @ISOBYTEDEFINDEX@ */
#define tscii_index	48	/* @ISOBYTEDEFINDEX@ */
#define misc_byte_tail	49	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* Resional code multibyte sequence				   */
/* --------------------------------------------------------------- */
struct iso_byte_defs miscmul_byte_defs[] = {
/* dynamic loading area */
 {0x41,2,BIG5_TBL_LEN,cp950_uni_byte,COD_NISO|COD_MB,NULL,M_ZH,NULL,
	"Big5(MS cp950)",NULL},
 {0x42,2,BIG5_TBL_LEN,big5_uni_byte,COD_NISO|COD_MB,NULL,M_ZH,NULL,
	"Big5(ETen)",NULL},
 {0x44,2,IBMDBCSL_TBL_LEN,ibm937_uni_byte,COD_NISO|COD_MB,NULL,
	M_ZH,NULL,"IBM-937(DBCS)",NULL},
 {0x45,2,IBMDBCS_TBL_LEN,ibm935_uni_byte,COD_NISO|COD_MB,NULL,
	M_ZH,NULL,"IBM-935(DBCS)",NULL},
 {0x46,2,IBMDBCSL_TBL_LEN,ibm933_uni_byte,COD_NISO|COD_MB,NULL,
	M_KO,NULL,"IBM-933(DBCS)",NULL},
 {0x47,2,BIG5_TBL_LEN,big5h_uni_byte,COD_NISO|COD_MB,NULL,M_ZH,NULL,
	"Big5(HKU)",NULL},
 {0x48,2,GB12345_TBL_LEN,gb12345_uni_byte,COD_NISO|COD_MB,NULL,
	M_ZH,NULL,"GB/T 12345","gb12345"},
 {0x4a,2,IBMDBCS_TBL_LEN,ibm930_uni_byte,COD_NISO|COD_MB,NULL,
	M_JP,NULL,"IBM-930(DBCS)",NULL},
 {0x4b,4,BIG5P_TBL_LEN,NULL,COD_NISO|COD_MB,big5p_uni_byte,M_ZH,NULL,
	"Big5-HKSCS",NULL},
 {0x4c,2,GBK_TBL_LEN,gb2k_uni_byte,COD_NISO|COD_MB,NULL,M_ZH,NULL,
	"GB18030",NULL},
 {0x4e,2,GBK_TBL_LEN,gbk_uni_byte,COD_NISO|COD_MB,NULL,M_ZH,NULL,
	"GBK(MS cp936)",NULL},
 {0x4f,2,JOHAB_TBL_LEN,johab_uni_byte,COD_NISO|COD_MB,NULL,M_KO,NULL,
	"KS X1001(JOHAB)",NULL},
 {0x50,2,BIG5P_TBL_LEN,big52_uni_byte,COD_NISO|COD_MB,NULL,M_ZH,NULL,
	"Big5-2003",NULL},
 {0x51,2,BIG5P_TBL_LEN,big5a_uni_byte,COD_NISO|COD_MB,NULL,M_ZH,NULL,
	"Big5-UAO",NULL},
 {0x60,4,96800,NULL,COD_NISO|COD_MB,NULL,1,NULL,NULL,NULL},
				/* GT-shotai table(B/Right)*/
 {0x61,4,57236,NULL,COD_NISO|COD_MB,NULL,1,NULL,NULL,NULL},
				/* Daikanwa table(B/Right) */
 {0x62,2,57236,NULL,COD_NISO|COD_MB,NULL,1,NULL,NULL,NULL},
				/* Symbol table(B/Right)   */
 {0x65,2,1410,NULL,COD_NISO|COD_MB,NULL,1,NULL,NULL,NULL},
 				/* Tompa table */
 {0x66,4,ISOMB_CODE_END,NULL,	/* X-0208 with new jyouyou kanji   */
	COD_NISO | COD_MB, x0208_nj_uni_byte,M_JP,NULL,
	"New-Jyouyo-Kanji(X0208based)","x0208_nj"},
 {0x67,2,BIG5P_TBL_LEN,cp949_uni_byte,COD_NISO|COD_MB,NULL,
	M_KO,NULL,"MS cp949 UHC",NULL},
 {0x6a,4,21000,NULL,COD_NISO|COD_MB,NULL,1,NULL,NULL,NULL},
			/* JuminKihonDaicho touitsu code - not yet */
/* Note: spare character 0x5b-0x64, 0x7b-0x7e */
/* dummy entry */
  {0x00,0,0,NULL,COD_NISO|COD_MB,NULL,L_NU,NULL,NULL,NULL}
	/* is last entry */
};

#define big5cp950_index 0 	/* @ISOBYTEDEFINDEX@ */
#define big5_index	1	/* @ISOBYTEDEFINDEX@ */
#define ibmdbcst_index	2	/* @ISOBYTEDEFINDEX@ */
#define ibmdbcsz_index	3	/* @ISOBYTEDEFINDEX@ */
#define ibmdbcsk_index	4	/* @ISOBYTEDEFINDEX@ */
#define big5hku_index	5 	/* @ISOBYTEDEFINDEX@ */
#define gb12345_index	6	/* @ISOBYTEDEFINDEX@ */
#define ibmdbcs_index	7	/* @ISOBYTEDEFINDEX@ */
#define big5p_index	8	/* @ISOBYTEDEFINDEX@ */
#define gb18030_index	9	/* @ISOBYTEDEFINDEX@ */
#define gbk_index	10	/* @ISOBYTEDEFINDEX@ */
#define johab_index	11	/* @ISOBYTEDEFINDEX@ */
#define big5_2003_index	12	/* @ISOBYTEDEFINDEX@ */
#define big5_uao_index	13	/* @ISOBYTEDEFINDEX@ */
#define gttype_index	14	/* @ISOBYTEDEFINDEX@ */
#define daikan_index	15	/* @ISOBYTEDEFINDEX@ */
#define brightsym_index	16	/* @ISOBYTEDEFINDEX@ */
#define tompa_index	17	/* @ISOBYTEDEFINDEX@ */
#define x0208nj_index	18	/* @ISOBYTEDEFINDEX@ */
#define cp949_index	19	/* @ISOBYTEDEFINDEX@ */
#define jyuki_index	20	/* @ISOBYTEDEFINDEX@ */
#define miscm_byte_tail	21	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* various codepage tables					   */
/* --------------------------------------------------------------- */
struct iso_byte_defs cp_byte_defs[] = { /* codepage tables	   */
  {0x40,1,128,macczech_uni_byte,COD_NISO|COD_SET96,NULL,L_EM,NULL,
	"Mac Central Europe","x-mac-ce"},
  {0x41,1,128,machebrew_uni_byte,COD_NISO|COD_SET96|COD_HAS_D8,NULL,
	L_HE,NULL,"Mac Hebrew","x-mac-hebrew"},
  {0x42,1,128,macfarsi_uni_byte,COD_NISO|COD_SET96,NULL,L_FA,NULL,
	"Mac Farsi","x-mac-farsi"},
  {0x43,1,128,macdevanaga_uni_byte,COD_NISO|COD_SET96,NULL,L_HI,NULL,
	"Mac Devanagari","x-mac-devanagari"},
  {0x44,1,128,maccyril_uni_byte,COD_NISO|COD_SET96,NULL,L_RU,NULL,
	"Mac Cyrillic","x-mac-cyrillic"},
  {0x45,1,128,macturki_uni_byte,COD_NISO|COD_SET96,NULL,L_TR,NULL,
	"Mac Turkish","x-mac-turkish"},
  {0x46,1,128,macgreek_uni_byte,COD_NISO|COD_SET96,NULL,L_EL,NULL,
	"Mac Greek","x-mac-greek"},
  {0x47,1,128,macarabic_uni_byte,COD_NISO|COD_SET96,NULL,L_AR,NULL,
	"Mac Arabic","x-mac-arabic"},
  {0x48,1,128,macicelan_uni_byte,COD_NISO|COD_SET96,NULL,L_IS,NULL,
	"Mac Icelandic","x-mac-icelandic"},
  {0x49,1,128,macgujarati_uni_byte,COD_NISO|COD_SET96,NULL,L_GU,NULL,
	"Mac Gujarati","x-mac-gujarati"},
  {0x4a,1,128,macgurmukhi_uni_byte,COD_NISO|COD_SET96|COD_HAS_D8,NULL,
	L_PA,NULL,"Mac Gurmukhi","x-mac-gurmukhi"},
  {0x4b,1,128,maccroat_uni_byte,COD_NISO|COD_SET96,NULL,L_HR,NULL,
	"Mac Croatian","x-mac-croatian"},
  {0x4c,1,128,macromanian_uni_byte,COD_NISO|COD_SET96,NULL,L_RO,NULL,
	"Mac Romanian","x-mac-romanian"},
  {0x4d,1,128,macburg_uni_byte,COD_NISO|COD_SET96,NULL,L_RO,NULL,
	"Mac Burgarian","x-mac-burgarian"},
  {0x4f,1,128,cp1256_uni_byte,COD_NISO|COD_SET96,NULL,L_AR,NULL,
	"MS cp1256 (Arabic)","windows-1256"},
  {0x50,1,128,cp1257_uni_byte,COD_NISO|COD_SET96,NULL,L_SV,NULL,
	"MS cp1257 (Baltic)","windows-1257"},
  {0x51,1,128,ds2089_uni_byte,COD_NISO|COD_SET96,NULL,L_DK,NULL,
	"Danish DS 2089:1974","ds_2089"},
  {0x52,1,128,kz1048_uni_byte,COD_NISO|COD_SET96,NULL,L_KK,NULL,
	"Kazahstan KZ 1048","kz-1048"},
  {0x55,1,128,hproman8_uni_byte,COD_NISO|COD_SET96,NULL,L_NU,NULL,
	"HP Roman 8","hproman8"},
  {0x56,1,128,koi8ru_uni_byte,COD_NISO|COD_SET96,NULL,L_NU,NULL,
	"Cyrillic KOI8-RU","koi8ru"},
  {0x57,1,128,koi8t_uni_byte,COD_NISO|COD_SET96,NULL,L_NU,NULL,
	"Tajik KOI-8T","koi8t"},
  {0x58,1,128,cp922_uni_byte,COD_NISO|COD_SET96,NULL,L_NU,NULL,NULL,
	"cp922"},
  {0x59,1,128,NULL,COD_NISO|COD_SET96,NULL,L_NU,NULL,NULL,
	"cp720"},
  {0x5b,1,128,mule_lao_uni_byte,COD_NISO|COD_SET96,NULL,L_LO,NULL,
  	"Mule Lao-1","mule_lao"},
  {0x5c,1,128,cp1133_uni_byte,COD_NISO|COD_SET96,NULL,L_LO,NULL,
	"cp1133 Lao","cp1133"},
  {0x5d,1,128,pt154_uni_byte,COD_NISO|COD_SET96,NULL,L_KK,NULL,
	"pt154 Kazahk","pt154"},
  {0x5e,1,128,cp858_uni_byte,COD_NISO|COD_SET96,NULL,L_ID,NULL,
	"Windows cp858 (PC-Multilingual)","Windows-858"},
  {0x5f,1,128,cp1125_uni_byte,COD_NISO|COD_SET96,NULL,L_UK,NULL,
	"IBM cp1125 Cyrillic Ukraine","ibm1125"},
  {0x60,1,128,cp851_uni_byte,COD_NISO|COD_SET96,NULL,L_PL,NULL,
	"IBM cp851 Czech/Polish","ibm851"},
  {0x70,1,128,winsami2_uni_byte,COD_NISO|COD_SET96,NULL,L_NU,NULL,
	"MS Windows-sami-2","winsami2"},
  {0x72,1,128,iscii_as_uni_byte,COD_NISO|COD_SET96,NULL,L_AS,NULL,
	"ISCII Assamese ","x-iscii-as"},
  {0x73,1,128,iscii_be_uni_byte,COD_NISO|COD_SET96,NULL,L_BN,NULL,
	"ISCII Bengali ","x-iscii-be"},
  {0x74,1,128,iscii_de_uni_byte,COD_NISO|COD_SET96,NULL,L_HI,NULL,
	"ISCII Devanagari ","x-iscii-de"},
  {0x75,1,128,iscii_gu_uni_byte,COD_NISO|COD_SET96,NULL,L_GU,NULL,
	"ISCII Gujarathi ","x-iscii-gu"},
  {0x76,1,128,iscii_ka_uni_byte,COD_NISO|COD_SET96,NULL,L_KN,NULL,
	"ISCII Kannada ","x-iscii-ka"},
  {0x77,1,128,iscii_ma_uni_byte,COD_NISO|COD_SET96,NULL,L_ML,NULL,
	"ISCII Malayalam ","x-iscii-ma"},
  {0x78,1,128,iscii_or_uni_byte,COD_NISO|COD_SET96,NULL,L_OR,NULL,
	"ISCII Oriya ","x-iscii-or"},
  {0x79,1,128,iscii_pa_uni_byte,COD_NISO|COD_SET96,NULL,L_PA,NULL,
	"ISCII Panjabi ","x-iscii-pa"},
  {0x7a,1,128,iscii_ta_uni_byte,COD_NISO|COD_SET96,NULL,L_TA,NULL,
	"ISCII Tamil ","x-iscii-ta"},
  {0x7b,1,128,iscii_te_uni_byte,COD_NISO|COD_SET96,NULL,L_TE,NULL,
	"ISCII Telugu ","x-iscii-te"},
  {0x00,0,0,NULL,COD_NISO|COD_SET96,NULL,L_NU,NULL,NULL,NULL}/* is last entry */
};
#define macce_index	0	/* @ISOBYTEDEFINDEX@ */
#define machebrew_index	1	/* @ISOBYTEDEFINDEX@ */
#define macfarsi_index	2	/* @ISOBYTEDEFINDEX@ */
#define macdeva_index	3	/* @ISOBYTEDEFINDEX@ */
#define maccyri_index	4	/* @ISOBYTEDEFINDEX@ */
#define macturk_index	5	/* @ISOBYTEDEFINDEX@ */
#define macgreek_index	6	/* @ISOBYTEDEFINDEX@ */
#define macarabic_index	7	/* @ISOBYTEDEFINDEX@ */
#define maciceln_index	8	/* @ISOBYTEDEFINDEX@ */
#define macguj_index	9	/* @ISOBYTEDEFINDEX@ */
#define macgrm_index	10	/* @ISOBYTEDEFINDEX@ */
#define maccroa_index	11	/* @ISOBYTEDEFINDEX@ */
#define macromani_index	12	/* @ISOBYTEDEFINDEX@ */
#define macburg_index	13	/* @ISOBYTEDEFINDEX@ */
#define cp1256_index	14	/* @ISOBYTEDEFINDEX@ */
#define cp1257_index	15	/* @ISOBYTEDEFINDEX@ */
#define ds2089_index	16	/* @ISOBYTEDEFINDEX@ */
#define kz1048_index	17	/* @ISOBYTEDEFINDEX@ */
#define hproman8_index	18	/* @ISOBYTEDEFINDEX@ */
#define koi8ru_index	19	/* @ISOBYTEDEFINDEX@ */
#define koi8t_index	20	/* @ISOBYTEDEFINDEX@ */
#define cp922_index	21	/* @ISOBYTEDEFINDEX@ */
#define cp720_index	22	/* @ISOBYTEDEFINDEX@ */
#define bright_jk_index 23 	/* @ISOBYTEDEFINDEX@ */
#define mula_lao_index	24 	/* @ISOBYTEDEFINDEX@ */
#define cp1133_index	25 	/* @ISOBYTEDEFINDEX@ */
#define pt154_index	26 	/* @ISOBYTEDEFINDEX@ */
#define cp1125_index	27	/* @ISOBYTEDEFINDEX@ */
#define cp851_index	28	/* @ISOBYTEDEFINDEX@ */
#define winsami2_index	29	/* @ISOBYTEDEFINDEX@ */
#define iscii_as_index	30	/* @ISOBYTEDEFINDEX@ */
#define iscii_be_index	31	/* @ISOBYTEDEFINDEX@ */
#define iscii_de_index	32	/* @ISOBYTEDEFINDEX@ */
#define iscii_gu_index	33	/* @ISOBYTEDEFINDEX@ */
#define iscii_ka_index	34	/* @ISOBYTEDEFINDEX@ */
#define iscii_ma_index	35	/* @ISOBYTEDEFINDEX@ */
#define iscii_or_index	36	/* @ISOBYTEDEFINDEX@ */
#define iscii_pa_index	37	/* @ISOBYTEDEFINDEX@ */
#define iscii_ta_index	38	/* @ISOBYTEDEFINDEX@ */
#define iscii_te_index	39	/* @ISOBYTEDEFINDEX@ */
#define cp_byte_tail	40	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* various EBCDICS						   */
/* --------------------------------------------------------------- */
struct iso_byte_defs ebcdic_byte_defs[] = { /* codepage tables	   */
  {0x00,0,0,NULL,COD_NISO|COD_MB_4|COD_SET96,NULL,L_NU,NULL,NULL,NULL}
};

#define ebcdic_byte_tail 0	/* @ISOBYTEDEFINDEX@ */
/* --------------------------------------------------------------- */
/* overlay (not independent table)				   */
/* --------------------------------------------------------------- */
struct iso_byte_defs ovlay_byte_defs[] = { /* overlay tables	   */
  {0x41,2,512,i_ntt_uni_byte,COD_NISO | COD_MB_4,NULL,L_JP,NULL,
	"NTT Docomo(TM) OLD-SJIS Glyph",NULL},
#ifdef KEIS_EXTRA_SUPPORT
  {0x48,2,36,keisaf_uni_byte,COD_NISO | COD_MB_4,NULL,M_JP,NULL,
	"KEIS AF area",NULL},  /* KEIS addendum 0xafa1 - 	   */
  {0x49,4,56,NULL,COD_NISO | COD_MB_4,keis9f_uni_byte,M_JP,NULL,
	"KEIS 9F area",NULL},	/* KEIS 0x9fa1 addendum		   */
#else
  {0x48,2,36,NULL,COD_NISO | COD_MB_4,NULL,M_JP,NULL,
	"KEIS AF area",NULL},  /* KEIS addendum 0xafa1 - 	   */
  {0x49,4,56,NULL,COD_NISO | COD_MB_4,NULL,M_JP,NULL,
	"KEIS 9F area",NULL},	/* KEIS 0x9fa1 addendum		   */
#endif
  {0x4a,2,JEF_TBL_LEN,jef43_uni_byte,COD_NISO | COD_MB_4,NULL,M_JP,NULL,
	"JEF 78 LOWER",NULL},	/* JEF 0x43a1-0x7ffe		   */
  {0x4b,4,KEIS_TBL_LEN,NULL,COD_NISO | COD_MB_4,keis59_uni_byte,M_JP,NULL,
	"KEIS 83/90 LOWER",NULL}, /* keis lower side (0x59a1-0x7fff) */
  {0x4c,2,GB2K_A_LEN,gb2k_a_uni_byte,COD_NISO | COD_MB_4,NULL,M_ZH,NULL,
	"GB18030 Area 5",NULL},
  {0x4d,2,940,mac_abbrev_29_uni_byte,COD_NISO | COD_MB_4,NULL,M_JP,NULL,
	"Kanjitalk 7 Overlay",NULL},
  {0x4e,4,HKSCS_PATCH_LEN,NULL,COD_NISO | COD_MB_4,
	hkscs_fa_uni_byte,M_ZH,NULL,"HKSCS Private map",NULL},
  {0x50,2,CP932932_PATCH_LEN,cp932inv_patch_uni_byte,
  	COD_NISO | COD_MB_4,NULL,M_JP,NULL,"cp932inv_patch",NULL},
  {0x60,4,96800,NULL,COD_NISO | COD_MB_4,NULL,L_JP,NULL,
	"GT shotai(B/Right)",NULL}, 
  {0x61,4,57236,NULL,COD_NISO | COD_MB_4,NULL,L_JP,NULL,
	"Daikanwa(B/Right)",NULL},
  {0x62,2,57236,NULL,COD_NISO | COD_MB_4,NULL,L_JP,NULL,
	"Symbols(B/Right)",NULL},
  {0x63,1,64,NULL,COD_NISO | COD_MB_4,NULL,L_JP,NULL,"Braille",NULL},
  {0x64,1,256,NULL,COD_NISO | COD_MB_4,NULL,L_JP,
  	NULL,"Braille(8dot)",NULL},
  {0x65,2,1410,NULL,COD_NISO | COD_MB_4,NULL,L_JP,NULL,
	"Tompa character(B/Right)",NULL}, 
  {0x68,4,PRV_TABLE_LEN,NULL,COD_NISO|COD_MB_4,conv_priv2emot_uni_byte,L_NU,
  	NULL,"Cell private to emoticon",NULL},
  {0x6a,1,238,vnie_uni_byte,COD_NISO|COD_MB_4,NULL,M_VI,
  	NULL,"VNI Expat",NULL},
  {0x6b,1,256,tscii_i_uni_byte,COD_NISO|COD_MB_4,NULL,L_TA,NULL,
	"TSCII SUB","tscii_i"},
  {0x6c,1,128,gsm0338a_uni_byte,COD_NISO|COD_MB_4,NULL,L_NU,NULL,
	"GSM 03.38_alt","gsm3.38a"},
  {0x6d,4,EMOJI_TBL_LEN,NULL,COD_NISO|COD_MB_4,n_emoji_uni_byte,L_NU,
  	NULL,"NTT-Docomo Emoji Map",NULL},
  {0x6e,4,EMOJI_TBL_LEN,NULL,COD_NISO|COD_MB_4,a_emoji_uni_byte,L_NU,
  	NULL,"KDDI-AU Emoji Map",NULL},
  {0x6f,4,EMOJI_TBL_LEN,NULL,COD_NISO|COD_MB_4,s_emoji_uni_byte,L_NU,
  	NULL,"Softbank Emoji Map",NULL},
#ifdef UNI_DECOMPOSE
  {0x70,2,UNI_NKDL_TBL_LEN,uni_nkdl_uni_byte,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode Normalization Form D Map-L",NULL},
  {0x71,2,UNI_NKDL_TBL_LEN,uni_nkcl_uni_byte,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode Normalization Form KD Map-L",NULL},
  {0x72,4,UNI_NORM_TBL_LEN,NULL,COD_NISO|COD_MB_4,uni_norm_uni_byte,
  	L_NU,NULL,"Unicode NFD control Map",NULL},
  {0x73,2,UNI_NKDL_TBL_LEN,uni_nkdl_uni_byte,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode Normalization Form D Map-L(Apple)",NULL},
  {0x74,2,UNI_NKDL_TBL_LEN,uni_nkcl_uni_byte,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode Normalization Form KD Map-L(Apple)",NULL},
  {0x75,4,UNI_NORM_TBL_LEN,NULL,COD_NISO|COD_MB_4,uni_norm_uni_byte,
  	L_NU,NULL,"Unicode NFD control Map(Apple)",NULL},
  {0x76,2,UNI_ATTRIB_TBL_LEN,uni_nstr_uni_byte,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode Combine strength Map",NULL},
#ifdef UNI_ENCOMPOSE
  {0x77,4,UNI_ENCNPC_TBL_LEN,uni_ccompose_uni_byte,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFC Compose control Map",NULL},
  {0x78,4,UNI_ENCNPD_TBL_LEN,uni_dcompose_uni_byte,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFD Compose control Map",NULL},
  {0x79,2,512,uni_dcompose_mask,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFD Compose Mask",NULL},
#else
  {0x77,2,128,NULL,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFC Compose control Map",NULL},
  {0x78,2,128,NULL,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFD Compose control Map",NULL},
  {0x79,2,512,NULL,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFD Compose Mask",NULL},
#endif
#else
  {0x70,2,UNI_NKDL_TBL_LEN,NULL,COD_NISO|COD_MB_4,NULL,L_NU,
  	NULL,"Unicode Normalize Map-L",NULL},
  {0x71,2,UNI_NKDL_TBL_LEN,NULL,COD_NISO|COD_MB_4,NULL,L_NU,
  	NULL,"Unicode Compatibility Map-L",NULL},
  {0x72,4,UNI_NORM_TBL_LEN,NULL,COD_NISO|COD_MB_4,NULL,L_NU,
  	NULL,"Unicode Normalize control Map",NULL},
  {0x73,2,UNI_NKDL_TBL_LEN,NULL,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode Normalization Form D Map-L(Apple)",NULL},
  {0x74,2,UNI_NKDL_TBL_LEN,NULL,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode Normalization Form KD Map-L(Apple)",NULL},
  {0x75,4,UNI_NORM_TBL_LEN,NULL,COD_NISO|COD_MB_4,NULL,
  	L_NU,NULL,"Unicode NFD control Map(Apple)",NULL},
  {0x76,2,UNI_ATTRIB_TBL_LEN,NULL,COD_NISO|COD_MB_4,NULL,L_NU,
  	NULL,"Unicode Combine strength Map",NULL},
  {0x77,2,128,NULL,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFC Compose control Map",NULL},
  {0x78,2,128,NULL,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFD Compose control Map",NULL},
  {0x79,2,512,NULL,COD_NISO|COD_MB_4,
  	NULL,L_NU,NULL,"Unicode NFD Compose Mask",NULL},
#endif
  {0x00,0,0,NULL,COD_NISO,NULL,L_NU,NULL,NULL,NULL} /* is last entry */
};
#define nttgrc1_index	   0 	/* @ISOBYTEDEFINDEX@ */
#define keis_a_prv_index   1 	/* @ISOBYTEDEFINDEX@ */
#define dbcs_host_index	   2	/* used in keis_in @ISOBYTEDEFINDEX@ */
#define jef_host_index	   3	/* used in keis_in @ISOBYTEDEFINDEX@ */
#define keis_host_index	   4	/* used in keis_in @ISOBYTEDEFINDEX@ */
#define gb18030_a5_index   5 	/* @ISOBYTEDEFINDEX@ */
#define mac_ovlay_index	   6	/* @ISOBYTEDEFINDEX@ */
#define hkscs_prv_index    7 	/* @ISOBYTEDEFINDEX@ */
#define cp932932_index     8 	/* @ISOBYTEDEFINDEX@ */
#define bright_gt_index    9	/* @ISOBYTEDEFINDEX@ */
#define bright_dk_index   10	/* @ISOBYTEDEFINDEX@ */
#define bright_sym_index  11	/* @ISOBYTEDEFINDEX@ */
#define bright_6b_index   12	/* @ISOBYTEDEFINDEX@ */
#define bright_8b_index   13	/* @ISOBYTEDEFINDEX@ */
#define bright_tp_index   14	/* @ISOBYTEDEFINDEX@ */
#define emot_prv_c_index  15	/* @ISOBYTEDEFINDEX@ */
#define vni_ex_prv_index  16 	/* @ISOBYTEDEFINDEX@ */
#define tscii_i_index	  17	/* @ISOBYTEDEFINDEX@ */
#define gsm0338a_index	  18	/* @ISOBYTEDEFINDEX@ */
#define nttemot_index	  19	/* @ISOBYTEDEFINDEX@ */
#define auemot_index	  20 	/* @ISOBYTEDEFINDEX@ */
#define sbemot_index	  21 	/* @ISOBYTEDEFINDEX@ */

#define unicode_nkdl_index 22 	/* @ISOBYTEDEFINDEX@ */
#define unicode_nkcl_index 23 	/* @ISOBYTEDEFINDEX@ */
#define unicode_nkdp_index 24 	/* @ISOBYTEDEFINDEX@ */
#define unicode_nadl_index 25 	/* @ISOBYTEDEFINDEX@ */
#define unicode_nacl_index 26 	/* @ISOBYTEDEFINDEX@ */
#define unicode_nadp_index 27 	/* @ISOBYTEDEFINDEX@ */
#define unicode_nstr_index 28 	/* @ISOBYTEDEFINDEX@ */
#define unicode_encc_index 29	/* @ISOBYTEDEFINDEX@ */
#define unicode_enck_index 30	/* @ISOBYTEDEFINDEX@ */
#define unicode_enckm_index 31	/* @ISOBYTEDEFINDEX@ */
#define unicode_p2m_index  32	/* @ISOBYTEDEFINDEX@ */
#define ovlay_byte_tail	   33	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* 94 character with second intermediate byte			   */
/* --------------------------------------------------------------- */
struct iso_byte_defs iso_im2byte_defs[] = {
/* dynamic loading area */
  {0x40,1,128,ccitt_gr_uni_byte,COD_ISOALT,NULL,L_NU,NULL,
	"CCITT Greek Videotex","greek-ccitt"},
  {0x41,1,128,cuban_uni_byte,COD_ISOALT,NULL,L_ES,NULL,
	"Cuban Spanish(NC99-10)","nc_nc00-10:81"},
  {0x42,1,128,iso646_inv_uni_byte,COD_ISOALT,NULL,L_NU,NULL,
	"ISO 646 invaliants","invaliant"},
  {0x43,1,128,ir_gl_uni_byte,COD_ISOALT,NULL,L_GA,NULL,
	"Irish Gaelic(I.S.433(1996))","is433"},
  {0x44,1,128,iso_turk_uni_byte,COD_ISOALT,NULL,L_NU,NULL,
	"Turkmen(TDS 565)","tds565"},
  {0x5e,1,128,tds565_uni_byte,COD_NISO|COD_SET96,NULL,L_TK,NULL,
	"Turkmen tds565","tds565"},
  {0x45,1,128,ansel_uni_byte,COD_ISOALT,NULL,L_NU,NULL,
	"ANSEL(ANSI ISO Z39.47)","iso-z39.47"},
  {0x00,0,0,NULL,COD_ISOALT,NULL,L_NU,NULL,NULL,NULL}  /* is last entry	   */
};

#define greek_videotex_index	0	/* @ISOBYTEDEFINDEX@ */
#define cuban_spanish_index	1	/* @ISOBYTEDEFINDEX@ */
#define iso646_invar_index	2	/* @ISOBYTEDEFINDEX@ */
#define irish_gaelic_index	3	/* @ISOBYTEDEFINDEX@ */
#define turkmen_im_index	4	/* @ISOBYTEDEFINDEX@ */
#define ansel_index		5	/* @ISOBYTEDEFINDEX@ */
#define iso_im2byte_tail	6	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* ESC-$-? : shorten multibyte sequence				   */
/* --------------------------------------------------------------- */
struct iso_byte_defs iso_3_dblbyte_defs[] = {
  {'B',2,KANJI_TBL_END,NULL,(COD_X0208 | COD_MB),
	NULL,M_JP,NULL,"JIS X0208:1997","jis"}, /* do not move this */
  {'@',2,KANJI_TBL_END,x208_78_uni_byte,(COD_X0208 | COD_MB), 
	NULL,M_JP,NULL,"JIS X0208:1978","jis_c6226-1978"},
/* dynamic loading area */
  {'A',2,ISOMB_CODE_END,gb2312_uni_byte,(COD_MB | COD_MB_4),
	NULL,M_ZH,NULL,"GB 2312(1980)-3Byte",NULL},
/* following set is not iso-2022 compliant, but can't distinguish  */
  {'G',1,128,vodafone_p1_uni_byte,COD_MB,NULL,L_JP,NULL,
	"Vodafone picture page1",NULL},
  {'E',1,128,vodafone_p2_uni_byte,COD_MB,NULL,L_JP,NULL,
	"Vodafone picture page2",NULL},
  {'F',1,128,vodafone_p3_uni_byte,COD_MB,NULL,L_JP,NULL,
	"Vodafone picture page3",NULL},
  {'O',1,128,vodafone_p4_uni_byte,COD_MB,NULL,L_JP,NULL,
	"Vodafone picture page4",NULL},
  {'P',1,128,vodafone_p5_uni_byte,COD_MB,NULL,L_JP,NULL,
	"Vodafone picture page5",NULL},
  {'Q',1,128,vodafone_p6_uni_byte,COD_MB,NULL,L_JP,NULL,
	"Vodafone picture page6",NULL},
  {'b',2,ISOMB_CODE_END,cp932_uni_byte,COD_MB,NULL,M_JP,NULL,
	NULL,"MS cp932"},	/* cp932 as documented		   */
  {'i',2,ISOMB_CODE_END,cp943_uni_byte,COD_MB,NULL,M_JP,NULL,
	NULL,"IBM cp943"},	/* cp943: OS/2 and AS/400	   */
  {'j',2,ISOMB_CODE_END,cp932w_uni_byte,COD_MB,NULL,M_JP,NULL,
	NULL,"MS cp932w"},	/* cp932 + wchar compatibility	   */
  {0x00,0,0,NULL,COD_MB,NULL,L_NU,NULL,NULL,NULL} /* is last entry */
};

#define jisc6226_78_index	1	/* @ISOBYTEDEFINDEX@ */
#define vodafone_1_index	3	/* @ISOBYTEDEFINDEX@ */
#define vodafone_2_index	4	/* @ISOBYTEDEFINDEX@ */
#define vodafone_3_index	5	/* @ISOBYTEDEFINDEX@ */
#define vodafone_4_index	6	/* @ISOBYTEDEFINDEX@ */
#define vodafone_5_index	7	/* @ISOBYTEDEFINDEX@ */
#define vodafone_6_index	8	/* @ISOBYTEDEFINDEX@ */
#define cp932_index		9	/* @ISOBYTEDEFINDEX@ */
#define cp943_index		10	/* @ISOBYTEDEFINDEX@ */
#define cp932w_index		11	/* @ISOBYTEDEFINDEX@ */
#define iso_3_mb_tail		14	/* @ISOBYTEDEFINDEX@ */

/* --------------------------------------------------------------- */
/* ESC-$-(-? : long sequence for CJK				   */
/* --------------------------------------------------------------- */
struct iso_byte_defs iso_4_dblbyte_defs[] = {
  {'B',2,KANJI_TBL_END,NULL,(COD_X0208 | COD_MB | COD_MB_4),NULL,M_JP,
	NULL,"JIS X0208:1997",NULL}, 	/* do not move this	   */
  {'@',2,KANJI_TBL_END,x208_78_uni_byte,(COD_X0208 | COD_MB),
	NULL,M_JP,NULL,"JIS X0208:1978",NULL},
  {'A',2,ISOMB_CODE_END,gb2312_uni_byte,(COD_MB | COD_MB_4),
	NULL,M_ZH,NULL,"GB 2312(1980)","gb2312"},
  {'D',2,X0212_TBL_END,NULL,(COD_X0212 | COD_MB | COD_MB_4),
	NULL,M_JP,NULL,"JIS X0212:1990","x0212"},
/* X-0213: plane 1 has several unmapped char, but plane 2 doesn't. */
  {'O',4,ISOMB_CODE_END,NULL,
	(COD_MB | COD_MANUAL | COD_X213_1 | COD_MB_4 | COD_4B),
	x213_1_uni_byte,M_JP,NULL,"JIS X0213:2000(plane 1)","x0213"},
  {'P',4,ISOMB_CODE_END,NULL,
	(COD_MB | COD_X213_2 | COD_MB_4 | COD_4B | COD_HAS_D8),
	x213_2_uni_byte,M_JP,NULL,"JIS X0213:2000(plane 2)","x0213-2"},
  {'C',2,ISOMB_CODE_END,ksx1001_uni_byte, /* KS X-1001	   */
	(COD_MB | COD_MB_4),NULL,M_KO,NULL,"KS X1001(1987)","ks_x_1001"},
/* dynamic loading area */
  {'E',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,M_ZH,NULL,
	"ISO-IR-165",NULL},
  {'F',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,L_NU,NULL,
	"Bliss symbol",NULL},
  {'G',2,ISOMB_CODE_END,cns11643_1_uni_byte,(COD_MB | COD_MB_4),
	NULL,M_ZH,NULL,"CNS11643 Set1","cns11643-1"},
  {'H',2,ISOMB_CODE_END,cns11643_2_uni_byte,(COD_MB | COD_MB_4),
	NULL,M_ZH,NULL,"CNS11643 Set2","cns11643-2"},
  {'I',2,ISOMB_CODE_END,cns11643_3_uni_byte,(COD_MB | COD_MB_4),
	NULL,M_ZH,NULL,"CNS11643 Set3","cns11643-3"},
  {'J',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,M_ZH,NULL,
	"CNS11643 Set4",NULL},
  {'K',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,M_ZH,NULL,
	"CNS11643 Set5",NULL},
  {'L',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,M_ZH,NULL,
	"CNS11643 Set6",NULL},
  {'M',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,M_ZH,NULL,
	"CNS11643 Set7",NULL},
  {'N',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,M_KO,NULL,
	"DPRK Korian",NULL},
  {'Q',4,ISOMB_CODE_END,NULL,
	(COD_MB | COD_MANUAL | COD_X213_1 | COD_MB_4 | COD_4B),
	x213_1n_uni_byte,M_JP,NULL,
	"JIS X0213:2004(plane 1)","x0213(2004)"},
  {'?',2,ISOMB_CODE_END,NULL,(COD_MB | COD_MB_4),NULL,L_JP,NULL,
	"iso-2022-jp-ms",NULL},	/* is dummy. Not to be filled	  */
  {0x00,2,0,NULL,FALSE,NULL,L_NU,NULL,NULL,NULL} /* is last entry */
};

#define x0208_index	0	/* used in esc_process.c @ISOBYTEDEFINDEX@ */
#define x0208_o_index	1	/* @ISOBYTEDEFINDEX@ */
#define gb2312_index	2	/* @ISOBYTEDEFINDEX@ */
#define x0212_index	3	/* @ISOBYTEDEFINDEX@ */
#define x0213_1_index	4	/* @ISOBYTEDEFINDEX@ */
#define x0213_2_index	5	/* @ISOBYTEDEFINDEX@ */
#define ksc5601_index	6	/* @ISOBYTEDEFINDEX@ */
#define ir_165_index		7	/* @ISOBYTEDEFINDEX@ */
#define bliss_index		8	/* @ISOBYTEDEFINDEX@ */
#define cns11643_1_index	9	/* @ISOBYTEDEFINDEX@ */
#define cns11643_2_index	10	/* @ISOBYTEDEFINDEX@ */
#define cns11643_3_index	11	/* @ISOBYTEDEFINDEX@ */
#define cns11643_4_index	12	/* @ISOBYTEDEFINDEX@ */
#define cns11643_5_index	13	/* @ISOBYTEDEFINDEX@ */
#define cns11643_6_index	14	/* @ISOBYTEDEFINDEX@ */
#define cns11643_7_index	15	/* @ISOBYTEDEFINDEX@ */
#define dprk_korian_index	16	/* @ISOBYTEDEFINDEX@ */
#define x0213_1n_index		17	/* @ISOBYTEDEFINDEX@ */
#define iso2022_jp_ms_index	18	/* @ISOBYTEDEFINDEX@ */
#define iso_4_mb_tail		19	/* @ISOBYTEDEFINDEX@ */

static struct iso_byte_defs *dummy_byte_entry = NULL;

/* --------------------------------------------------------------- */
/* code preset capability list					   */
/*   bit 3:	G3 settable					   */
/*   bit 2:	G2 settable					   */
/*   bit 1:	G1 settable					   */
/*   bit 0:	G0 settable					   */
/* --------------------------------------------------------------- */
#define CODE_CAPLIMIT	128

#define NOT_CAPABLE	0x0000
#define G0_CAPABLE	0x0001
#define G1_CAPABLE	0x0002
#define G2_CAPABLE	0x0004
#define G3_CAPABLE	0x0008

#define GA_CAPABLE	(unsigned short)(G0_CAPABLE | G1_CAPABLE | G2_CAPABLE | G3_CAPABLE)
#define GR_CAPABLE	(unsigned short)(G1_CAPABLE | G2_CAPABLE | G3_CAPABLE)

/* --------------------------------------------------------------- */
/* table of charset tables.					   */
/* Note: currently, entry count should be < 16. Change SG_* in	   */
/* in skf.c and skf.h if exceeded.				   */
/* --------------------------------------------------------------- */

struct iso_byte_defs_entry iso_ubytedef_table[] = {
  {iso_unibyte_defs,GA_CAPABLE,iso_unibyte_tail,
		"94-char graphic characters"}, 
  {iso_iso8859_defs,GR_CAPABLE,iso8859_tail,
		"96-char graphic characters"}, 
  {iso_im2byte_defs,GA_CAPABLE,iso_im2byte_tail,
		"94-char graphic characters with 2nd intermediate byte"}, 
  {iso_3_dblbyte_defs,GA_CAPABLE,iso_3_mb_tail,
		"3-octet multiple byte graphic characters"},
  {iso_4_dblbyte_defs,GA_CAPABLE,iso_3_mb_tail,
		"4-octet multiple byte graphic characters"}, 
  {misc_byte_defs,GA_CAPABLE,misc_byte_tail,
		"non-iso-2022 graphic characters"},
  {cp_byte_defs,GA_CAPABLE,cp_byte_tail,
		"MS/IBM/Apple codepage graphic characters"},
  {miscmul_byte_defs,GA_CAPABLE,miscm_byte_tail,
		"non-iso-2022 multibyte graphic characters"},
  {ebcdic_byte_defs,NOT_CAPABLE,ebcdic_byte_tail,
		"ebcdic mapping tables"},
  {ovlay_byte_defs,NOT_CAPABLE,ovlay_byte_tail,
		"overlay mapping tables (modified charsets)"},
		/* ovlay should be end of the table.		   */
  {NULL,NOT_CAPABLE,0,NULL}
};

#define ub_uni_index	0	/* @ISOBYTEDEFINDEX@ */
#define ub_8859_index	1	/* @ISOBYTEDEFINDEX@ */
#define ub_im2_index	2	/* @ISOBYTEDEFINDEX@ */
#define ub_3db_index	3	/* @ISOBYTEDEFINDEX@ */
#define ub_4db_index	4	/* @ISOBYTEDEFINDEX@ */
#define	ub_misc_index	5	/* @ISOBYTEDEFINDEX@ */
#define	ub_cp_index	6	/* @ISOBYTEDEFINDEX@ */
#define	ub_miscm_index	7	/* @ISOBYTEDEFINDEX@ */
#define	ub_ebcdic_index	8	/* @ISOBYTEDEFINDEX@ */
#define	ub_ovlay_index	9	/* @ISOBYTEDEFINDEX@ */

#define SK_UB_UNI	(ub_uni_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */
#define SK_UB_8859	(ub_8859_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */
#define SK_UB_IM2	(ub_im2_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */
#define SK_UB_3DB	(ub_3db_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */
#define SK_UB_4DB	(ub_4db_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */
#define	SK_UB_MISC	(ub_misc_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */
#define	SK_UB_CP	(ub_cp_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */
#define	SK_UB_OVLAY	(ub_ovlay_index	<< SG_SHIFTLEN)	/* @ISOBYTEDEFINDEX@ */

/* ------------------------------------------------------- */
/* iscii attribute table				   */
/* skf default font is devanagari			   */
/* ------------------------------------------------------- */
unsigned short iscii_attrib_table[94] = {
         0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  ISCII_BLD,ISCII_ITA,ISCII_UL,ISCII_EXP,
  ISCII_HLT,ISCII_OTL,ISCII_SHD,ISCII_TOP,
  ISCII_LOW,ISCII_DBL,
  0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

  iscii_de_index,ISCII_RMN,iscii_de_index,iscii_be_index,
  iscii_ta_index,iscii_te_index,iscii_as_index,iscii_or_index,
  iscii_ka_index,iscii_ma_index,iscii_gu_index,iscii_pa_index,0,0,0,0,
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  0x0000,ISCII_ARB,ISCII_PES,ISCII_URD,
  ISCII_SND,ISCII_KSM,ISCII_PST,0x0000,
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000
};

/* --------------------------------------------------------------- */
/* uni_table_init() - setup byte_defs_table definitions.	   */
/*  prerequisite: none						   */
/* --------------------------------------------------------------- */
/*@-usereleased@*/ /*@-globstate@*/ /*@-unqualifiedtrans@*/
void uni_table_init()
{
/* *** standard table: defined in uni_table.c *** */
    iso_4_dblbyte_defs[x0208_index].unitbl = uni_t_x208;
    iso_4_dblbyte_defs[x0212_index].unitbl = uni_t_x212;
    iso_3_dblbyte_defs[x0208_index].unitbl = uni_t_x208;
    iso_4_dblbyte_defs[iso2022_jp_ms_index].unitbl = uni_t_x208;

    if (dummy_byte_entry == NULL) {
	if ((dummy_byte_entry = (struct iso_byte_defs *)
		calloc(1,sizeof(struct iso_byte_defs))) != NULL) {
	    dummy_byte_entry->table_len = 0;
	    g0_table_mod = dummy_byte_entry;
	    g1_table_mod = dummy_byte_entry;
	    g2_table_mod = dummy_byte_entry;
	    g3_table_mod = dummy_byte_entry;
	    gx_table_mod = dummy_byte_entry;
	} else {
	    skferr(SKF_TBLALLOCERR,(long)0,(long)0);
	    skf_exit(EXIT_FAILURE);
	};
    };
}

/* --------------------------------------------------------------- */
/* conversion working variables					   */
/* --------------------------------------------------------------- */
    int    low_dbyte = 0;	/* lower side double byte(left)	   */
    int    up_dbyte = 0;	/* upper side double byte(right)   */
    unsigned long    low_kana = 0; /* lower side is kana	   */
    unsigned long    up_kana = 0;  /* upper side is kana 	   */

    unsigned short *low_table;	/* lower side conversion table	   */
    unsigned short *up_table;	/* upper side conversion table	   */

    skf_ucode 	*low_ltable;	/* lower side UCS4 table	   */
    skf_ucode	*up_ltable;	/* upper side UCS4 table	   */

    int	   low_table_limit;	/* table size			   */
    int    up_table_limit;

    struct iso_byte_defs *low_table_mod; /* lower table mode	   */
    struct iso_byte_defs *up_table_mod;  /* upper table mode	   */

    struct iso_byte_defs *g0_table_mod;  /* g0 table mode	   */
    struct iso_byte_defs *g1_table_mod;  /* g1 table mode	   */
    struct iso_byte_defs *g2_table_mod;  /* g2 table mode	   */
    struct iso_byte_defs *g3_table_mod;  /* g3 table mode	   */
    struct iso_byte_defs *gx_table_mod;  /* gx table mode	   */

    struct iso_byte_defs *c0_table_mod;	 /* c0 table mode	   */
    struct iso_byte_defs *c1_table_mod;	 /* c1 table mode	   */

/* --- table specification suggested by options ------------------ */
    struct iso_byte_defs *pre_single_g0_table = NULL;
    struct iso_byte_defs *pre_single_g1_table = NULL;
    struct iso_byte_defs *pre_single_g2_table = NULL;
    struct iso_byte_defs *pre_single_g3_table = NULL;

    short  in_keis = FALSE;	/* keis kanji shift status	   */
    short  DBCS_host_index = dbcs_host_index;
    short  JEF_host_index = jef_host_index;
    short  KEIS_host_index = keis_host_index;

/* --------------------------------------------------------------- */
/* Unic*de decomposition/composition table definitions		   */
/* --------------------------------------------------------------- */
#ifdef UNI_DECOMPOSE
unsigned short	*nkdc_lowptr;	 /* area mapper			   */
skf_ucode 	*nkdc_lowmap;
unsigned short	*nkd_strmap;
#endif

/* --------------------------------------------------------------- */
/* canonical name pattern search				   */
/* --------------------------------------------------------------- */
/* skf_search_c[h]name: get canonical name from code/charset table */
/*  match ignores '-' and '_', and requires exact same length	   */
/* --------------------------------------------------------------- */
int skf_search_cname(cq)	/* search in codeset table	   */
char *cq;
{
    int i;
    char *cp;
    char *option_str;


    cp = cq;
    for (i=0;i < codeset_end; i++) {
	option_str = i_codeset[i].cname;
	if (option_str == NULL) continue;
	if (cname_comp(cp,option_str) > 0) { /* use exact match	   */
	    return(i);
	};
    };
    return(-1);
}

int skf_search_chname(cq)	/* search in charset table	*/
char *cq;
{
    int i,j;
    char *cp;
    char *option_str;

    cp = cq;
    for (i=0;(iso_ubytedef_table[i].ientry != NULL) &&
    		(i < ub_ovlay_index); i++) {
	for (j=0; iso_ubytedef_table[i].ientry[j].defschar != 0;j++) {
	    option_str = iso_ubytedef_table[i].ientry[j].cname;
	    if (option_str == NULL) continue;
	    if (cname_comp(cp,option_str) > 0) {
		return((i << SG_SHIFTLEN) + j);
	    };
	};
    };
    return(-1);
}

/* --------------------------------------------------------------- */
/* table preloader						   */
/* --------------------------------------------------------------- */
int  in_codeset_preload()
{
    int	id,tid;
    unsigned long encode;
    int res;

#ifdef SKFDEBUG
    if (is_vv_debug) {
	fprintf(stderr,"in_codeset_preload - in_codeset: %d (%s)",
		in_codeset,i_codeset[in_codeset].desc);
	fflush(stderr);
    };
#endif

/* ------------------------------------------------------- */
/* codeset flavor trimming				   */
/* ------------------------------------------------------- */
    if (in_codeset < 0) {
	in_undefined(0x20,SKF_UNDEFCSET);
	in_codeset = codeset_x0208;
    };

    if (i_codeset[in_codeset].encode == 0) { /* NEED NO LOAD	   */
    	return(0);
    };

/* ------------------------------------------------------- */
/* Now we get in_codeset. Let's examine given codeset.	   */
/* ------------------------------------------------------- */
    encode = i_codeset[in_codeset].encode;
#ifdef SKFDEBUG
    if (is_vv_debug) fprintf(stderr," - %lx ",encode);
#endif

    c0_table_mod = NULL;
    c1_table_mod = NULL;
/* ------------------------------------------------------- */
/* code preloading					   */
/* ------------------------------------------------------- */
/* g0 setting */ /* g0 is set except unicode input		   */
    if ((is_jis(encode) || (is_msfam(encode)) ||
    	((is_euc7(encode) || is_euc(encode)) && !(euc_protect))) &&
		(pre_single_g0_table != NULL) && !is_in_encoded()) {
#ifdef SKFDEBUG
	if (is_vv_debug) { fprintf(stderr,"\n- pre-g0"); };
#endif
	g0_table_mod = pre_single_g0_table;
    } else {
	tid = i_codeset[in_codeset].g0def.tbl_index;
	id = i_codeset[in_codeset].g0def.index;
	if ((tid >= 0) && (id >= 0)) {
	    g0_table_mod = &(iso_ubytedef_table[tid].ientry[id]);
	} else {
	    g0_table_mod = NULL;	/* for extra care.	   */
	};
    };
    if (g0_table_mod != NULL) {
	if ((((g0_table_mod ->char_width) <= 2) /* short	   */
	      && (g0_table_mod ->unitbl == NULL)) ||
	    (((g0_table_mod ->char_width) == 4)
	      && (g0_table_mod ->uniltbl == NULL))) {
	    if (load_external_table(g0_table_mod) < 0) {
		skferr(SKF_TABLEERR_G0,(long)0,(long)0); 
		skf_terminate(EXIT_FAILURE);
	    };
	    if ((g0_table_mod -> hook) != NULL) { /* has patch	  */
		(g0_table_mod->hook)();
	    };
	};
/* Note this setting is for initialize, omit FJ_CONVENSION test   */
	g0table2low();
#ifdef SKFDEBUG
	if (is_vv_debug) {
	    fprintf(stderr,"\n - g0_table(%lx): %s ",
		(g0_table_mod->char_width == 4) ?
			(long) (g0_table_mod->uniltbl) :
			(long) (g0_table_mod->unitbl),
		g0_table_mod->desc);
	};
#endif
    };

/* g0a setting */ /* g0alt doesn't support pre-table		   */
    if (i_codeset[in_codeset].g0adef.tbl_index >= 0) {
	tid = i_codeset[in_codeset].g0adef.tbl_index;
	id = i_codeset[in_codeset].g0adef.index;
	if ((tid >= 0) && (id >= 0)) {
	    gx_table_mod = &(iso_ubytedef_table[tid].ientry[id]);
	} else {
	    gx_table_mod = NULL;	/* for extra care.	   */
	};
	if (gx_table_mod != NULL) {
	    if ((((gx_table_mod ->char_width) <= 2) /* short	   */
		  && (gx_table_mod ->unitbl == NULL)) ||
		(((gx_table_mod ->char_width) == 4)
		  && (gx_table_mod ->uniltbl == NULL))) {
		if (load_external_table(gx_table_mod) < 0) {
		    skferr(SKF_TABLEERR_G0A,(long)0,(long)0);
		    skf_terminate(EXIT_FAILURE);
		};
	    };
	    if ((gx_table_mod -> hook) != NULL) { /* has patch	  */
		(gx_table_mod->hook)();
	    };
#ifdef SKFDEBUG
	    if (is_vv_debug) {
		fprintf(stderr,"\n - g0alt_table(%lx): %s",
		    (gx_table_mod->char_width == 4) ?
			    (long) (gx_table_mod->uniltbl) :
			    (long) (gx_table_mod->unitbl),
		    gx_table_mod->desc);
	    };
#endif
	};
    };

/* g1 setting */
    if (i_codeset[in_codeset].g1def.tbl_index >= 0) {
	if ((is_jis(encode) || (is_msfam(encode)) ||
	    ((is_euc7(encode) || is_euc(encode)) && !(euc_protect))) &&
		    (pre_single_g1_table != NULL) && !is_in_encoded()) {
#ifdef SKFDEBUG
	    if (is_vv_debug) { fprintf(stderr,"\n- pre-g1"); };
#endif
	    g1_table_mod = pre_single_g1_table;
	} else {
	    tid = i_codeset[in_codeset].g1def.tbl_index;
	    id = i_codeset[in_codeset].g1def.index;
	    if ((tid >= 0) && (id >= 0)) {
		g1_table_mod = &(iso_ubytedef_table[tid].ientry[id]);
	    } else {
		g1_table_mod = NULL;	/* for extra care.	   */
	    };
	};
	if (g1_table_mod != NULL) {
	    if ((((g1_table_mod ->char_width) <= 2) /* short	   */
		  && (g1_table_mod ->unitbl == NULL)) ||
		(((g1_table_mod ->char_width) == 4)
		  && (g1_table_mod ->uniltbl == NULL))) {
		if ((res = load_external_table(g1_table_mod)) < 0) {
		    skferr(SKF_TABLEERR_G1,(long)0,(long)0); 
		    skf_terminate(EXIT_FAILURE);
		};
	    };
/* Note this setting is for initialize, omit FJ_CONVENSION test   */
	    if ((g1_table_mod -> hook) != NULL) { /* has patch	  */
		(g1_table_mod->hook)();
	    };
	    g1table2up();
#ifdef SKFDEBUG
	    if (is_vv_debug) {
		fprintf(stderr,"\n - g1_table(%lx): %s",
		    ((g1_table_mod->char_width) == 4) ?
			    (long) (g1_table_mod->uniltbl) :
			    (long) (g1_table_mod->unitbl),
		    g1_table_mod->desc);
	    };
#endif
	};
    };

/* g2 setting */
    if (i_codeset[in_codeset].g2def.tbl_index >= 0) {
	if (is_jiscat(encode) && (pre_single_g2_table != NULL)
		&& !is_in_encoded()) {
#ifdef SKFDEBUG
	    if (is_vv_debug) { fprintf(stderr,"\n- pre-g2"); };
#endif
	    g2_table_mod = pre_single_g2_table;
	} else {
	    tid = i_codeset[in_codeset].g2def.tbl_index;
	    id = i_codeset[in_codeset].g2def.index;
	    if ((tid >= 0) && (id >= 0)) {
		g2_table_mod = &(iso_ubytedef_table[tid].ientry[id]);
	    } else {
		g2_table_mod = NULL;	/* for extra care.	   */
	    };
	};
	if (g2_table_mod != NULL) {
	    if ((((g2_table_mod ->char_width) <= 2) /* short	   */
		  && (g2_table_mod ->unitbl == NULL)) ||
		(((g2_table_mod ->char_width) == 4)
		  && (g2_table_mod ->uniltbl == NULL))) {
		if (load_external_table(g2_table_mod) < 0) {
		    skferr(SKF_TABLEERR_G2,(long)0,(long)0);
		    skf_terminate(EXIT_FAILURE);
		};
	    };
	    if ((g2_table_mod -> hook) != NULL) { /* has patch	  */
		(g2_table_mod->hook)();
	    };
#ifdef SKFDEBUG
	    if (is_vv_debug) {
		fprintf(stderr,"\n - g2_table(%lx): %s",
		    (g2_table_mod->char_width == 4) ?
			    (long) (g2_table_mod->uniltbl) :
			    (long) (g2_table_mod->unitbl),
		    g2_table_mod->desc);
	    };
#endif
	};
    };

/* g3 setting */
    if (i_codeset[in_codeset].g3def.tbl_index >= 0) {
	if (is_jiscat(encode) && (pre_single_g3_table != NULL)
		&& !is_in_encoded()) {
#ifdef SKFDEBUG
	    if (is_vv_debug) { fprintf(stderr,"\n- pre-g3"); };
#endif
	    g3_table_mod = pre_single_g3_table;
	} else {
	    tid = i_codeset[in_codeset].g3def.tbl_index;
	    id = i_codeset[in_codeset].g3def.index;
	    if ((tid >= 0) && (id >= 0)) {
		g3_table_mod = &(iso_ubytedef_table[tid].ientry[id]);
	    } else {
		g3_table_mod = NULL;	/* for extra care.	   */
	    };
	};
	if (g3_table_mod != NULL) {
	    if ((((g3_table_mod ->char_width) <= 2) /* short	   */
		  && (g3_table_mod ->unitbl == NULL)) ||
		(((g3_table_mod ->char_width) == 4)
		  && (g3_table_mod ->uniltbl == NULL))) {
		if (load_external_table(g3_table_mod) < 0) {
		    skferr(SKF_TABLEERR_G3,(long)0,(long)0);
		    skf_terminate(EXIT_FAILURE);
		};
	    };
	    if ((g3_table_mod -> hook) != NULL) { /* has patch	  */
		(g3_table_mod->hook)();
	    };
#ifdef SKFDEBUG
	    if (is_vv_debug) {
		fprintf(stderr,"\n - g3_table(%lx): %s",
		    (g3_table_mod->char_width == 4) ?
			    (long) (g3_table_mod->uniltbl) :
			    (long) (g3_table_mod->unitbl),
		    g3_table_mod->desc);
	    };
#endif
	};
    };

#ifdef SKFDEBUG
	if (is_vv_debug) {
	    fprintf(stderr," - normal exit ");
	};
#endif

/* ------------------------------------------------------- */
/* Some codeset needs addtional (dirty) treatments...	   */
/*  Overlays are also handled here...			   */
/* ------------------------------------------------------- */
    code_table_fix();

    return(0);
}

/* --------------------------------------------------------------- */
void nec_g0_kanjiset()
{
    g0_table_mod = &(iso_3_dblbyte_defs[x0208_index]);
    g0table2low();
}

void nec_g0_kanaset()
{
    g0_table_mod = &(iso_unibyte_defs[x0201_index]);
    g0table2low();
}

/* --------------------------------------------------------------- */
/* parsing preselect code set option 				   */
/* --------------------------------------------------------------- */
static char *G0setstr = "ascii,jis";

static char *G1setstr = 
"x0208,x0212,iso8859-1..16,koi8-r/u,ecma94,jiskana,ksx_1001,gb2312,cns11643-1,cp1251..1255";
static char *G2setstr = 
"x0208,x0212,iso8859-1..16,koi8-r/u,ecma94,jiskana,ksx_1001,gb2312,cns11643-1,cp1251..1255";
static char *G3setstr = 
"x0208,x0212,iso8859-1..16,koi8-r/u,ecma94,jiskana,ksx_1001,gb2312,cns11643-1,cp1251..1255";

void skf_codeset_parser(parse)
int	parse;
{
    int parse_low = parse & SG_LOMASK;
    int parse_high = (parse & SG_HIMASK) >> SG_SHIFTLEN;
    struct iso_byte_defs *pre_table;

    if (parse_high >= ub_ovlay_index) {
	/* is_fatal: shouldn't be here unless test mode		  */
	error_code_option(SKF_UNKWNCSTOPT);
	skf_exit(EXIT_FAILURE);
    };
    if (parse_low >= iso_ubytedef_table[parse_high].deflimit) {
	/* also is_fatal: shouldn't be here unless test mode	  */
	error_code_option(SKF_UNKWNCSTOPT);
	skf_exit(EXIT_FAILURE);
    };
    pre_table = &(iso_ubytedef_table[parse_high].ientry[parse_low]);

    if ((parse & 0x1800) == 0x0000) {
	if ((iso_ubytedef_table[parse_high].setcap & G0_CAPABLE) != 0) {
#ifdef SKFDEBUG
	    if (is_vv_debug) fprintf(stderr,"  to g0");
#endif
	    pre_single_g0_table = pre_table;
	} else ValidValueDisplay(0, G0setstr);
    } else if ((parse & 0x1800) == 0x0800) {
	if (((iso_ubytedef_table[parse_high].setcap & G1_CAPABLE) != 0)
    && ((pre_table->char_width > 1) || (pre_table->table_len <= 128))) {
#ifdef SKFDEBUG
	    if (is_vv_debug) fprintf(stderr,"  to g1");
#endif
	    pre_single_g1_table = pre_table;
	} else ValidValueDisplay(1,G1setstr);
    } else if ((parse & 0x1800) == 0x1000) {
	if (((iso_ubytedef_table[parse_high].setcap & G2_CAPABLE) != 0) 
    && ((pre_table->char_width > 1) || (pre_table->table_len <= 128))) {
#ifdef SKFDEBUG
	    if (is_vv_debug) fprintf(stderr,"  to g2");
#endif
	    pre_single_g2_table = pre_table;
	} else ValidValueDisplay(2,G2setstr);
    } else if ((parse & 0x1800) == 0x1800) {
	if (((iso_ubytedef_table[parse_high].setcap & G3_CAPABLE) != 0) 
    && ((pre_table->char_width > 1) || (pre_table->table_len <= 128))) {
#ifdef SKFDEBUG
	    if (is_vv_debug) fprintf(stderr,"  to g3");
#endif
	    pre_single_g3_table = pre_table;
	} else ValidValueDisplay(3,G3setstr);
    } else {
	error_code_option(2); 
    };
#ifdef SKFDEBUG
    if (is_vv_debug) {
	fprintf(stderr,"-%s\n",pre_table->desc);
    };
#endif
}

/* --------------------------------------------------------------- */
/* input side table loader: load_external_table			   */
/* --------------------------------------------------------------- */
/* typ: bit14:  multibyte					   */
/* 	bit13:  '1' means non iso-2022 conformant charset	   */
/* 	bit12:  4-octet charset (1: 4 octet)			   */
/* 	bit11:  96-charset (0: 94-charset)			   */
/* 	bit6-0: invoke character				   */
/* return value:						   */
/*	0:  load succeeded 					   */
/*	-1: failed to load					   */
/* --------------------------------------------------------------- */
#ifdef DYNAMIC_LOADING
char *skf_table_magic = "skf_ctable20";
char *skf_table_lmagic = "skf_ctable40";

/*@-type@*/
       char *skf_ext_table = TABLEDIR;
#else
       char *skf_ext_table = "";
#endif

/*@-nullderef@*/ /*@null@*/ /*@-nullstate@*/ /*@-nullpass@*/
int load_external_table(tbl_entry)
struct iso_byte_defs *tbl_entry;
{
    unsigned long typ;
    unsigned short *code_tbl;
    skf_ucode *lcode_tbl;
    int i;
    int fail = 0;
#if	defined(DYNAMIC_LOADING) && !defined(SWIG_EXT)
    char *table_name;
    int	ch;
    skf_ucode lv;
    char *magic;
    FILE *table;
    int	j,k;
#endif

    code_tbl = NULL; lcode_tbl = NULL;

    if (disable_load) {		/* table loading feature disabled  */
	return(0);
    };

    if ((tbl_entry->unitbl != NULL)  /* we already has a table	   */
	|| (tbl_entry->uniltbl != NULL)) {
	return(0);
    };

    if (tbl_entry->table_len <= 0) {	/* table validations ...   */
	    in_tablefault(SKF_TBLNSUPPRT,tbl_entry->desc);
	return(-1);
    };

    typ = tbl_entry->is_kana;	/* use this property		   */
    if ((tbl_entry->char_width == 2) && (tbl_entry->unitbl != NULL)) {
	return(0);		/* already filled		   */
    };
    if ((tbl_entry->char_width == 4) && (tbl_entry->uniltbl != NULL)) {
	return(0);		/* already filled		   */
    };

    if ((tbl_entry->char_width != 2) && (tbl_entry->char_width != 4)
	&& (tbl_entry->char_width != 1)) {
	in_tablefault(SKF_TBLNSUPPRT,tbl_entry->desc);
	return(-1);
    };

    /* --- allocate buffer of the table -------------------------- */
    if (tbl_entry->char_width <= 2) { /* allocate table buffer	   */
      if ((code_tbl = calloc((size_t)(tbl_entry->table_len),
		sizeof(unsigned short))) == NULL) {
	skferr(SKF_MALLOCERR,(long)0,(long)0);
	skf_exit(EXIT_FAILURE);
      };
    } else {
      if ((lcode_tbl = calloc((size_t)(tbl_entry->table_len),
		sizeof(skf_ucode))) == NULL) {
	skferr(SKF_MALLOCERR,(long)0,(long)0);
	skf_exit(EXIT_FAILURE);
      };
    };

#if	defined(DYNAMIC_LOADING) && !defined(SWIG_EXT)
    /* --- generate name of the table ---------------------------- */
    if ((table_name = calloc(SKF_TABLE_PATH,sizeof(char))) == NULL) {
    	skferr(SKF_MALLOCERR,(long)0,(long)0);
	skf_exit(EXIT_FAILURE); 
    };

#ifdef CD_DEBUG
/* intermediate patch for make space insertion oddies */
    if (skf_ext_table[strlen(skf_ext_table)-1] == ' ') {
	fprintf(stderr,"space detect");
    };
#endif

    if (typ & COD_NISO) { 
	    ch = (charname_conv[(tbl_entry->defschar)-0x40]);
    } else {
    	if (tbl_entry->defschar < 0x40) {
	    if (tbl_entry->defschar == '?') ch = '%';
	    else ch = '.';
	} else
	    ch = (charname_conv[(tbl_entry->defschar)-0x40]);
    };
#if	defined(_WIN32) || defined(__MINGW32__)
    if (snprintf(table_name, SKF_TABLE_PATH-2, "%s\\i%c%c%c%c%c.stb",
#else
    if (snprintf(table_name, SKF_TABLE_PATH-2, "%s/i%c%c%c%c%c.stb",
#endif
	skf_ext_table,
	(typ & COD_NISO) 		? 
		((typ & COD_MB_4) ? 'O' : 'N') : 'I',
	((typ & COD_NISO) ?
	 ((tbl_entry->table_len > 256)	? 'M' : 'S') :
	 ((typ & COD_MB)		? 'M' : 'S')),
	(typ & COD_MB_4)		? '4' : '3',
    /* call letter capitalize, for windows are case insensitive	   */
	(((ch >= 'a') && (ch <= 'z')) ?
	((typ & COD_SET96)		? '7' : '5') :
	((typ & COD_SET96)		? '6' : '4')),
	SKFtoupper(ch)) < 0) {
	skferr(SKF_TBLALLOCERR,(long)0,(long)0);
	skf_exit(EXIT_FAILURE);	/* likely to fail after this.	   */
    };

    /* --- table loading ----------------------------------------- */
#ifdef SKFDEBUG
    if (is_v_debug) 
		fprintf(stderr,"\n- loading table:%s ",table_name);
#endif
    if ((table = fopen(table_name,"r")) == NULL) {
				/* failed to open		   */
	    in_tablefault(SKF_TBLUNDEF,tbl_entry->desc);
	if (disp_warn) {
	    fprintf(stderr,"expected table name: %s ",table_name);
	};
#ifdef SKFDEBUG
	if (is_v_debug) fprintf(stderr,"- failed\n");
#endif
	free(table_name); fail = 1;
    } else {			/* can open. Then test magic	   */
	free(table_name); i = 0;
	if (tbl_entry->char_width <= 2) magic = skf_table_magic;
	else magic = skf_table_lmagic;
	while (*magic != '\0') {
	    if (*magic++ != getc(table)) {
		in_tablefault(SKF_TBLINCNSIS,tbl_entry->desc);
#ifdef SKFDEBUG
	if ((is_v_debug) && (fail == 1)) fprintf(stderr,"- corrupted\n");
#endif
		fail = 1; break;
	    };
	};
#ifdef SKFDEBUG
	if ((is_v_debug) && (fail != 1)) fprintf(stderr,"- succeeded ");
#endif
    };
    if (fail == 0) {		/* table open succeeded		   */
	if (tbl_entry->char_width <= 2) {
#ifdef SKFDEBUG
	if (is_vvv_debug) fprintf(stderr,"(2*%d) ",tbl_entry->table_len);
#endif
	  for (i=0;i<tbl_entry->table_len; i++) {
	    /* table is stored using big endian			   */
	    if ((j = getc(table)) == EOF) {
		in_tablefault(SKF_TBLSHORT,tbl_entry->desc);
		goto LXT_2TBLEOF;
	    };
	    if ((k = getc(table)) == EOF) {
		in_tablefault(SKF_TBLSHORT,tbl_entry->desc);
		goto LXT_2TBLEOF;
	    };
	    code_tbl[i] = (unsigned short)(((j << 8) + k) & 0xffff);
	    if (((j >= 0xa5) && (j < 0xac))
		|| ((j >= 0xe0) && (j < 0xf9) 
			&& is_tbl_man(tbl_entry->is_kana))) {
		in_tablefault(SKF_TBLBROKN,tbl_entry->desc);
		break;
	    };
	  }; 
LXT_2TBLEOF:
	  ;
	} else {
#ifdef SKFDEBUG
	if (is_vvv_debug) fprintf(stderr,"(4*%d) ",tbl_entry->table_len);
#endif
	  for (i=0;i<tbl_entry->table_len; i++) {
	    /* table is stored using big endian			   */
	    lv = 0;
	    for (j=0;j<4;j++) {
		if ((k = getc(table)) == EOF) {
		    in_tablefault(SKF_TBLSHORT,tbl_entry->desc);
		    lv = 0;
		    goto LXT_4TBLEOF;
		};
		lv = (lv << 8) + k;
	    };
	    lcode_tbl[i] = (skf_ucode)(lv & 0x1fffff);
	  };
LXT_4TBLEOF:
	  ;
	};
	fclose(table);
    } else ;
#else
	/* !DYNAMIC_LOADING or SWIG_EXT		*/
    if (tbl_entry->hook != NULL) { /* if generator exists,	   */
	(tbl_entry->hook)();	   /*  ... do it.		   */
    };
    /* --- table padding ----------------------------------------- */
    if (tbl_entry->char_width <= 2) {
	if ((tbl_entry->unitbl) == NULL) {  /* still empty	   */
	    for (i=0;i<tbl_entry->table_len; i++) {
		code_tbl[i] = (unsigned short) 0;
	    }; 
	    fail = 1;
	};
    } else {
	if ((tbl_entry->unitbl) == NULL) {  /* still empty	   */
	    for (i=0;i<tbl_entry->table_len; i++) {
		lcode_tbl[i] = (unsigned short) 0;
	    }; 
	    fail = 1;
	};
    };
#endif
    if (tbl_entry->char_width <= 2) {
	tbl_entry->unitbl = code_tbl;
    } else {
	tbl_entry->uniltbl = lcode_tbl;
    };
#if defined(DYNAMIC_LOADING) && !defined(SWIG_EXT)
#ifdef SKFPDEBUG
    if (table_dump) {
	fprintf(stderr,"table_dump:");
	for (i=0;i<tbl_entry->table_len;i++) {
	    if ((i& 0x07) == 0) fprintf(stderr,"\n%04x:",i);
	    if (tbl_entry->char_width <= 2) {
		fprintf(stderr," %04x",tbl_entry->unitbl[i]);
	    } else {
		fprintf(stderr," %06x",tbl_entry->uniltbl[i]);
	    };
	};
    };
#endif
#endif
    return((fail) ? -1 : 0);
}

/* --------------------------------------------------------------- */
int is_g0_table_x0201()
{
    if (g0_table_mod == &(iso_unibyte_defs[x0201_index])) return(TRUE);
    else return(FALSE);
}

#ifdef UNI_DECOMPOSE
/* --------------------------------------------------------------- */
/* get unicode normalize/denormalize table			   */
/* --------------------------------------------------------------- */
void unicode_normalize_setup()
{
#ifdef DYNAMIC_LOADING
    int res;
#endif
    if (enbl_decomp) {
    	if (!decomp_comp) {
			/* Unicode compatible normalize */
#ifdef DYNAMIC_LOADING
	  res = load_external_table(&ovlay_byte_defs[unicode_nkdl_index]);
	  res += load_external_table(&ovlay_byte_defs[unicode_nkdp_index]);
	  res += load_external_table(&ovlay_byte_defs[unicode_nstr_index]);
	  if ((ovlay_byte_defs[unicode_nkdl_index].unitbl == NULL)
	    ||(ovlay_byte_defs[unicode_nkdp_index].uniltbl == NULL)
	    ||(ovlay_byte_defs[unicode_nstr_index].unitbl == NULL)
	    || (res < 0)) {
	    res_enbl_decomp;
	  };
#endif
	  nkdc_lowptr = ovlay_byte_defs[unicode_nkdl_index].unitbl;
	  nkdc_lowmap = ovlay_byte_defs[unicode_nkdp_index].uniltbl;
	  nkd_strmap = ovlay_byte_defs[unicode_nstr_index].unitbl;
	  if (decomp_apple) {
	  	nkdc_lowptr[0x1b06 - 0xa0] = 0;
	  	nkdc_lowptr[0x1b08 - 0xa0] = 0;
	  	nkdc_lowptr[0x1b0a - 0xa0] = 0;
	  	nkdc_lowptr[0x1b0c - 0xa0] = 0;
	  	nkdc_lowptr[0x1b0e - 0xa0] = 0;
	  	nkdc_lowptr[0x1b12 - 0xa0] = 0;
	  	nkdc_lowptr[0x1b3b - 0xa0] = 0;
	  	nkdc_lowptr[0x1b3d - 0xa0] = 0;
	  	nkdc_lowptr[0x1b40 - 0xa0] = 0;
	  	nkdc_lowptr[0x1b41 - 0xa0] = 0;
	  	nkdc_lowptr[0x1b43 - 0xa0] = 0;
	  	;
	  };
    	} else if (decomp_comp && decomp_apple) {
			/* Apple compatible nfc normalize */
#ifdef DYNAMIC_LOADING
	  res = load_external_table(&ovlay_byte_defs[unicode_nacl_index]);
	  res += load_external_table(&ovlay_byte_defs[unicode_nadp_index]);
	  res += load_external_table(&ovlay_byte_defs[unicode_nstr_index]);
	  if ((ovlay_byte_defs[unicode_nkdl_index].unitbl == NULL)
	    ||(ovlay_byte_defs[unicode_nkdp_index].uniltbl == NULL)
	    ||(ovlay_byte_defs[unicode_nstr_index].unitbl == NULL)
	    || (res < 0)) {
	    res_enbl_decomp;
	  };
#endif
	  nkdc_lowptr = ovlay_byte_defs[unicode_nacl_index].unitbl;
	  nkdc_lowmap = ovlay_byte_defs[unicode_nadp_index].uniltbl;
	  nkd_strmap = ovlay_byte_defs[unicode_nstr_index].unitbl;
	} else {
			/* Unicode compatible nfc normalize */
#ifdef DYNAMIC_LOADING
	  res = load_external_table(&ovlay_byte_defs[unicode_nkcl_index]);
	  res += load_external_table(&ovlay_byte_defs[unicode_nkdp_index]);
	  res += load_external_table(&ovlay_byte_defs[unicode_nstr_index]);
	  if ((ovlay_byte_defs[unicode_nkcl_index].unitbl == NULL)
	    ||(ovlay_byte_defs[unicode_nkdp_index].uniltbl == NULL)
	    ||(ovlay_byte_defs[unicode_nstr_index].unitbl == NULL)
	    || (res < 0)) {
	    res_enbl_decomp;
	    res_decomp_comp;
	  };
#endif
	  nkdc_lowptr = ovlay_byte_defs[unicode_nkcl_index].unitbl;
	  nkdc_lowmap = ovlay_byte_defs[unicode_nkdp_index].uniltbl;
	  nkd_strmap = ovlay_byte_defs[unicode_nstr_index].unitbl;
	};
    };
    /* all table must be valid */
    if (enbl_decomp && ((nkdc_lowptr == NULL) || (nkdc_lowmap == NULL)
	  	|| (nkd_strmap == NULL))) {
	in_tablefault(SKF_PRESETFAIL,"denormalize");
	res_enbl_decomp;
    };
}
#endif

/* --------------------------------------------------------------- */
/* code table fix for variants 					   */
/* --------------------------------------------------------------- */
/* jix_x0208 swap table: swapped characters at JIS C6226(1978)     */
/*			  to JIS C6226(1983) conversion.	   */
/* --------------------------------------------------------------- */
unsigned short jis_x0208_swap_table[] = {
    0x01ad,0x0318, 0x0af7,0x0afa, 0x172a,0x16b9, 0x1a67,0x1c9c,
    0x1abc,0x1cae, 0x1f9b,0x21e4, 0x2145,0x224c, 0x2a3a,0x2b2a,
    0x2a3f,0x2b26, 0x2cc3,0x2cc8, 0x2ded,0x2e60, 0x37ae,0x37ea,
    0x374a,0x3802, 0x38ce,0x3a23, 0x397f,0x3a05, 0x3ccc,0x3ceb,
    0x3ee4,0x3ece, 0x41e9,0x4287, 0x496d,0x4971, 0x4a1a,0x4a38,
    0x4df5,0x4e3a, 0x4f2c,0x4faf,
    0
};

unsigned short *uni_t_sjisx208 = NULL;

/* swap handling: */
/*   cp932, jis c6226(1978), jis x0208(1990) and 
	Macintosh Kanjitalk gliches */
void code_table_fix()
{
    int i;
    unsigned long	encode;
    unsigned short	*utbl = NULL;
    unsigned short	*mtbl;

#ifdef SKFDEBUG
    if (is_vv_debug) fprintf(stderr," code_tbl_fix");
#endif
    /* ------------------------ */
    /* get encode		*/
    /* ------------------------ */
    encode = i_codeset[in_codeset].encode;
    /* ------------------------ */
    /* M*cintosh Table fix	*/
    /* ------------------------ */
    if (use_apple_gaiji) {
#ifdef DYNAMIC_LOADING
	if (ovlay_byte_defs[mac_ovlay_index].unitbl == NULL) {
	  if (load_external_table(
		    &(ovlay_byte_defs[mac_ovlay_index])) < 0) {

	    in_tablefault(SKF_TBLUNDEF,
			ovlay_byte_defs[mac_ovlay_index].desc);
	  };
	};
#endif

	mtbl = ovlay_byte_defs[mac_ovlay_index].unitbl;
	for (i=0;i<94;i++) {
	  uni_t_x208[0x02f0 + i] = mtbl[i]; /* 29xx */
	  uni_t_x208[0x034e + i] = mtbl[i + (94 * 1)]; /* 2axx */
	  uni_t_x208[0x03ac + i] = mtbl[i + (94 * 2)]; /* 2bxx */
	  uni_t_x208[0x040a + i] = mtbl[i + (94 * 3)]; /* 2cxx */
	  uni_t_x208[0x0468 + i] = mtbl[i + (94 * 4)]; /* 2dxx */
	  uni_t_x208[0x04c6 + i] = mtbl[i + (94 * 5)]; /* 2exx */
	  uni_t_x208[0x0524 + i] = mtbl[i + (94 * 6)]; /* 2fxx */
	  uni_t_x208[0x1ed8 + i] = mtbl[i + (94 * 7)]; /* 75xx */
	  uni_t_x208[0x1ff2 + i] = mtbl[i + (94 * 8)]; /* 78xx */
	  if (mtbl[i + (94 * 9)] != 0) {
	    uni_t_x208[0x2050 + i] = mtbl[i + (94 * 9)]; /* 79xx */
	  };
	};
	uni_t_x208[0x000f] = 0x203e;		/* overline 	   */
	uni_t_x208[0x001c] = 0x2014;		/* em dash	   */
	uni_t_x208[0x001f] = 0xff3c;		/* back slash	   */
	uni_t_x208[0x00a3] = 0x223d;		/* reversed tilde  */
    };

    /* ------------------------ */
    /* OpenMotif Table fix	*/
    /* ------------------------ */
/* open motif table is different from JIS at this code point	   */
    if (use_cde_compat) {		/* also X-0221 compat	   */
	uni_t_x208[0x001c] = 0x2014;		/* em dash	   */
    };

    /* ------------------------ */
    /* Wind*ws Table fix	*/
    /* ------------------------ */
    if (is_ms_932(encode) || is_cp5022x(encode) 
    		|| is_euc_51932(encode)) {
	set_use_ms_compat;
	set_use_compat;
    };
    if (use_ms_compat) {  	/* based on cp932 table		   */
	if (is_jis(encode)) {
	    utbl = gx_table_mod->unitbl;
	} else if (is_msfam(encode) || is_euc(encode)
		|| is_keis(encode) || is_ucs_brgt(encode)) {
	    utbl = g1_table_mod->unitbl;
	};
	if (utbl != NULL) {
	    utbl[0x001f] = 0xff3c;		/* back slash	   */
	    utbl[0x0020] = 0xff5e;		/* wavy dash	   */
	    utbl[0x0021] = 0x2225;		/* double v-bar	   */
	    utbl[0x003c] = 0xff0d;		/* Fullwidth minus */
	    utbl[0x0050] = 0xffe0;		/* Cent		   */
	    utbl[0x0051] = 0xffe1;		/* Pound	   */
	    utbl[0x0089] = 0xffe2;		/* fullwidth not   */
	    utbl[0x00a3] = 0x223d;		/* reversed tilde  */
	};
	uni_t_x212[0x0074] = 0xff5e;		/* tilde 	   */
	uni_t_x212[0x0080] = 0xffe4;		/* broken bar	   */
    };

    /* -------------------------------- */
    /* x-0208(1983) - x0208(1990) swap	*/
    /* -------------------------------- */
    if ((use_cde_compat) || (is_euc_eucms(encode))) {
	for (i=0; i< 28; i++) {
	   uni_t_x212[7708+i] = uni_k_ibm_fa[i];
	};
	for (i=0; i< 188-28; i++) {
	   uni_t_x212[7708+i+28] = uni_t_x208[8272+i];
	};
    };

    /* ------------------------ */
    /* SJIS preset		*/
    /* ------------------------ */
    uni_t_sjisx208 = uni_t_x208;

    /* ------------------------ */
    /* JIS C6226:1978 support   */
    /* ------------------------ */
    if (!in_detect_jis78) {	/* jef, jis78 is detected by defs.   */
	iso_4_dblbyte_defs[x0208_o_index].unitbl = uni_t_x208;
	iso_3_dblbyte_defs[x0208_o_index].unitbl = uni_t_x208;
#ifdef DYNAMIC_LOADING
    } else {
      if (iso_3_dblbyte_defs[x0208_o_index].unitbl == NULL) {
	if (load_external_table(
		&(iso_3_dblbyte_defs[x0208_o_index])) < 0) {
	/* error has been displayed in load_external_table anyway    */
	    iso_3_dblbyte_defs[x0208_o_index].unitbl = 
		iso_4_dblbyte_defs[x0208_o_index].unitbl;
	} else {
	    iso_4_dblbyte_defs[x0208_o_index].unitbl = 
		iso_3_dblbyte_defs[x0208_o_index].unitbl;
	};
      };
#endif
    };
    /* ------------------------ */
    /* nec gaiji part disable	*/
    /* ------------------------ */
    if (dsbl_nec_gaiji && 
	(is_euc_eucms(encode) || is_euc_51932(encode) ||
	 is_euc_20932(encode) || is_jis_jis(encode) ||
	 is_jis_932(encode) || is_msfam(encode) || is_euc_eucjp(encode))) {
	for (i=12*94; i< 13*94;i++) {
	    uni_t_x208[i] = 0;
#if	!defined(DYNAMIC_LOADING)
	    if (cp932_uni_byte != NULL) cp932_uni_byte[i] = 0;
	    if (cp932w_uni_byte != NULL) cp932w_uni_byte[i] = 0;
#endif
	};
    };

#ifdef DYNAMIC_LOADING
    /* ------------------------ */
    /* Cellular phone Table fix	*/
    /* ------------------------ */
    if (is_ms_cel(encode)) {
      if (use_old_cell_map &&
      		(ovlay_byte_defs[nttgrc1_index].unitbl == NULL)) {
	if (load_external_table(
		  &(ovlay_byte_defs[nttgrc1_index])) < 0) {
	  in_tablefault(SKF_TBLUNDEF,ovlay_byte_defs[nttgrc1_index].desc);
	  ovlay_byte_defs[nttgrc1_index].unitbl = 
	  	calloc(ovlay_byte_defs[nttgrc1_index].table_len,
			sizeof(unsigned short));
	};
      } else;
      if ((in_codeset == codeset_sjiscl) &&
      		(ovlay_byte_defs[nttemot_index].unitbl == NULL)) {
	if (load_external_table(
		  &(ovlay_byte_defs[nttemot_index])) < 0) {
	  in_tablefault(SKF_TBLUNDEF,ovlay_byte_defs[nttemot_index].desc);
	  ovlay_byte_defs[nttemot_index].unitbl = 
	  	calloc(ovlay_byte_defs[nttemot_index].table_len,
			sizeof(skf_ucode));
	};
      } else;
      if ((in_codeset == codeset_sjisau) &&
      		(ovlay_byte_defs[auemot_index].unitbl == NULL)) {
	if (load_external_table(
		  &(ovlay_byte_defs[auemot_index])) < 0) {
	  in_tablefault(SKF_TBLUNDEF,ovlay_byte_defs[auemot_index].desc);
	  ovlay_byte_defs[auemot_index].unitbl = 
	  	calloc(ovlay_byte_defs[auemot_index].table_len,
			sizeof(skf_ucode));
	};
      } else;
      if ((in_codeset == codeset_sjissb) &&
      		(ovlay_byte_defs[sbemot_index].unitbl == NULL)) {
	if (load_external_table(
		  &(ovlay_byte_defs[sbemot_index])) < 0) {
	  in_tablefault(SKF_TBLUNDEF,ovlay_byte_defs[sbemot_index].desc);
	  ovlay_byte_defs[sbemot_index].unitbl = 
	  	calloc(ovlay_byte_defs[sbemot_index].table_len,
			sizeof(skf_ucode));
	};
      } else;
    };
#endif

    /* ------------------------ */
    /* JIS x0213 overlay	*/
    /* ------------------------ */
    if ((is_ms_213(encode) || is_ms_213n(encode)) 
	|| (is_euc_213(encode) || is_euc_213n(encode))) {
#ifdef DYNAMIC_LOADING
	if (load_external_table(
		&(iso_4_dblbyte_defs[x0213_2_index])) < 0) {
	    in_tablefault(SKF_PRESETFAIL,
			iso_4_dblbyte_defs[x0213_2_index].desc);
	};
#endif
    };

    /* ------------------------ */
    /* GB18030 overlay		*/
    /* ------------------------ */
    if (is_gb18030(encode)) {
#ifdef DYNAMIC_LOADING
	if (load_external_table(
		&(ovlay_byte_defs[gb18030_a5_index])) < 0) {
	    in_tablefault(SKF_PRESETFAIL,
			ovlay_byte_defs[gb18030_a5_index].desc);
	};
#endif
    };

    /* ------------------------ */
    /* UTF-8 Cellular overlay	*/
    /* ------------------------ */
    if (is_ucs_ufam(encode) && enable_cellconvert) {
#ifdef DYNAMIC_LOADING
	if (load_external_table(
		&(ovlay_byte_defs[emot_prv_c_index])) < 0) {
	    in_tablefault(SKF_PRESETFAIL,
			ovlay_byte_defs[emot_prv_c_index].desc);
	};
#endif
    };
}

/* --------------------------------------------------------------- */
/* table extracter						   */
/* --------------------------------------------------------------- */
/*@null@*//*@-immediatetrans@*/
struct iso_byte_defs *get_jisx0213_1_table()
{
    if (load_external_table(
		&(iso_4_dblbyte_defs[x0213_1_index])) < 0) {
	    in_tablefault(SKF_PRESETFAIL,
			iso_4_dblbyte_defs[x0213_1_index].desc);
	    return(NULL);
    };
    return(&(iso_4_dblbyte_defs[x0213_1_index]));
}

#endif

#if !defined(OUTPUT_DYNAMIC_TABLE)
/* --------------------------------------------------------------- */
/* dummy table generator					   */
/* --------------------------------------------------------------- */
static skf_ucode *skf_dummy_ltable = NULL;

skf_ucode *input_get_dummy_ltable()
{
    if (skf_dummy_ltable == NULL) {
	if ((skf_dummy_ltable =
		calloc(ISOMB_CODE_END,sizeof(skf_ucode))) == NULL) {
		skferr(SKF_TBLALLOCERR,3,2);
		skf_exit(EXIT_FAILURE);
	} else;
    } else;
    return (skf_dummy_ltable);
}
/* --------------------------------------------------------------- */
static unsigned short *skf_dummy_table = NULL;

unsigned short *input_get_dummy_table()
{
    if (skf_dummy_table == NULL) {
	if ((skf_dummy_table =
		calloc(ISOMB_CODE_END,sizeof(unsigned short))) == NULL) {
		skferr(SKF_TBLALLOCERR,3,3);
		skf_exit(EXIT_FAILURE);
	} else;
    } else;
    return (skf_dummy_table);
}
#endif

/* --------------------------------------------------------------- */
