/* # skkinput (Simple Kana-Kanji Input)
 * Ximp.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(Ximp_h)
#define Ximp_h

#define XtNdefaultXimpServer	"defaultXimpServer"
#define XtCDefaultXimpServer	"DefaultXimpServer"

#include "commondef.h"
#include "resrcs.h"
#include "kanji.h"
#include "attrs.h"

#define XIMP_PROTOCOL_VERSION	"XIMP.3.5"

enum {
  XIMP_KEYPRESS = 1,
  XIMP_CREATE,     XIMP_DESTROY, XIMP_BEGIN,  XIMP_END,   XIMP_SETFOCUS,
  XIMP_UNSETFOCUS, XIMP_CHANGE,  XIMP_MOVE,   XIMP_RESET, XIMP_SETVALUE,
  XIMP_GETVALUE, 

  XIMP_PREEDITSTART_RETURN = 20, XIMP_PREEDITCARET_RETURN,

  XIMP_CREATE_RETURN = 2,
  XIMP_PROCESS_BEGIN  = 30, XIMP_CONVERSION_BEGIN = 30,
  XIMP_CONVERSION_END = 31, XIMP_PROCESS_END	  = 31, 
  XIMP_READPROP, XIMP_GETVALUE_RETURN, XIMP_RESET_RETURN, 

  XIMP_GEOMETRY	= 40, XIMP_PREEDITSTART, XIMP_PREEDITDONE, 
  XIMP_PREEDITDRAW, XIMP_PREEDITDRAW_CM, XIMP_PREEDITCARET, 
  XIMP_STATUSSTART, XIMP_STATUSDONE, XIMP_STATUSDRAW, XIMP_STATUSDRAW_CM,

  XIMP_EXTENSION = 90,
  XIMP_ERROR = 99,
} ;

enum {
  XIMP_NoError = 0,     XIMP_BadAlloc,       XIMP_BadStyle,       
  XIMP_BadClientWindow, XIMP_BadFocusWindow, XIMP_BadArea, 
  XIMP_BadSpotLocation, XIMP_BadColormap,    XIMP_BadAtom,
  XIMP_BadPixel,        XIMP_BadPixmap,      XIMP_BadName,
  XIMP_BadCursor,       XIMP_BadProtocol,    XIMP_BadProperty,
  XIMP_BadPropertyType,
} ;

/* mask (XIMP_CREATE, XIMP_SETVALUE, XIMP_GETVALUE) */
#define XIMP_FOCUS_WIN_MASK		(1L <<  0)
#define XIMP_PRE_AREA_MASK		(1L <<  1)
#define XIMP_PRE_FG_MASK		(1L <<  2)
#define XIMP_PRE_BG_MASK		(1L <<  3)
#define XIMP_PRE_COLORMAP_MASK		(1L <<  4)
#define XIMP_PRE_BGPIXMAP_MASK		(1L <<  5)
#define XIMP_PRE_LINESP_MASK		(1L <<  6)
#define XIMP_PRE_CURSOR_MASK		(1L <<  7)
#define XIMP_PRE_AREANEED_MASK		(1L <<  8)
#define XIMP_PRE_SPOTL_MASK		(1L <<  9)
#define XIMP_STS_AREA_MASK		(1L << 10)
#define XIMP_STS_FG_MASK		(1L << 11)
#define XIMP_STS_BG_MASK		(1L << 12)
#define XIMP_STS_COLORMAP_MASK		(1L << 13)
#define XIMP_STS_BGPIXMAP_MASK		(1L << 14)
#define XIMP_STS_LINESP_MASK		(1L << 15)
#define XIMP_STS_CURSOR_MASK		(1L << 16)
#define XIMP_STS_AREANEED_MASK		(1L << 17)
#define XIMP_STS_WINDOW_MASK		(1L << 18)
#define XIMP_PRE_FONT_MASK		(1L << 19)
#define XIMP_STS_FONT_MASK		(1L << 20)

/* FRONTEND or BACKEND MODE */
#define XIMP_FRONTEND	 0
#define XIMP_BACKEND	 1

/* _XIMP_KEYS   struct  */
typedef struct {
  unsigned long   modifier ;
  unsigned long   modifier_mask ;
  KeySym          keysym ;
} Ximp_Key ;

typedef struct {
  unsigned short  count_keys ;
  Ximp_Key       *keys_list ;
} Ximp_KeyList ;

/* kana-kanji conversion window attributes */
#define XIMP_PREEDIT_MAX_LONG 14
#define XIMP_PREEDIT_MAX_CHAR 56
#define XIMP_STATUS_MAX_LONG 13
#define XIMP_STATUS_MAX_CHAR 52

typedef struct {
  XIMStyle style ;
  int inputStyle ;
  int history ;
} XimpInputStyle ;

#define PREEDIT_MASK (XIMP_PRE_AREA_MASK|XIMP_PRE_FG_MASK|XIMP_PRE_BG_MASK|\
		      XIMP_PRE_COLORMAP_MASK|XIMP_PRE_BGPIXMAP_MASK|\
		      XIMP_PRE_LINESP_MASK|XIMP_PRE_CURSOR_MASK|\
		      XIMP_PRE_AREANEED_MASK|XIMP_PRE_SPOTL_MASK)
#define STATUS_MASK (XIMP_STS_AREA_MASK|XIMP_STS_FG_MASK|XIMP_STS_BG_MASK|\
		     XIMP_STS_COLORMAP_MASK|XIMP_STS_BGPIXMAP_MASK|\
		     XIMP_STS_LINESP_MASK|XIMP_STS_CURSOR_MASK|\
		     XIMP_STS_AREANEED_MASK|XIMP_STS_WINDOW_MASK)


typedef struct {
  Position	area_x, area_y ;
  Dimension	area_width, area_height ;
  Pixel		foreground, background ;
  Colormap	colormap ;
  Pixmap	background_pixmap ;
  Dimension	line_spacing ;
  Cursor	cursor ;
  Dimension	needed_width, needed_height ;
  Position	spot_x, spot_y ;
  unsigned char *fontlist ;
} XimpAttributes ;

struct XimpClient {
  Widget		protocol_widget ;
  Window 		request_window ;
  Window		focus_window ;
  Window		probe_window ;
  Window		status_window ;
  unsigned long		attribute_mask ;
  unsigned char		*client_version ;
  Atom			property ;

  unsigned long		id ;
  XimpInputStyle	*style ;
  int			event_capture_method ;
  XClientMessageEvent	xevent ;
  int			already_initial_setup ;

  XimpAttributes	preedit_attributes ;
  XimpAttributes	status_attributes ;

  /* ѤƤեȡ*/
  struct skkinputManagedFont	*fontset[ NUMBER_OF_CHARSET ] ;

  /* ºݤѴ򤷤Ƥ off-the-spot ʤɤؤ*/
  Widget 		skkinput ;

  int 			resetting ;
  /* ˴ True ˤʤ롣̾ skkinput  XtDestroyWidget  *
   * ˤϡto_destroy  False ΤޤޤǤꡢǡǤ    *
   * XimClient ϻĤ롣Υե饰 True ˤȡǡ  *
   * ˴롣*/
  int			to_destroy ;

  unsigned int		request_width, request_height ;
  unsigned int		focus_width, focus_height ;

  struct ConvAttrsMesg	camsg ;

  struct XimpClient	*next ;
} ;

typedef struct _XimpRec		*XimpWidget ;
typedef struct _XimpClassRec	*XimpWidgetClass ;

extern WidgetClass ximpWidgetClass ;

#endif

