#ifndef mr__curl_h
#define mr__curl_h

/*
 * C++ wrapper dla biblioteki Curl
 * C++ parser do stron HTML z formularzami
 *
 * Mikolaj Rydzewski, miki@ceti.pl
 * 
 * $Id: mr_curl.h,v 1.15 2005/02/04 00:37:39 miki Exp $
 *
 */

#if (__GNUC__ >= 3)
#define _mr_use_stringstream
#else
#define _mr_use_strstream
#endif

#ifdef _mr_use_stringstream
#include <sstream>
typedef std::stringstream C_STREAM;
#else
#include <strstream>
typedef std::strstream C_STREAM;
#endif

#include <iostream>
#include <string>
#include <map>
#include <curl/curl.h>


class FormParser {
public:
	typedef std::map<std::string, std::string> Array;
private:
	Array elems;
	std::string html;
	std::string action;

	std::string extract(const std::string &name, const std::string &buf);
	void readFields(const std::string &form);
public:
	FormParser() { SetPage(""); };
	FormParser(const std::string &html) { SetPage(html); };
	void SetPage(const std::string &new_html);
	bool ReadForm(const std::string &name);
	
	std::string &operator[](const std::string &name);
	std::string getAction() const { return action; };
	const Array &getElems() const { return elems; };
	void set(const std::string &name, long val);
	
	friend std::ostream &operator<<(std::ostream &os, const FormParser &form);
};



class Curl_Form {
	struct curl_httppost *post, *last;
public:
	Curl_Form() : post(NULL), last(NULL) {};
	Curl_Form(const FormParser &form);
	~Curl_Form();
	
	void Reset();
	void CopyFrom(const FormParser &form);
	Curl_Form &operator=(const FormParser &form);
	

	struct curl_httppost *GetPost() { return post; };
	
	std::string PostFields();

	// dodaje pole typu 'input' - kopiuje wartosci do pamieci biblioteki
	void AddField(const std::string &name, const std::string &value);
	
	void AddField(const std::string &name, long value);

	// dodaje pole typu 'input' z binarna zwartoscia (bufor z podanym rozmiarem),
	void AddBuffer(const std::string &name, const void *buffer, long buffer_len);

	// dodaje pole uploadu pliku (pobiera plik z dysku)
	void AddFile(const std::string &name, const std::string &filename);
};

class Curl;

class Curl_Result {
public:	
	typedef std::map<std::string, std::string> HeadersArray;
private:
	std::string body, result;
	HeadersArray headers, cookies;
	
	void SetBody(const std::string &b) { body = b; };
	void SetHeaders(std::istream &is);
public:
	Curl_Result() {};
	Curl_Result(const Curl_Result &cr);
	Curl_Result &operator=(const Curl_Result &cr);
	
	const std::string &Body() { return body; };
	HeadersArray &Headers() { return headers; };
	
	friend class Curl;
};


class Curl {
	CURL *curl;
	CURLcode error_code;
	C_STREAM *buffer, *headers;
	char *error_buffer;
	std::string useragent, proxy_host, url, postfields,
		proxy_login, proxy_pass, proxy_authstr;
	int proxy_port;
public:	
	Curl();
	~Curl();
	CURLcode SetOpt(CURLoption option, const void *param);
	CURLcode SetPost(Curl_Form *form);
	CURLcode PerformPost(const std::string &url, const std::string &postfields, int size=0);
	CURLcode PerformPost(const std::string &url, Curl_Form *form);
	CURLcode PerformPost(const std::string &url, Curl_Form &form);
	CURLcode PerformGet(const std::string &url);
	CURLcode Perform();
	C_STREAM &BufferStream() { return *buffer; };
	std::string Body();
	C_STREAM &HeadersStream() { return *headers; };
	std::string Headers();
	Curl_Result Result();
	const char* ErrorStr();
	CURLcode ErrorCode() { return error_code; };

	void Verbose(bool verbose = true);
	void AutoReferer(bool referer = true);
	void FollowLocation(bool follow = true, long max_redirs = 10);
	void UserAgent(const char *ua);
	void Proxy(const char *host, int port,
			const char *login = NULL,
			const char *pass = NULL,
			int auth_type = CURLAUTH_BASIC);
	void Proxy(const std::string &proxy,
			const char *login = NULL,
			const char *pass = NULL,
			int auth_type = CURLAUTH_BASIC);
	void SSL_ignore();
	
	static void Curl_Init() {
		curl_global_init(CURL_GLOBAL_ALL);
	};
	static void Curl_Done() {
		curl_global_cleanup();
	};
	
	friend size_t Curl_write_data(const void *ptr, size_t size,
			size_t nmemb, Curl *curl);
	friend size_t Curl_write_header(const void *ptr, size_t size,
			size_t nmemb, Curl *curl);
};

class CurlGlobal {
public:
	CurlGlobal() {
		curl_global_init(CURL_GLOBAL_ALL);
	};
	~CurlGlobal() {
		curl_global_cleanup();
	}
};

#endif

