#include "plus.h"

using namespace std;

PlusSMS::PlusSMS(Config &config) : GenericSMS(config)
{
	email = config["mailaddr"];
}

bool PlusSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;

	while (true) {
		form.AddField("tprefix", phone_no.substr(3, 3));
		form.AddField("numer", phone_no.substr(6, 6));
		form.AddField("odkogo", email);
		form.AddField("tekst", message);
		form.AddField("dzien", "2003-01-30");
		form.AddField("godz", "12");
		form.AddField("min", "15");
		form.AddField("charno", "159");
		form.AddField("smsno", "1");
		
		status = curl.PerformPost("www.text.plusgsm.pl/sms/sendsms.php", form.PostFields());
		if (status) break;
		ok = curl.Body().find("Plus GSM - SMS zosta wysany") > 0;
		
		if (!ok) throw Exception("[1] - brak potwierdzenia");
		
		break;
	}
	
	return ok;
}

