 #include <stdio.h>
 #include <stdlib.h>
 #include <unistd.h>
 #include <limits.h>  // for PATH_MAX
 #include <string.h>

 #define MIN(X,Y) ((X<Y)?X:Y)
 #define MAX(X,Y) ((X>Y)?X:Y)

 class Client
 {
     friend class ClientList;

     public:
         Client(unsigned long theId);
         unsigned long Id() {return id;}
         unsigned long Sent() {return sent;}
         SetSent(unsigned long count) {sent = count;}
         unsigned long Suppressed() {return suppressed;}
         SetSuppressed(unsigned long count) {suppressed = count;}
         Client* Next() {return next;}

     private:
         unsigned long id;
         unsigned long sent;
         unsigned long suppressed;
         Client*       next;
 };



 class ClientList
 {
     public:
         ClientList();
         ~ClientList();
         void AddClient(Client* theClient);
         void Destroy();
         Client* FindClientById(unsigned long theId);
         Client* Top() {return top;}

     private:
         Client* top;
 };


 Client::Client(unsigned long theId)
     : id(theId), sent(0), suppressed(0), next(NULL)
 {
 }

 ClientList::ClientList()
     : top(NULL)
 {
 }

 ClientList::~ClientList()
 {
     Destroy();
 }

 void ClientList::AddClient(Client* theClient)
 {
     theClient->next = top;
     top = theClient;
 }  // end ClientList::AddClient()

 void ClientList::Destroy()
 {
     while (top)
     {
         Client* next = top->next;
         delete top;
         top = next;   
     }
 }  // end ClientList::Destroy()

 Client* ClientList::FindClientById(unsigned long theId)
 {
     Client* next = top;
     while(next)
     {
         if (theId == next->id)
             return next;
         else
             next = next->next;
     }       
     return NULL;
 }  // end ClientList::FindClientById()




 const int MAX_LINE = 256;

 class FastReader
 {
     public:
         FastReader();
         bool Read(FILE* filePtr, char* buffer, unsigned int* len);
         bool Readline(FILE* filePtr, char* buffer, unsigned int* len);

     private:
         char         savebuf[256];
         char*        saveptr;
         unsigned int savecount;
 };  // end class FastReader

 FastReader::FastReader()
     : savecount(0)
 {

 }

 bool FastReader::Read(FILE* filePtr, char* buffer, unsigned int* len)
 {
     unsigned int want = *len;   
     if (savecount)
     {
         unsigned int ncopy = MIN(want, savecount);
         memcpy(buffer, saveptr, ncopy);
         savecount -= ncopy;
         saveptr += ncopy;
         buffer += ncopy;
         want -= ncopy;
     }
     while (want)
     {
         unsigned int result = fread(savebuf, sizeof(char), 256, filePtr);
         if (result)
         {
             unsigned int ncopy= MIN(want, result);
             memcpy(buffer, savebuf, ncopy);
             savecount = result - ncopy;
             saveptr = savebuf + ncopy;
             buffer += ncopy;
             want -= ncopy;
         }
         else  // end-of-file
         {
             *len -= want;
             if (*len)
                 return true;  // we read something
             else
                 return false; // we read nothing
         }
     }
     return true;
 }  // end FastReader::Read()

 // An OK text readline() routine (reads what will fit into buffer incl. NULL termination)
 // if *len is unchanged on return, it means the line is bigger than the buffer and 
 // requires multiple reads

 bool FastReader::Readline(FILE* filePtr, char* buffer, unsigned int* len)
 {   
     unsigned int count = 0;
     unsigned int length = *len;
     char* ptr = buffer;
     unsigned int one = 1;
     while ((count < length) && Read(filePtr, ptr, &one))
     {
         if (('\n' == *ptr) || ('\r' == *ptr))
         {
             *ptr = '\0';
             *len = count;
             return true;
         }
         count++;
         ptr++;
     }
     // Either we've filled the buffer or hit end-of-file
     if (count < length) *len = 0; // Set *len = 0 on EOF
     return false;
 }  // end FastReader::Readline()






 int main(int argc, char* argv[])
 {
     if (2 != argc)
     {
         fprintf(stderr, "Usage: nackCount <mdpLogFile>\n");
         exit(-1);   
     }
     FILE* inFile = fopen(argv[1], "r");
     if (!inFile)
     {
         perror("nackCount: Error opening input file:"); 
         fprintf(stderr, "Usage: nackCount <mdpLogFile>\n");  
         exit(-1);
     }

     ClientList list;
     FastReader reader;
     char buffer[512];
     unsigned long line = 0;
     unsigned int len = 512;
     while (reader.Readline(inFile, buffer, &len))
     {
         line++;
         if (!strncmp(buffer, "MDP_REPORT", 10))
         {
             char* ptr = strstr(buffer, "node:");
             if (!ptr) break;
             unsigned long nodeId;
             if (1 != sscanf(ptr, "node:%lu", &nodeId))
             {
                 fprintf(stderr, "nackCount: Error parsing log file "
                                 "at line: %lu\n", line);
                 exit(-1);  
             }
             Client* client = list.FindClientById(nodeId);
             if (!client)
             {
                 if (!(client = new Client(nodeId)))
                 {
                     perror("nackCount: Error creating Client:");
                     exit(-1);   
                 }
                 list.AddClient(client);
             }
             // Update NACKs transmitted:
             unsigned int temp = 0;
             len = 512;
             while (reader.Readline(inFile, buffer, &len))
             {
                 len = 512;
                 if (temp++ > 20)
                 {
                     fprintf(stderr, "Error parsing log file "
                                     "at line: %lu  \n", line+temp);
                     exit(-1); 
                 }
                 //fprintf(stderr, "Searching: \"%s\"\n", buffer);
                 ptr = strstr(buffer, "NACKs transmitted:");
                 if (ptr)
                 {
                     unsigned long count;
                     if (1 == sscanf(ptr, "NACKs transmitted: %lu", &count))
                     {
                         client->SetSent(count);
                         break;   
                     }
                 }
             }
             len = 512;
             while (reader.Readline(inFile, buffer, &len))
             {
                 len = 512;
                 if (temp++ > 20)
                 {
                     fprintf(stderr, "Error parsing log file "
                                     "at line: %lu  \n", line+temp);
                     exit(-1); 
                 }
                 ptr = strstr(buffer, "NACKs suppressed :");
                 if (ptr)
                 { 
                     unsigned long count;
                     if (1 == sscanf(ptr, "NACKs suppressed : %lu", &count))
                     {
                         client->SetSuppressed(count);
                         break;   
                     }
                 }
             }
         }
         len = 512;
     }

     unsigned long numClient = 0;
     Client* next = list.Top();
     unsigned long totalSent = 0;
     unsigned long totalSuppressed = 0;
     while (next)
     {
         //fprintf(stdout, "Client:%lu sent:%lu suppressed:%lu\n",
         //                 next->Id(), next->Sent(), next->Suppressed()); 
         
         totalSent += next->Sent();
         totalSuppressed += next->Suppressed(); 
         next = next->Next(); 
        numClient++;
     }
     
     fprintf(stdout, "Receivers:%lu Sent:%lu Suppressed:%lu alpha:%f\n", 
                      numClient, totalSent, totalSuppressed, 
                      (double)totalSent / (double) (totalSuppressed+totalSent));

 }  // end main()

