#!/usr/bin/tclsh

source bw2gp.tcl

# Set up multiple run info (TBD - simplify this!)

set numRuns 4
set lagtime 120
set lmdp {1 2 4 8}
set ltcp {0 0 0 0}
set ltfrc {0 0 0 0}
#set lduration {300 300 300 300 300 300}
set duration 900
#set lwindow {1 1 1 1}
set window 1
set lbottleneckRate {64000 64000 64000 64000}
#set lgraphTitle {"graph1" "graph2" "graph3" "graph4"}
#set lgnufile {"gnufile1" "gnufile2" "gnufile3" "gnufile4"}
set lgnufile gnufile
set optionList "fastStart red tcpSack"
set tempFile "temp.bw"
set outputPrefix "queuevsfair"

for {set i 0} {$i < $numRuns} {incr i} {
     catch [exec rm $tempFile]
     set mdp [lindex $lmdp $i]
     set tcp [lindex $ltcp $i]
     set tfrc [lindex $ltfrc $i]
#     set duration [lindex $lduration $i]
#     set window [lindex $lwindow $i]
     set bottleneckRate [lindex $lbottleneckRate $i]
#     set graphTitle [lindex $lgraphTitle $i]
#     set graphTitle $bottleneckRate
#     set gnufile [lindex $lgnufile $i]
#     set gnufile $lgnufile$i    
     foreach queueSize {10 20 40 60 80 100 150 200} {
     	set numMdp [expr $mdp]
     	set numTcp [expr $tcp]
     	set numTfrc [expr $tfrc]
        puts "Starting simulation run ..."
        puts "   ns queue_mcc.tcl $numMdp $numTcp $numTfrc $bottleneckRate $duration $window $outputPrefix $queueSize $optionList"
     	catch {eval exec ns queue_mcc.tcl $numMdp $numTcp $numTfrc $bottleneckRate $duration $window $outputPrefix $queueSize $optionList}

     	set fileName $outputPrefix
     	set numTotal [expr $numMdp + $numTcp + $numTfrc]
     	if {$numTotal} {
     	     if {$numMdp} {
             	append fileName $numMdp "mdp"
    	     }
    	     if {$numTfrc} {
             	append fileName $numTfrc "tfrc"
    	     }
    	     if {$numTcp} {
          	    append fileName $numTcp "tcp"
    	     }
     	} else {
    	     error "Error! ZERO flows (MDP, TCP, or TFRC) were specified."
        }
    
        append fileName "_" $bottleneckRate 
     	set txtFileName $fileName
     	append txtFileName "-mdpLog.txt"
	set bwFileName $fileName
	append bwFileName ".bw"
     	append fileName ".tr"
     
     	# Run "bwplot" on ns trace files appending them to tempFile
        puts "Analyzing trace file ..."
     	puts "   bwplot lag $lagtime len 4 testId $queueSize link 8,9 trace $fileName >> $bwFileName"
     	catch [exec bwplot lag $lagtime len 4 testId $queueSize link 8,9 trace $fileName >> $bwFileName]
     	exec rm $fileName
     	catch [exec rm $txtFileName]
     }
     puts "Creating graph of results ..."
     set gnufile $fileName.gp
     puts "  bw2gp $fileName 0.1 $bwFileName $gnufile"
     bw2gp $fileName 0.1 $bwFileName $gnufile
     exec gnuplot -persist $gnufile &
}
puts "Finished."
