#!/usr/bin/tclsh

# Runs ns simplemdp.tcl for Nack stats vs. group size

set uniSizeList {10 20 50 100 150 200 250 300 350 400 500 600 700 800 900 1000}
set multiSizeList {10 20 50 100 150 200 250 300 350 400 500 600 700 800 900 1000}

set rate 32kb
set duration 92.0

foreach backoff {3 4} {
    #set fileName "sup4-$backoff.gp" // MDP no ad loss, correlated loss
    set fileName "theory.gp"

    exec rm -f $fileName

    set outFile [open $fileName "w"]

    # Gnuplot header
    puts $outFile "set title 'Feedback Suppression Performance'"
    puts $outFile "set data style lines"
    puts $outFile "set xlabel 'Number of Receivers'"
    puts $outFile "set ylabel 'Feedback Suppression Factor'"
    puts $outFile "plot \\"
    puts $outFile "'-' using 1:2 \\"
    puts $outFile "'Receivers:%lf alpha:%lf' t 'Uniform Multicast Feedback', \\"
    puts $outFile "'-' using 1:2 \\"
    puts $outFile "'Receivers:%lf alpha:%lf' t 'Uniform Unicast Feedback', \\"
    puts $outFile "'-' using 1:2 \\"
    puts $outFile "'Receivers:%lf alpha:%lf' t 'Exponential Multicast Feedback', \\"
    puts $outFile "'-' using 1:2 \\"
    puts $outFile "'Receivers:%lf alpha:%lf' t 'Exponential Unicast Feedback'"
    
    puts "Computing theoretical results ..."
    # T = number of GRTT for NACK backoff timers ...
    set T $backoff
    
    # Theoretical Multicast NACK results (UNIFORM)
    puts $outFile "#Theoretical Multicast NACK results (UNIFORM)"
    foreach numClient $uniSizeList {
        set r [expr 1.0 / (2 * $T)]
        catch {set x [expr pow($r, $numClient)]} result
        set success [scan $result %f value]
        if {$success} {
            set finalTerm $result
        } else {
            set finalTerm 0.0
        }
        
        set N [expr 1.0 + ($r * $numClient) - $finalTerm]
        set alpha [expr $N / $numClient]
        puts $outFile "Receivers:$numClient alpha:$alpha" 
    } 
    puts $outFile "e\n"
    
    # Theoretical Multicast NACK results (UNIFORM)
    puts $outFile "#Theoretical Unicast NACK results (UNIFORM)"
    foreach numClient $uniSizeList {
        set r [expr 1.0 / ($T)]
        catch {set x [expr pow($r, $numClient)]} result
        set success [scan $result %f value]
        if {$success} {
            set finalTerm $result
        } else {
            set finalTerm 0.0
        }
        
        set N [expr 1.0 + ($r * $numClient) - $finalTerm]
        set alpha [expr $N / $numClient]
        puts $outFile "Receivers:$numClient alpha:$alpha" 
    } 
    puts $outFile "e\n"
    
    # Theoretical Multicast NACK results (EXP)
    puts $outFile "#Theoretical Multicast NACK Suppression Factor (alpha)"
    foreach numClient $uniSizeList {
        set lambda [expr log($numClient) + 1.0]
        set N [expr exp((1.2/(2.0 * $T)) * ($lambda))]
        set alpha [expr $N / $numClient]
        puts $outFile "Receivers:$numClient alpha:$alpha" 
    }  
    puts $outFile "e\n"
    
    # Theoretical Unicast NACK results (EXP)
    puts $outFile "#Theoretical Unicast NACK Suppression Factor (alpha)"
    foreach numClient $uniSizeList {
        set lambda [expr log($numClient) + 1.0]
        set N [expr exp((1.2/(1.0 * $T)) * ($lambda))]
        set alpha [expr $N / $numClient]
        puts $outFile "Receivers:$numClient alpha:$alpha" 
    } 
    close $outFile
}
puts "Finished."
