/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
/*************************************************************
Multicast Dissemination Protocol version 2 (MDPv2)

This source code is part of the prototype NRL MDPv2 release
and was written and developed by Brian Adamson and Joe Macker.
This is presently experimental code and therefore use it at your 
own risk.  Please include this notice and provide credit to the 
authors and NRL if this program or parts of it are used for any 
purpose.

We would appreciate receiving any contributed enhancements 
or modifications to this code release. Please contact the developers 
with comments/questions regarding this code release.  Feedback on
use of this code can help continue support for further development.

Joe Macker  				        Brian Adamson
Email: <macker@itd.nrl.navy.mil>	<adamson@newlink.net>
Telephone: +1-202-767-2001		    +1-202-404-1194
Naval Research Laboratory		    Newlink Global Engineering Corp.
Information Technology Division 	6506 Loisdale Road Suite 209
4555 Overlook Avenue			    Springfield VA 22150
Washington DC 20375                 <http://www.ngec.com>
**************************************************************/

// winMdp.cpp : Defines the class behaviors for the application.
//
#include "stdafx.h"
#include "winMdp.h"
#include "winMdpDlg.h"
#include <direct.h>

#include <mmsystem.h>  // for multimedia timer

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only CWinMdpApp object
CWinMdpApp theApp;


HDDEDATA CALLBACK CWinMdpApp::DDEClientCallback(
			UINT uiType, UINT uiFmt, HCONV hConv, 
			HSZ sz1, HSZ sz2, HDDEDATA hData,
			DWORD lData1, DWORD lData2)
{
	switch(uiType)
	{
		case XTYP_XACT_COMPLETE:
			if (theApp.transaction_id == lData1)
			{
				DWORD result;
				DdeGetData(hData, (unsigned char *)&result, 
									 sizeof(DWORD), 0);
				// Hack to make IExplore fake working
				if (-2 == result)  // IExplore success
					theApp.window_id = 0xffffffff;
				else if (-3 == result)  // IExplore failure
					theApp.window_id = 0x0;
				else
					theApp.window_id = result;
			}
			else
			{
				TRACE("Unknown DDE transaction ID!");
			}
			break;

		default:
			TRACE("Unknown DDE message type\n");
	}
	return NULL;  // callback does nothing for now
}


void CWinMdpApp::StartTxIntervalTimer(double interval)
{
	if (tx_interval_timer_id) StopTxIntervalTimer();
	tx_interval_timer_id = 
		((CWinMdpDlg *)m_pMainWnd)->SetTimer(TX_INTERVAL_TIMER, (unsigned int)(interval * 1000), NULL);
}  // end CWinMdpApp::StartTxIntervalTimer()

void CWinMdpApp::StopTxIntervalTimer()
{
	if (m_pMainWnd && tx_interval_timer_id)
		((CWinMdpDlg *)m_pMainWnd)->KillTimer(TX_INTERVAL_TIMER);
	tx_interval_timer_id = 0;
}

void CWinMdpApp::OnTxIntervalTimeout()
{
    StopTxIntervalTimer();
	MdpApp::OnTxIntervalTimeout();
}  // end CWinMdpApp::OnTxIntervalTimeout()
    

void CWinMdpApp::PostProcess(const char *path)
{
	if (!hConv)
	{
		HSZ szServerName = ::DdeCreateStringHandle(lIdInst, 
										PostProcessor(),
										CP_WINANSI);
		HSZ szTopicName = ::DdeCreateStringHandle(lIdInst, 
									"WWW_OpenURL",
									CP_WINANSI);
		hConv = ::DdeConnect(lIdInst, szServerName, szTopicName, NULL);
		DdeFreeStringHandle(lIdInst, szTopicName);
		DdeFreeStringHandle(lIdInst, szServerName);
	}

	if (hConv)
	{
		char dde_text[PATH_MAX+128];
		sprintf(dde_text, "\"file://%s\",,0x%08x,0x0,,,NETREPORT",
				path, window_id);
		HSZ  szParams = 
			::DdeCreateStringHandle(lIdInst, dde_text, CP_WINANSI);
		if(DdeClientTransaction(NULL, 0, hConv, szParams, CF_TEXT,
			XTYP_REQUEST, TIMEOUT_ASYNC, &transaction_id))
		{
			DdeFreeStringHandle(lIdInst, szParams);
			return;
		}
		else
		{	
			DdeFreeStringHandle(lIdInst, szParams);
			DdeDisconnect(hConv);
			hConv = NULL;
			sprintf(dde_text, "winMdp PostProcessor DDE Error: %s exited!?",
					PostProcessor());
			MessageBox(m_pMainWnd->m_hWnd, 
					   dde_text,
					   "Error", MB_OK);
		}
	}

	// DDE post processor evidently not running
	// Launch post processor with shell command
	// For now we assume the DDE server name & command name are the 
	// same and that the post processor command executable is in
	// the PATH
	window_id = 0xffffffff;  // so next DDE uses active window

	char args[PATH_MAX+512];
	const char* ptr = ProcessorOpt(0);
	if (ptr)
	{
		strcpy(args, ptr);
		int i = 1;
		while((ptr = ProcessorOpt(i++)))
		{
			strcat(args, " ");
			strcat(args, ptr);
		}
		strcat(args, " ");
		strcat(args, path);
	}
	else
	{
		strcpy(args, path);
	}
	


	// Kill old PostProcessor first
	if (post_processor_handle)
	{
		DMSG(0, "Terminating %p ...\n", post_processor_handle);
		if (!TerminateProcess(post_processor_handle, 0))
			DMSG(0, "mdp: TerminateProcess() error ...\n");
		CloseHandle(post_processor_handle);
	}

	DMSG(0, "Launching %s ...\n", PostProcessor());
	char buffer[PATH_MAX];
	char* cd = _getcwd(buffer, PATH_MAX);
	if (cd) DMSG(0, "Current DIR = %s\n", cd);

	SHELLEXECUTEINFO exeInfo;
	exeInfo.cbSize = sizeof(SHELLEXECUTEINFO);
	exeInfo.fMask = SEE_MASK_NOCLOSEPROCESS;
    exeInfo.hwnd = NULL; 
    exeInfo.lpVerb = NULL; 
    exeInfo.lpFile = PostProcessor(); 
    exeInfo.lpParameters = args; 
    exeInfo.lpDirectory = NULL;
    exeInfo.nShow = SW_SHOW;
	//if (!ShellExecute(NULL, "open", PostProcessor(), args, NULL, SW_SHOW))
	if (!ShellExecuteEx(&exeInfo))
	{
		if ((int)exeInfo.hInstApp <= 32) Alert("LESS THAN 32");
		post_processor_handle = NULL;
		char cmd[128+PATH_MAX];
		sprintf(cmd, "Error launching post processor!\n\"%s %s\"", PostProcessor(), args);
		MessageBox(m_pMainWnd->m_hWnd, cmd, "Error", MB_OK);
	}
	else
	{
		if ((int)exeInfo.hInstApp <= 32) Alert("LESS THAN 32");
		post_processor_handle = exeInfo.hProcess;
		DMSG(0, "   (handle = %p)\n", post_processor_handle);
	}
}  // end CWinMdpApp::PostProcess()

void CALLBACK CWinMdpApp::MdpTimerCallback(UINT uID, UINT uMsg, DWORD dwUser, 
										   DWORD dw1, DWORD dw2)
{
	// We'd like to use PostThreadMessage so that the
	// application/thread can handle timer messages w/out
	// depending on a window, but MFC (version 4.2b) still
	// seems to be broken in this regard.  - Brian Adamson
	// So for now, messages are posted to our main window's
	// message queue
	MdpTimerSetUserData((MdpTimerHandle)dwUser, (void*)NULL);
	if (theApp.m_pMainWnd && !theApp.timer_post_pending) 
		if (PostMessage(theApp.m_pMainWnd->m_hWnd, MDP_TIMER_MSG, 
					    dwUser, NULL))
			theApp.timer_post_pending = true;
		else
			DMSG(0, "CWinMdpApp::MdpTimerCallback() PostMessage() error!\n");

}  // end MdpTimerCallBack() 

/**************
 Uncomment this when Microsoft gets its act together and we
 can use PostThreadMessage() with some degree of confidence

void CWinMdpApp::OnMdpTimer(WPARAM wParam, LPARAM lParam)
{
	// One shot event timer has expired
	session_mgr.timer_mgr.DoTimers();
}
*/

bool CWinMdpApp::MdpTimerInstaller(MdpTimerInstallCmd    cmd, 
                                   double                delay,
                                   MdpTimerHandle        timerHandle, 
                                   MdpInstanceHandle     instanceHandle)
{
	if (MDP_TIMER_MODIFY == cmd)
	{
		MMRESULT timerId = (MMRESULT)MdpTimerGetUserData(timerHandle);
		CWinMdpApp* app = dynamic_cast<CWinMdpApp*>((MdpApp*)MdpInstanceGetUserData(instanceHandle));
		if (timerId)  // can't modify posted no-delay timeout
		{
			timeKillEvent(timerId);
			if (delay > 0.0)
			{
                int msec = (int)(delay*1000.0);
			    msec = MIN(msec, 1);
				timerId = timeSetEvent(msec,        // delay (msec)
							app->timer_resolution,  // resolution
							MdpTimerCallback,	    // callback function
							(DWORD) timerHandle,    // pass timer handle to callback function
							TIME_ONESHOT);
				MdpTimerSetUserData(timerHandle, (void*)timerId);
				if (timerId)
				{
					return true;
				}
				else
				{
					DMSG(0, "winMdp: Error installing timer (tout=%dmsec)!\n", msec);
					return false;
				}
			}
			else
			{
				// For ZERO timeout, directly post message (if not already post pending)
				MdpTimerSetUserData(timerHandle, (void*)NULL);
				if (app->m_pMainWnd && !app->timer_post_pending)
				{
					if (PostMessage(app->m_pMainWnd->m_hWnd, 
							    MDP_TIMER_MSG, (DWORD)timerHandle, NULL))
					{
						app->timer_post_pending = true;
					}
					else
					{
						DMSG(0, "CWinMdpApp::MdpTimerInstaller(MODIFY) PostMessage() failed!\n");
						return false;
					}
				}
				return true;
			}
		}
		return true;
	}
	else if (MDP_TIMER_INSTALL == cmd)
	{
		CWinMdpApp* app = dynamic_cast<CWinMdpApp*>((MdpApp*)MdpInstanceGetUserData(instanceHandle));
		if (app->timer_post_pending) return true;
		if (delay > 0.0)
		{
			int msec = (int)(delay*1000.0);
			msec = MIN(msec,1);
			MMRESULT timerId = timeSetEvent(msec,			       // delay (msec)
										    app->timer_resolution, // resolution
										    MdpTimerCallback,	   // callback function
										    (DWORD)timerHandle,    // user data
										    TIME_ONESHOT);
			MdpTimerSetUserData(timerHandle, (void*)timerId);
			if (timerId)
			{
				return true;
			}
			else
			{
				DMSG(0, "winMdp: Error installing timer (tout=%dmsec)!\n", msec);
				return false;
			}
		}
		else
		{
			// For ZERO timeout, directly post message (if not already post pending)
			MdpTimerSetUserData(timerHandle, (void*)NULL);
			if (app->m_pMainWnd && !app->timer_post_pending)
			{
				if (PostMessage(app->m_pMainWnd->m_hWnd, 
							MDP_TIMER_MSG, (DWORD)timerHandle, NULL))
				{
					app->timer_post_pending = true;
				}
				else
				{
					DMSG(0, "CWinMdpApp::MdpTimerInstaller(INSTALL) PostMessage() failed!\n");
					return false;
				}
			}
			return true;
		}
	}
	else  // MDP_TIMER_REMOVE
	{
		MMRESULT timerId = (MMRESULT)MdpTimerGetUserData(timerHandle);
		if (timerId) 
		{
			timeKillEvent(timerId);
			MdpTimerSetUserData(timerHandle, (void*)NULL);
		}
		return true;
	}
}  // end CWinMdpApp::MdpTimerInstaller()

// This "SocketInstaller" approach works because our 
// simple winMdp application has only one MdpSession (one socket)
// A more sophisticated socket installer (maintaining a list
// of socket handles & associated socketData) would be required
// for an application using multiple sessions (and hence sockets)

bool CWinMdpApp::MdpSocketInstaller(MdpSocketInstallCmd  cmd,
                                    MdpSocketHandle       socketHandle,
                                    MdpInstanceHandle     instanceHandle)
{
	CWinMdpApp* app = dynamic_cast<CWinMdpApp*>((MdpApp*)MdpInstanceGetUserData(instanceHandle));

	SOCKET handle = MdpSocketGetDescriptor(socketHandle);
	if (MDP_SOCKET_INSTALL == cmd)
	{       
		
		WinSocketItem* theItem = app->socket_list.FindSocketByHandle(handle);
		if (!theItem) theItem = app->socket_list.NewSocketItem(handle,
													           WinSocketItem::UDP,
													           (void*)socketHandle);
		if (theItem)
		{
			int result = WSAAsyncSelect(handle, app->m_pMainWnd->m_hWnd,
										MDP_SOCKET_MSG, FD_READ);
			if (result) 
			{
				DMSG(0, "CWinMdpApp::MdpSocketInstaller(): WSAAsyncSelect() error!\n");
				return false;
			}
		}
		else
		{
			DMSG(0, "CWinMdpApp::MdpSocketInstaller(): Error finding/creating WinSocketItem!\n");
			return false;
		}
		
	}
	else  // MDP_SOCKET_REMOVE
	{
		WSAAsyncSelect(handle, 0, 0, 0);		
		app->socket_list.DeleteSocketItem(handle);
	}
    return true;
}  // end CWinMdpApp::MdpSocketInstaller()

/////////////////////////////////////////////////////////////////////////////
// CWinMdpApp

BEGIN_MESSAGE_MAP(CWinMdpApp, CWinApp)
	//{{AFX_MSG_MAP(CWinMdpApp)
	ON_COMMAND(ID_SETTINGS_DEBUG, OnSettingsDebug)
	ON_COMMAND(ID_SETTINGS_PROCESSOR, OnSettingsProcessor)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
	// ON_THREAD_MESSAGE(MDP_TIMER_MSG, OnMdpTimer)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinMdpApp construction

CWinMdpApp::CWinMdpApp()
 : timer_resolution(10), timer_post_pending(false), lIdInst(0), hConv(NULL), window_id(0),
   post_processor_handle(NULL), tx_interval_timer_id(0)
   
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

void CWinMdpApp::Alert(const char *format, ...)
{
	char theText[512];
	va_list args;
    va_start(args, format);
    vsprintf(theText, format, args);
    va_end(args);
	AfxMessageBox(theText);
}  // end CWinMdpApp::Alert()


void CWinMdpApp::SetProgressMeter(unsigned int percent)
{
	((CWinMdpDlg *)m_pMainWnd)->progress_meter.SetPos(percent);
}  // end CWinMdpApp::SetProgressMeter()

void CWinMdpApp::SetStatusText(const char* text)
{
	((CWinMdpDlg *)m_pMainWnd)->SetDlgItemText(IDC_STATUS_TEXT, text);
}



/////////////////////////////////////////////////////////////////////////////
// CWinMdpApp initialization

BOOL CWinMdpApp::InitInstance()
{

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Set multimedia timer resolution for 10 msec
	TIMECAPS tc;
	if (timeGetDevCaps(&tc, sizeof(TIMECAPS)) != TIMERR_NOERROR) 
	{
		TRACE("timeGetDevCaps error!\n");
	}
	timer_resolution = min(max(tc.wPeriodMin, 10), tc.wPeriodMax);
	timeBeginPeriod(timer_resolution);

	// We use the default web browser as our 
	// default post-processor
	// Peek at registry for default web browser dde name
	long bufsize = PATH_MAX;
    char postProcessor[PATH_MAX];
	strcpy(postProcessor, "IExplore");
	if(ERROR_SUCCESS != RegQueryValue(HKEY_CLASSES_ROOT,
		"http\\shell\\open\\ddeexec\\Application", 
		postProcessor, &bufsize))
	{
		TRACE("RegQueryValue() error!\n");
	}

	if(!strcmp(postProcessor, "NSShell"))
	{
		// This seems to work and launches the right executable
		// And Netscape still seems to recognize this DDE name
		strcpy(postProcessor, "Netscape");
	}
	SetPostProcessor(postProcessor);

    // Init MdpApp() 
    // Note: Since the MDPv2 protocol engine uses MFC CAsync sockets,  
    // no socket handling external to the MDP protocol engine is needed
    if (!MdpApp::Init(CWinMdpApp::MdpTimerInstaller, 
		              CWinMdpApp::MdpSocketInstaller))
	{
		AfxMessageBox("Error initializing MDPv2!");
		return false;
	}
	
	// Parse command line for standard shell commands, DDE, file open
	CWinMdpCmdLineInfo cmdInfo(this);
	// Overwrite defaults with command line options
	ParseCommandLine(cmdInfo);
    
    if (cmdInfo.ErrorDetected())
        return false;

	// Create user interface
	// (TBD) Add code to check for dialog creation failure
	CWinMdpDlg *dlg = new CWinMdpDlg;
	dlg->Create(IDD_WINMDP_DIALOG,NULL);
	dlg->ShowWindow(SW_SHOWNORMAL);
	dlg->SetWindowText(SessionName());
    m_pMainWnd = dlg;

	// Init DDE
	if (::DdeInitialize(&lIdInst, (PFNCALLBACK) DDEClientCallback,
		APPCLASS_STANDARD | APPCMD_CLIENTONLY, 0ul))
	{
		AfxMessageBox("DDEML initialization failure");
        return false;
	}
	
    // Start mdpApp server/client participation
    if (!MdpApp::Start()) 
    {
		AfxMessageBox("Error starting MDPv2");
        return false;
    }
   
	return true;
}  // end CWinMdpApp::InitInstance()


CWinMdpCmdLineInfo::CWinMdpCmdLineInfo(CWinMdpApp* theApp)
	: app(theApp), current_flag(0), error_detected(false)
{
}

void CWinMdpCmdLineInfo::ParseParam(LPCTSTR theArg, BOOL bFlag, BOOL bLast)
{
	if (bFlag)
	{
		switch (current_flag)
		{
			case 'R':  
                // num_repeats can equal "-1" which looks flagged so fix it
                theArg = "-1";
				bFlag = false;
				break;

			case 0:
				break;

			default:  // This shouldn't happen except for above flags
				error_detected = true;
				break;
		}		
	}
    
    if (bFlag)
    {
        // Is it one of our flags?
        char theFlag[32];
        strncpy(theFlag, theArg, 32);
        char* ptr = strstr(MDPAPP_CMD_LINE_FLAGS, theFlag);
        if (ptr)
        {
            int flagLen = MIN(32, strlen(theFlag));

            if (':' == ptr[flagLen])
            {
                // This flag wants an argument
                current_flag = theFlag[0];
            }
            else
            {
                // This is a stand-alone flag
                current_flag = theFlag[0];
                if(!app->ProcessCommand(current_flag, NULL))
                    error_detected = true;
                current_flag = 0;
            }    
        }
        else
        {
            char theText[128];
            sprintf(theText, "Unknown command line flag: -%.32s", theFlag);
            AfxMessageBox(theText);
            error_detected = true;
        }
    }
    else
    {
        // This must be the argument for the previous flag
        if (!app->ProcessCommand(current_flag, theArg)) 
            error_detected = true;
        current_flag = 0;   
    }
}  // end WinMdpCmdLineInfo::ParseCommandLine()

int CWinMdpApp::ExitInstance() 
{	
	MdpApp::OnExit();
	if (post_processor_handle) 
	{
		CloseHandle(post_processor_handle);
		post_processor_handle = NULL;
	}
	timeEndPeriod(timer_resolution);
	if (hConv) DdeDisconnect(hConv);
	::DdeUninitialize(lIdInst);
	return CWinApp::ExitInstance();
}  // end CWinMdpApp::ExitInstance() 


void CWinMdpApp::OnSettingsDebug() 
{
#ifdef PROTO_DEBUG
	// Bring up the Debug level dialog
	CDebugDlg theDlg;
	char tempText[256];
	sprintf(tempText, "%d", DebugLevel());
	theDlg.debug_text = _T(tempText);
	if (IDOK == theDlg.DoModal())
	{
		int dbg = atoi((LPCTSTR) theDlg.debug_text);
		if (dbg < 0)
			dbg = 0;
		else if (dbg > 12)
			dbg = 12;
		SetDebugLevel(dbg);
		if (dbg >= 8)
			MdpSetMessageTrace(true);
		else if (0 == dbg)
			MdpSetMessageTrace(false);
	}
	else
	{
        // Cancel hit, do nothing
	}
#endif // PROTO_DEBUG
}

void CWinMdpApp::OnSettingsProcessor() 
{
	CPostProcessDlg theDlg;

	char text[512];
	strcpy(text, PostProcessor());
	int i = 0;
	const char* ptr;
	while ((ptr = ProcessorOpt(i++)))
	{
		strcat(text, " ");
		strcat(text, ptr);
	}
	theDlg.post_processor = _T(text);

	if(IDOK == theDlg.DoModal())
	{
		if (strcmp(text, (LPCTSTR) theDlg.post_processor))
		{
			if (hConv) DdeDisconnect(hConv);
			hConv = NULL;
			window_id = 0;
			SetPostProcessor(theDlg.post_processor);
		}
	}
	else  // IDCANCEL
	{
		// Make no change to post processing
	}
	
}  // end OnSettingsProcessor()


/////////////////////////////////////////
//  WinSocketItem stuff

WinSocketItem::WinSocketItem(SOCKET theHandle, SocketType theType, void* userData)
	: handle(theHandle), type(theType), user_data(userData), next(NULL)
{
}

WinSocketList::WinSocketList()
	: top(NULL)
{
}

WinSocketList::~WinSocketList()
{
	Destroy();
}

void WinSocketList::Destroy()
{
	WinSocketItem* next;
	while ((next = top))
	{
		top = next->next;
		delete next;
	}
}  // end WinSocketList::Destroy();

WinSocketItem* WinSocketList::FindSocketByHandle(SOCKET theHandle)
{
	WinSocketItem* next = top;
	while (next)
	{
		if (theHandle == next->handle) 
			return next;
		else
			next = next->next;
	}
	return NULL;
}  // end WinSocketList::FindSocketByHandle()

WinSocketItem* WinSocketList::NewSocketItem(SOCKET						theHandle, 
											WinSocketItem::SocketType	theType, 
											void*						userData)
{
	WinSocketItem* theItem = new WinSocketItem(theHandle, theType, userData);
	if (theItem)
	{
		theItem->next = top;
		top = theItem;
		return theItem;
	}
	else
	{
		return NULL;
	}

}  // end WinSocketList::NewSocketItem()

void WinSocketList::DeleteSocketItem(SOCKET theHandle)
{
	WinSocketItem* prev = NULL;
	WinSocketItem* next = top;
	while (next)
	{
		if (theHandle == next->handle)
		{
			if (prev)
				prev->next = next->next;
			else
				top = next->next;
			delete next;
			return;
		}
		else
		{
			prev = next;
			next = next->next;
		}
	}
}  // end WinSocketList::DeleteSocketItem()
