/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
// winMdpDlg.cpp : implementation file
//

#include "stdafx.h"
#include "winMdp.h"
#include "winMdpDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	version_text;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	char theText[64];
	sprintf(theText, "winMdp Version %s", MdpVersion());
	version_text = _T(theText);
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_VERSION_TEXT, version_text);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinMdpDlg dialog

CWinMdpDlg::CWinMdpDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWinMdpDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWinMdpDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWinMdpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWinMdpDlg)
	DDX_Control(pDX, IDC_STATUS_TEXT, status_text);
	DDX_Control(pDX, IDC_PROGRESS, progress_meter);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWinMdpDlg, CDialog)
	//{{AFX_MSG_MAP(CWinMdpDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_MESSAGE(MDP_TIMER_MSG, OnMdpTimer)
	ON_MESSAGE(MDP_SOCKET_MSG, OnSocketEvent)
	ON_WM_CLOSE()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinMdpDlg message handlers

LONG CWinMdpDlg::OnMdpTimer(WPARAM wParam, LPARAM lParam)
{
	// One shot event timer has expired
	theApp.ClearTimerPost();
	MdpTimerOnTimeout((MdpTimerHandle)wParam);
	return 0;
}

LRESULT CWinMdpDlg::OnSocketEvent(WPARAM wParam, LPARAM lParam)
{
	WinSocketItem* theItem = theApp.FindSocketByHandle((SOCKET)wParam);
	if (theItem)
	{
		long theEvent = WSAGETSELECTEVENT(lParam);
		switch (theEvent)
		{
			case FD_READ:
				// Message ready to be read (make sure socket is still
				// valid and this isn't a late Win32 message!
				//TRACE("SOCKET FD_READ event ...\n");
				MdpSocketOnDataReady((MdpSocketHandle)theItem->UserData());
				break;

			default:
				TRACE("CWinMdpDlg::OnSocketEvent(): Unknown socket event!\n");
				break;
		}
	}
	else
	{
		//TRACE("CWinMdpDlg::OnSocketEvent(): Unknown socket handle!\n");
	}
	return true;
}  // end CWinMdpDlg::OnSocketEvent()


BOOL CWinMdpDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWinMdpDlg::OnOK()
{
	// Do nothing
}

void CWinMdpDlg::OnClose() 
{
	CDialog::OnClose();
	DestroyWindow();
}

void CWinMdpDlg::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this;
}

void CWinMdpDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}


void CWinMdpDlg::OnHelpAbout() 
{
	// Bring up the about dialog
	CAboutDlg theDlg;
	if (IDOK == theDlg.DoModal())
	{
	
	}
	else
	{

	}
}



// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWinMdpDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWinMdpDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



/////////////////////////////////////////////////////////////////////////////
// CDebugDlg dialog


CDebugDlg::CDebugDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDebugDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDebugDlg)
	debug_text = _T("");
	//}}AFX_DATA_INIT
}


void CDebugDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDebugDlg)
	DDX_Control(pDX, IDC_DEBUG_SPIN, debug_spin);
	DDX_Text(pDX, IDC_DEBUG_TEXT, debug_text);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDebugDlg, CDialog)
	//{{AFX_MSG_MAP(CDebugDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDebugDlg message handlers


BOOL CDebugDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	debug_spin.SetRange(0, 12);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
/////////////////////////////////////////////////////////////////////////////
// CPostProcessDlg dialog


CPostProcessDlg::CPostProcessDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPostProcessDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPostProcessDlg)
	post_processor = _T("");
	//}}AFX_DATA_INIT
}


void CPostProcessDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPostProcessDlg)
	DDX_Text(pDX, IDC_PROCESSOR_STRING, post_processor);
	DDV_MaxChars(pDX, post_processor, 256);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPostProcessDlg, CDialog)
	//{{AFX_MSG_MAP(CPostProcessDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPostProcessDlg message handlers

void CWinMdpDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	theApp.OnTxIntervalTimeout();
	CDialog::OnTimer(nIDEvent);
}
