source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## b::b 1
## b::f 1 x y {1 2} 3
## a::g 1 x y {1 2} 3

## A::A 2
## B::B 2
## B::f 2 x y {1 2} 3
## A::g 2 x y {1 2} 3
 
## d::d 3
## e::e 3
## e::f 3 x y {1 2} 3
## d::g 3 x y {1 2} 3

## D::D 4
## B::B 4
## B::f 4 x y {1 2} 3
## D::g 4 x y {1 2} 3
## D::D 5
## B::B 5
## B::f 5 x y {1 2} 3
## D::g 5 x y {1 2} 3

class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
virtual proc a::f {this p args} {}
proc a::g {this p args} {
    puts "a::g $this $p $args"
}
class b {}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
virtual proc b::f {this p args} {
    puts "b::f $this $p $args"
}
set o [new b]
a::f $o {x y} {1 2} 3
a::g $o {x y} {1 2} 3

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
    virtual proc f {this p args} {}
    proc g {this p args} {
        puts "A::g $this $p $args"
    }
}
class B {
    proc B {this} A {} {
        puts "B::B $this"
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
    virtual proc f {this p args} {
        puts "B::f $this $p $args"
    }
}
set o [new B]
A::f $o {x y} {1 2} 3
A::g $o {x y} {1 2} 3

class c {}
class c::d {}
proc c::d::d {this} {
    puts "d::d $this"
}
proc c::d::~d {this} {
    puts "d::~d $this"
}
virtual proc c::d::f {this p args} {}
proc c::d::g {this p args} {
    puts "d::g $this $p $args"
}
class c::e {}
proc c::e::e {this} c::d {} {
    puts "e::e $this"
}
proc c::e::~e {this} {
    puts "e::~e $this"
}
virtual proc c::e::f {this p args} {
    puts "e::f $this $p $args"
}
set o [new c::e]
c::d::f $o {x y} {1 2} 3
c::d::g $o {x y} {1 2} 3

class C {
    class D {
        proc D {this} {
            puts "D::D $this"
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
        virtual proc f {this p args} {}
        proc g {this p args} {
            puts "D::g $this $p $args"
        }
    }
    class B {
        proc B {this} C::D {} {
            puts "B::B $this"
        }
        proc ~B {this} {
            puts "B::~B $this"
        }
        virtual proc f {this p args} {
            puts "B::f $this $p $args"
        }
    }
    set o [new B]
    D::f $o {x y} {1 2} 3
    D::g $o {x y} {1 2} 3
}
set o [new C::B]
C::D::f $o {x y} {1 2} 3
C::D::g $o {x y} {1 2} 3
