source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1 x y z
## b::b 1 x y z

## A::A 2 x y z
## B::B 2 x y z

## d::d 3 x y z
## e::e 3 x y z

## D::D 4 x y z
## E::E 4 x y z
## D::D 5 x y z
## E::E 5 x y z

class a {}
proc a::a {this p q} {
    puts "a::a $this $p $q"
}
proc a::~a {this} {}
class b {}
proc b::b {this p q} a {
    $p $q
} {
    puts "b::b $this $p $q"
}
proc b::~b {this} {}
new b {x y} z

class A {
    proc A {this p q} {
        puts "A::A $this $p $q"
    }
    proc ~A {this} {}
}
class B {
    proc B {this p q} A {
        $p $q
    } {
        puts "B::B $this $p $q"
    }
    proc ~B {this} {}
}
new B {x y} z

class c {}
class c::d {}
proc c::d::d {this p q} {
    puts "d::d $this $p $q"
}
proc c::d::~d {this} {}
class c::e {}
proc c::e::e {this p q} c::d {
    $p $q
} {
    puts "e::e $this $p $q"
}
proc c::e::~e {this} {}
new c::e {x y} z

class C {
    class D {
        proc D {this p q} {
            puts "D::D $this $p $q"
        }
        proc ~D {this} {}
    }
    class E {
        proc E {this p q} C::D {
            $p $q
        } {
            puts "E::E $this $p $q"
        }
        proc ~E {this} {}
    }
    new E {x y} z
}
new C::E {x y} z
