source stooop.tcl
namespace import stooop::*

### check that class constructor with multiple base classes has correct number of base class / argument pairs

# expected output:
## bad class ::c constructor declaration, a base class, contructor arguments or body may be missing
## bad class ::C constructor declaration, a base class, contructor arguments or body may be missing
## bad class ::d::g constructor declaration, a base class, contructor arguments or body may be missing
## bad class ::C::G constructor declaration, a base class, contructor arguments or body may be missing

catch {
    class c {}
    proc c::c {this} a {} b {}
} message
puts $message

catch {
    class C {
        proc C {this} A {} B {}
    }
} message
puts $message

catch {
    class d {}
    class d::g {}
    proc d::g::g {this} d::e {} d::f {}
} message
puts $message

catch {
    class C {
        class G {
            proc G {this} C::E {} C::F {}
        }
    }
} message
puts $message
