source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## b::b 1
## a::(1,_derived) = ::b
## a::(1,m) = x y
## b::(1,n) = z
## b::~b 1
## a::~a 1

## A::A 2
## B::B 2
## A::(2,_derived) = ::B
## A::(2,m) = x y
## B::(2,n) = z
## B::~B 2
## A::~A 2

## d::d 3
## e::e 3
## c::d::(3,_derived) = ::c::e
## c::d::(3,m) = x y
## c::e::(3,n) = z
## e::~e 3
## d::~d 3

## D::D 4
## E::E 4
## C::D::(4,_derived) = ::C::E
## C::D::(4,m) = x y
## C::E::(4,n) = z
## E::~E 4
## D::~D 4

class a {}
proc a::a {this p} {
    puts "a::a $this"
    set ($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p q} a {$p} {
    puts "b::b $this"
    set ($this,n) $q
}
proc b::~b {this} {
    puts "b::~b $this"
}
set o [new b {x y} z]
printArrays a:: b::
delete $o
printArrays a:: b::

class A {
    proc A {this p} {
        puts "A::A $this"
        set ($this,m) $p
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p q} A {$p} {
        puts "B::B $this"
        set ($this,n) $q
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
set o [new B {x y} z]
printArrays A:: B::
delete $o
printArrays A:: B::

class c::d {}
proc c::d::d {this p} {
    puts "d::d $this"
    set ($this,m) $p
}
proc c::d::~d {this} {
    puts "d::~d $this"
}
class c::e {}
proc c::e::e {this p q} c::d {$p} {
    puts "e::e $this"
    set ($this,n) $q
}
proc c::e::~e {this} {
    puts "e::~e $this"
}
set o [new c::e {x y} z]
printArrays c::d:: c::e::
delete $o
printArrays c::d:: c::e::

class C {
    class D {
        proc D {this p} {
            puts "D::D $this"
            set ($this,m) $p
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
    }
    class E {
        proc E {this p q} C::D {$p} {
            puts "E::E $this"
            set ($this,n) $q
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
    }
}
set o [new C::E {x y} z]
printArrays C::D:: C::E::
delete $o
printArrays C::D:: C::E::
