source stooop.tcl
namespace import stooop::*

### check that nested class procedure definition works inside a separate namespace and is free from interferences

# expected output:

## 1
## 1
## 3
## 4
## 4
## 6
## 7
## 7
## 9

class a {
    proc a {this} {}
    proc p {this} {
        puts 1
    }
}
set o [new a]
a::p $o

namespace eval b {
    namespace eval a {}
    proc a::p {this} {
        puts 2
    }
}
a::p $o

namespace eval c {
    proc ::a::p {this} {
        puts 3
    }
}
a::p $o

namespace eval d {
    class a {
        proc a {this} {}
        proc p {this} {
            puts 4
        }
    }
    set o [new a]
    a::p $o

    namespace eval b {
        namespace eval a {}
        proc a::p {this} {
            puts 5
        }
    }
    a::p $o

    namespace eval c {
        proc ::d::a::p {this} {
            puts 6
        }
    }
    a::p $o
}

class e {
    proc e {this} {}
    class a {
        proc a {this} {}
        proc p {this} {
            puts 7
        }
    }
    set o [new a]
    a::p $o

    namespace eval b {
        namespace eval a {}
        proc a::p {this} {
            puts 8
        }
    }
    a::p $o

    namespace eval c {
        proc ::e::a::p {this} {
            puts 9
        }
    }
    a::p $o
}
