source stooop.tcl
namespace import stooop::*

### check inheritance within a deep nested class hierarchy

# expected output:

## class ::a::b::c constructor defined before base class b constructor
## a::a
## b::b
## c::c
## invalid command name "e::e"
## d::d
## e::e
## f::f

class a {
    proc a {this} {
        puts a::a
    }
    class b {
        proc b {this} a {} {
            puts b::b
        }
        class c {
            catch {
                proc c {this} b {} {}
            } message
            puts $message
            proc c {this} a::b {} {
                puts c::c
            }
        }
        new c
    }
}

namespace eval d {
    proc d {this} {
        puts d::d
    }
    namespace eval e {
        proc e {this} {
            d::d $this
            puts e::e
        }
        namespace eval f {
            proc f {this} {
                catch {
                    e::e $this
                } message
                puts $message
                d::e::e $this
                puts f::f
            }
        }
        f::f 0
    }
}
