source stooop.tcl
namespace import stooop::*

### test classof operator on base, derived and multiply derived classes

# expected output:

## ::a
## ::b
## ::c

## ::A
## ::B
## ::C

## ::d::e
## ::d::f
## ::d::g

## ::D::E
## ::D::F
## ::D::G
## ::D::E
## ::D::F
## ::D::G

class a {}
proc a::a {this} {}
class b {}
proc b::b {this} a {} {}
class c {}
proc c::c {this} b {} a {} {}
puts [classof [new a]]
puts [classof [new b]]
puts [classof [new c]]

class A {
    proc A {this} {}
}
class B {
    proc B {this} A {} {}
}
class C {
    proc C {this} B {} A {} {}
}
puts [classof [new A]]
puts [classof [new B]]
puts [classof [new C]]

class d::e {}
proc d::e::e {this} {}
class d::f {}
proc d::f::f {this} d::e {} {}
class d::g {}
proc d::g::g {this} d::f {} d::e {} {}
puts [classof [new d::e]]
puts [classof [new d::f]]
puts [classof [new d::g]]

class D {
    class E {
        proc E {this} {}
    }
    class F {
        proc F {this} D::E {} {}
    }
    class G {
        proc G {this} D::F {} D::E {} {}
    }
puts [classof [new E]]
puts [classof [new F]]
puts [classof [new G]]
}
puts [classof [new D::E]]
puts [classof [new D::F]]
puts [classof [new D::G]]
