source stooop.tcl
namespace import stooop::*

### check various virtual procedures configurations in a 3 level deep class hierarchy

# expected output:

## c::f 1 x y z
## c::g 1 x y z
## b::h 1 x y z
## b::i 1 x y z
## c::k 1 x y z
## c::l 1 x y z

## C::f 2 x y z
## C::g 2 x y z
## B::h 2 x y z
## B::i 2 x y z
## C::k 2 x y z
## C::l 2 x y z
## C::f 3 x y z
## C::g 3 x y z
## B::h 3 x y z
## B::i 3 x y z
## C::k 3 x y z
## C::l 3 x y z

class z {}
class z::a {}
proc z::a::a {this} {}
proc z::a::~a {this} {}
virtual proc z::a::f {this p q} {}
virtual proc z::a::g {this p q}
virtual proc z::a::h {this p q} {
    puts "a::h $this $p $q"
}
virtual proc z::a::i {this p q} {
    puts "a::i $this $p $q"
}
virtual proc z::a::k {this p q}
virtual proc z::a::l {this p q} {
    puts "a::l $this $p $q"
}
class z::b {}
proc z::b::b {this} z::a {} {}
proc z::b::~b {this} {}
virtual proc z::b::f {this p q} {
    puts "b::f $this $p $q"
}
virtual proc z::b::g {this p q}
virtual proc z::b::h {this p q} {
    puts "b::h $this $p $q"
}
proc z::b::i {this p q} {
    puts "b::i $this $p $q"
}
virtual proc z::b::k {this p q} {
    puts "b::k $this $p $q"
}
virtual proc z::b::l {this p q}
class z::c {}
proc z::c::c {this} z::b {} {}
proc z::c::~c {this} {}
proc z::c::f {this p q} {
    puts "c::f $this $p $q"
}
proc z::c::g {this p q} {
    puts "c::g $this $p $q"
}
proc z::c::i {this p q} {
    puts "c::i $this $p $q"
}
proc z::c::k {this p q} {
    puts "c::k $this $p $q"
}
proc z::c::l {this p q} {
    puts "c::l $this $p $q"
}
set o [new z::c]
z::a::f $o x {y z}
z::a::g $o x {y z}
z::a::h $o x {y z}
z::a::i $o x {y z}
z::a::k $o x {y z}
z::a::l $o x {y z}

class Z {
    class A {
        proc A {this} {}
        proc ~A {this} {}
        virtual proc f {this p q} {}
        virtual proc g {this p q}
        virtual proc h {this p q} {
            puts "A::h $this $p $q"
        }
        virtual proc i {this p q} {
            puts "A::i $this $p $q"
        }
        virtual proc k {this p q}
        virtual proc l {this p q} {
            puts "A::l $this $p $q"
        }
    }
    class B {
        proc B {this} Z::A {} {}
        proc ~B {this} {}
        virtual proc f {this p q} {
            puts "B::f $this $p $q"
        }
        virtual proc g {this p q}
        virtual proc h {this p q} {
            puts "B::h $this $p $q"
        }
        proc i {this p q} {
            puts "B::i $this $p $q"
        }
        virtual proc k {this p q} {
            puts "B::k $this $p $q"
        }
        virtual proc l {this p q}
    }
    class C {
        proc C {this} Z::B {} {}
        proc ~C {this} {}
        proc f {this p q} {
            puts "C::f $this $p $q"
        }
        proc g {this p q} {
            puts "C::g $this $p $q"
        }
        proc i {this p q} {
            puts "C::i $this $p $q"
        }
        proc k {this p q} {
            puts "C::k $this $p $q"
        }
        proc l {this p q} {
            puts "C::l $this $p $q"
        }
    }
    set o [new C]
    A::f $o x {y z}
    A::g $o x {y z}
    A::h $o x {y z}
    A::i $o x {y z}
    A::k $o x {y z}
    A::l $o x {y z}
}
set o [new Z::C]
Z::A::f $o x {y z}
Z::A::g $o x {y z}
Z::A::h $o x {y z}
Z::A::i $o x {y z}
Z::A::k $o x {y z}
Z::A::l $o x {y z}
