source stooop.tcl
namespace import stooop::*

### check that child nested class is visible within parent namespace

# expected output:

## a::a 1
## b::b 2
## a::a 3
## b::b 4

class a {}
proc a::a {this} {
    puts "a::a $this"
    new b
}
class a::b {}
proc a::b::b {this} {
    puts "b::b $this"
}
new a

class a {
    proc a {this} {
        puts "a::a $this"
        new b
    }
    class b {
        proc b {this} {
            puts "b::b $this"
        }
    }
    new a
}
