source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## a::~a 1
## a::a 2
## b::b 2
## b::~b 2
## a::~a 2
## a::a 3
## b::b 3
## c::c 3
## c::~c 3
## b::~b 3
## a::~a 3

## A::A 4
## A::~A 4
## A::A 5
## B::B 5
## B::~B 5
## A::~A 5
## A::A 6
## B::B 6
## C::C 6
## C::~C 6
## B::~B 6
## A::~A 6

## e::e 7
## e::~e 7
## e::e 8
## f::f 8
## f::~f 8
## e::~e 8
## e::e 9
## f::f 9
## g::g 9
## g::~g 9
## f::~f 9
## e::~e 9

## E::E 10
## E::~E 10
## E::E 11
## F::F 11
## F::~F 11
## E::~E 11
## E::E 12
## F::F 12
## G::G 12
## G::~G 12
## F::~F 12
## E::~E 12

## E::E 13
## E::~E 13
## E::E 14
## F::F 14
## F::~F 14
## E::~E 14
## E::E 15
## F::F 15
## G::G 15
## G::~G 15
## F::~F 15
## E::~E 15

class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
class c {}
proc c::c {this} b {} {
    puts "c::c $this"
}
proc c::~c {this} {
    puts "c::~c $this"
}
delete [new a]
delete [new b]
delete [new c]

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this} A {} {
        puts "B::B $this"
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
class C {
    proc C {this} B {} {
        puts "C::C $this"
    }
    proc ~C {this} {
        puts "C::~C $this"
    }
}
delete [new A]
delete [new B]
delete [new C]

class d::e {}
proc d::e::e {this} {
    puts "e::e $this"
}
proc d::e::~e {this} {
    puts "e::~e $this"
}
class d::f {}
proc d::f::f {this} d::e {} {
    puts "f::f $this"
}
proc d::f::~f {this} {
    puts "f::~f $this"
}
class d::g {}
proc d::g::g {this} d::f {} {
    puts "g::g $this"
}
proc d::g::~g {this} {
    puts "g::~g $this"
}
delete [new d::e]
delete [new d::f]
delete [new d::g]

class D {
    class E {
        proc E {this} {
            puts "E::E $this"
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
    }
    class F {
        proc F {this} D::E {} {
            puts "F::F $this"
        }
        proc ~F {this} {
            puts "F::~F $this"
        }
    }
    class G {
        proc G {this} D::F {} {
            puts "G::G $this"
        }
        proc ~G {this} {
            puts "G::~G $this"
        }
    }
    delete [new E]
    delete [new F]
    delete [new G]
}
delete [new D::E]
delete [new D::F]
delete [new D::G]
