foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKDATA) 1
source stooop.tcl
namespace import stooop::*

### verify both data and procedure static access in member data checking mode

## can't set "b::(o)": class access violation in procedure ::a::p
## can't set "b::(1,p)": class access violation in procedure ::a::q
## can't set "a::(m)": class access violation in procedure ::b::r
## can't set "a::(1,n)": class access violation in procedure ::b::s

## can't set "B::(o)": class access violation in procedure ::A::p
## can't set "B::(2,p)": class access violation in procedure ::A::q
## can't set "A::(m)": class access violation in procedure ::B::r
## can't set "A::(2,n)": class access violation in procedure ::B::s

## can't set "c::e::(o)": class access violation in procedure ::c::d::p
## can't set "c::e::(3,p)": class access violation in procedure ::c::d::q
## can't set "c::d::(m)": class access violation in procedure ::c::e::r
## can't set "c::d::(3,n)": class access violation in procedure ::c::e::s

## can't set "C::E::(o)": class access violation in procedure ::C::D::p
## can't set "C::E::(4,p)": class access violation in procedure ::C::D::q
## can't set "C::D::(m)": class access violation in procedure ::C::E::r
## can't set "C::D::(4,n)": class access violation in procedure ::C::E::s
## can't set "C::E::(o)": class access violation in procedure ::C::D::p
## can't set "C::E::(4,p)": class access violation in procedure ::C::D::q
## can't set "C::D::(m)": class access violation in procedure ::C::E::r
## can't set "C::D::(4,n)": class access violation in procedure ::C::E::s

class a {
    set (m) 0
}
proc a::a {this} {
    set ($this,n) 0
}
proc a::~a {this} {}
proc a::p {this} {
    incr (m)
    incr b::(o)
}
proc a::q {object} {
    incr ($object,n)
    incr b::($object,p)
}
class b {
    set (o) 0
}
proc b::b {this} a {} {
    set ($this,p) 0
}
proc b::~b {this} {}
proc b::r {this} {
    incr (o)
    incr a::(m)
}
proc b::s {object} {
    incr ($object,p)
    incr a::($object,n)
}
set o [new b]
catch {a::p $o} message; puts $message
catch {a::q $o} message; puts $message
catch {b::r $o} message; puts $message
catch {b::s $o} message; puts $message
delete $o

class A {
    set (m) 0
    proc A {this} {
        set ($this,n) 0
    }
    proc ~A {this} {}
    proc p {this} {
        incr (m)
        incr B::(o)
    }
    proc q {object} {
        incr ($object,n)
        incr B::($object,p)
    }
}
class B {
    set (o) 0
    proc B {this} A {} {
        set ($this,p) 0
    }
    proc ~B {this} {}
    proc r {this} {
        incr (o)
        incr A::(m)
    }
    proc s {object} {
        incr ($object,p)
        incr A::($object,n)
    }
}
set o [new B]
catch {A::p $o} message; puts $message
catch {A::q $o} message; puts $message
catch {B::r $o} message; puts $message
catch {B::s $o} message; puts $message
delete $o

class c {}
class c::d {
    set (m) 0
}
proc c::d::d {this} {
    set ($this,n) 0
}
proc c::d::~d {this} {}
proc c::d::p {this} {
    incr (m)
    incr c::e::(o)
}
proc c::d::q {object} {
    incr ($object,n)
    incr c::e::($object,p)
}
class c::e {
    set (o) 0
}
proc c::e::e {this} c::d {} {
    set ($this,p) 0
}
proc c::e::~e {this} {}
proc c::e::r {this} {
    incr (o)
    incr c::d::(m)
}
proc c::e::s {object} {
    incr ($object,p)
    incr c::d::($object,n)
}
set o [new c::e]
catch {c::d::p $o} message; puts $message
catch {c::d::q $o} message; puts $message
catch {c::e::r $o} message; puts $message
catch {c::e::s $o} message; puts $message
delete $o

class C {
    class D {
        set (m) 0
        proc D {this} {
            set ($this,n) 0
        }
        proc ~D {this} {}
        proc p {this} {
            incr (m)
            incr C::E::(o)
        }
        proc q {object} {
            incr ($object,n)
            incr C::E::($object,p)
        }
    }
    class E {
        set (o) 0
        proc E {this} C::D {} {
            set ($this,p) 0
        }
        proc ~E {this} {}
        proc r {this} {
            incr (o)
            incr C::D::(m)
        }
        proc s {object} {
            incr ($object,p)
            incr C::D::($object,n)
        }
    }
    set ::o [new E]
    catch {D::p $o} message; puts $message
    catch {D::q $o} message; puts $message
    catch {E::r $o} message; puts $message
    catch {E::s $o} message; puts $message
}
catch {C::D::p $o} message; puts $message
catch {C::D::q $o} message; puts $message
catch {C::E::r $o} message; puts $message
catch {C::E::s $o} message; puts $message
delete $o
