'\" t
.TH PR3287 1 "23 July 2012"
.SH "NAME"
pr3287 \-
\s-1IBM\s+1
host printing tool
.SH "SYNOPSIS"
\fBpr3287\fP
[ \fIoptions\fP ]       
[ L: ] [[ \fILUname\fP [, \fILUname\fP ...]@] \fIhostname\fP [: \fIport\fP ]] 
.SH "DESCRIPTION"
\fBpr3287\fP
opens a telnet connection to an
\s-1IBM\s+1
host, and emulates an \s-1IBM\s+1 3287 printer.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection).
.LP
If the \fIhostname\fP is prefixed with \fBL:\fP, the connection will be made
through an SSL tunnel.
\fBpr3287\fP also supports TELNET START-TLS option negotiation without any
need for command-line options.
.LP
A specific LU name to use may be specified by prepending it to the
\fIhostname\fP
with an
`\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden by appending a
\fIport\fP
to the
\fIhostname\fP
with a colon
`\fB:\fP'.
.SH "OPTIONS"
\fBpr3287\fP
understands the following options:
.TP
\fB\-assoc\fP \fILUname\fP
Causes the session to be associated with the specified
\fILUname\fP.
.TP
\fB\-blanklines\fP
In LU3 formatted mode, print blank lines even if they are all NULLs or control
characters.
(This is a violation of the 3270 printer protocol, but some hosts require it.)
.TP
\fB\-cadir\fP \fIdirectory\fP
Specifies a directory containing CA (root) certificates to use when verifying a
certificate provided by the host.
.TP
\fB\-cafile\fP \fIfilename\fP
Specifies a \s-1PEM\s+1-format file containing CA (root) certificates to use
when verifying a certificate provided by the host.
.TP
\fB\-certfile\fP \fIfilename\fP
Specifies a file containing a certificate to provide to the host, if
requested.
The default file type is \s-1PEM\s+1.
.TP
\fB\-certfiletype\fP \fItype\fP
Specifies the type of the certificate file specified
by \fB\-certfile\fP.
\fIType\fP can be \fBpem\fP or \fBasn1\fP.
.TP
\fB\-chainfile \fIfilename\fP\fP
Specifies a certificate chain file in \s-1PEM\s+1 format, containing a
certificate to provide to the host if requested, as well as one or more
intermediate certificates and the CA certificate used to sign that certificate.
If \fB\-chainfile\fP is specified, it
overrides \fB\-certfile\fP.
.TP
\fB\-charset\fP \fIname\fP
Specifies an alternate host code page (input \s-1EBCDIC\s+1 mapping).
The default maps the U.S. English (037) code page to the
current locale character encoding.
pr3287 generally supports the same host character sets as
x3270.
.TP
\fB\-command\fP \fIcommand\fP
Specifies the command to run for each print job.
The default is \fBlpr\fP.
.TP
\fB\-crlf\fP
Causes newline characters in the output to be expanded to
carriage-return/linefeed sequences.
.TP
\fB\-daemon\fP
Causes
\fIpr3287\fP
to become a daemon (background) process.
.TP
\fB\-eojtimeout\fP \fIseconds\fP
Causes \fIpr3287\fP to complete the print job after \fIseconds\fP seconds
of inactivity.
.TP
\fB\-emflush\fP
Causes \fIpr3287\fP to flush any pending printer output whenever an EM
(End of Medium) order arrives in unformatted 3270 mode.
This can help preserve multi-page output with hosts that do not clear the 3270
buffer between pages.
.TP
\fB\-ignoreeoj\fP
Ignore TN3270E PRINT-EOJ commands, relying on UNBIND commands to indicate
the ends of print jobs.
.TP
\fB\-ffeoj\fP
Causes \fIpr3287\fP to add a FF (formfeed) at the end of each print job.
.TP
\fB\-ffskip\fP
Causes \fIpr3287\fP to ignore a FF (formfeed) order if it occurs
at the top of a page.
.TP
\fB\-ffthru\fP
In SCS mode, causes \fIpr3287\fP to pass FF (formfeed) orders through to the
printer as ASCII formfeed characters, rather than simulating them based on the
values of the MPL (maximum presentation line) and TM (top margin) parameters.
.TP
\fB\-keyfile\fP \fIfilename\fP
Specifies a file containing the private key for the certificate file
(specified via \fB\-certfile\fP or \fB\-chainfile\fP).
The default file type is \s-1PEM\s+1.
.TP
\fB\-keyfiletype\fP \fItype\fP
Specifies the type of the private key file specified
by \fB\-keyfile\fP.
\fIType\fP can be \fBpem\fP or \fBasn1\fP.
.TP
\fB\-keypasswd\fP \fItype\fP:\fIvalue\fP
Specifies the password for the private key file, if it is encrypted.
The argument can be \fBfile\fP:\fIfilename\fP, specifying that the
password is in a file, or \fBstring\fP:\fIstring\fP, specifying the
password on the command-line directly.

.TP
\fB\-proxy \fItype\fP:\fIhost\fP[:\fIport\fP]\fP
Causes \fBpr3287\fP to connect via the specified proxy, instead of
using a direct connection.
The \fIhost\fP can be an IP address or hostname.
The optional \fIport\fP can be a number or a service name.
For a list of supported proxy \fItypes\fP, see \s-1PROXY\s+1
below.
.TP
\fB\-reconnect\fP
Causes \fIpr3287\fP to reconnect to the host, whenever the connection is
broken.
There is a 5-second delay between reconnect attempts, to reduce network
thrashing for down or misconfigured hosts.
.TP
\fB\-trace\fP
Turns on data stream tracing.
Trace information is usually saved in the file
\fB/tmp/x3trc.\fP\fIpid\fP.
.TP
\fB\-tracedir\fP \fIdir\fP
Specifies the directory to save trace files in, instead of \fB/tmp\fP.
.TP
\fB\-trnpre \fIfile\fP\fP
Specifies a file containing data that will be sent to the printer before each
print job.
The file contents are treated as transparent data, i.e., they are not
translated in any way.
.TP
\fB\-trnpost \fIfile\fP\fP
Specifies a file containing data that will be sent to the printer after each
print job.
The file contents are treated as transparent data, i.e., they are not
translated in any way.
.TP
\fB\-v\fP
Display build and version information and exit.
.SH "SIGNALS"
SIGINT, SIGHUP and SIGTERM cause the current print job to be flushed (any
pending data to be printed) and \fIpr3287\fP to exit.
.LP
SIGUSR1 causes the current print job to be flushed without otherwise
affecting the \fIpr3287\fP process.

.SH "PROXY"
The \fB\-proxy\fP option
causes pr3287 to use a proxy server to connect to the host.
The syntax of the option is:
.RS
\fItype\fP:\fIhost\fP[:\fIport\fP]

.RE
The supported values for \fItype\fP are:
.TS
center;
c l c .
T{
.na
.nh
Proxy Type
T}	T{
.na
.nh
Protocol
T}	T{
.na
.nh
Default Port
T}
_
T{
.na
.nh
http
T}	T{
.na
.nh
RFC 2817 HTTP tunnel (squid)
T}	T{
.na
.nh
3128
T}
T{
.na
.nh
passthru
T}	T{
.na
.nh
Sun in.telnet-gw
T}	T{
.na
.nh
none
T}
T{
.na
.nh
socks4
T}	T{
.na
.nh
SOCKS version 4
T}	T{
.na
.nh
1080
T}
T{
.na
.nh
socks5
T}	T{
.na
.nh
SOCKS version 5 (RFC 1928)
T}	T{
.na
.nh
1080
T}
T{
.na
.nh
telnet
T}	T{
.na
.nh
No protocol (just send \fBconnect\fP \fIhost port\fP)
T}	T{
.na
.nh
none
T}
.TE
.LP
The special types \fBsocks4a\fP and \fBsocks5d\fP can also be used to force
the proxy server to do the hostname resolution for the SOCKS protocol.
.SH "SEE ALSO"
x3270(1), c3270(1), telnet(1), tn3270(1)
.br
Data Stream Programmer's Reference, IBM GA23\-0059
.br
Character Set Reference, IBM GA27\-3831
.br
3174 Establishment Controller Functional Description, IBM GA23\-0218
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
Copyright 1993-2010, Paul Mattes.
.br
Copyright 1990, Jeff Sparkes.
.br
Copyright 1989, Georgia Tech Research Corporation (GTRC), Atlanta, GA
 30332.
.br
All rights reserved.
.LP
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

.TP
*
Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
.TP
*
Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.
.TP
*
Neither the names of Paul Mattes, Jeff Sparkes, GTRC nor the names of
their contributors may be used to endorse or promote products derived
from this software without specific prior written permission.
.LP
THIS SOFTWARE IS PROVIDED BY PAUL MATTES, JEFF SPARKES AND GTRC `AS IS' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL PAUL MATTES, JEFF SPARKES OR GTRC BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
.SH "VERSION"
pr3287 3.3.12ga11
