/*
 * Copyright 2002 Christopher SEKIYA <wileyc@rezrov.net>
 * portions copyright 1997-2000 by Pawel Krawczyk <kravietz@ceti.pl>
 *
 * hdr_check.c  Perform basic sanity checks on received packet.
 */

#include "tacshell.h"

extern u_int8_t sequence_number;

int
tac_check_header(struct tacacs_header * th, int type)
{

	if (th->type != type) {
		fprintf(stderr,
			"tacshell: unrelated reply, type %x, expected %x\n",
			th->type, type);
		return -1;
	} else if ((th->seq_no & 0x01)) {
		fprintf(stderr, "tacshell: odd reply sequence number: %x\n", th->seq_no);
		return -1;
	} else if (ntohl(th->session_id) != session_id) {
		fprintf(stderr,
		 "tacshell: unrelated reply, received %x != sent %x\n",
			ntohl(th->session_id), session_id);
		return -1;
	}
	sequence_number++;
	return 0;		/* header is ok */

}
