/*
 * Copyright 2002,2003 Christopher SEKIYA <wileyc@rezrov.net>
 * portions copyright 1997-2000 by Pawel Krawczyk <kravietz@ceti.pl>
 */

#include "tacshell.h"

#include <pwd.h>

extern char *user;

int
main(int argc, char **argv)
{
	struct passwd  *passwd_entry;

	parse_config();

	passwd_entry = getpwuid(geteuid());
	if (!passwd_entry) {
		fprintf(stderr, "tacshell: you do not exist.  go away.\n");
		cleanup();
		return (1);
	}
	user = malloc(strlen(passwd_entry->pw_name) + 2);
	snprintf(user, strlen(passwd_entry->pw_name) + 1, passwd_entry->pw_name);

	if ( (authenticate(user)) == 0)
		system(user_shell);

	cleanup();
	return (0);
}
