[comment {-*- tcl -*- doctools manpage}]
[manpage_begin pt::peg::export n 1]
[include include/module.inc]
[titledesc {PEG Export}]
[require snit]
[require configuration]
[require pt::peg]
[require pluginmgr]
[require pt::peg::export [opt 1]]
[description]
[include include/ref_intro.inc]

This package provides a manager for parsing expression grammars, with
each instance handling a set of plugins for the export of them to
other formats, i.e. their conversion to, for example [term nroff],
[term HTML], etc.

[para]

It resides in the Export section of the Core Layer of Parser Tools,
and is one of the three pillars the management of parsing expression
grammars resides on.

[para][image arch_core_export][para]

The other two pillars are, as shown above

[list_begin enum]
[enum] [manpage {PEG Import}], and
[enum] [manpage {PEG Storage}]
[list_end]

[para]

For information about the data structure which is the major input to
the manager objects provided by this package see the section
[sectref {PEG serialization format}].

[para]

The plugin system of this class is based on the package
[package pluginmgr], and configured to look for plugins using

[list_begin enum]
[enum] the environment variable [var GRAMMAR_PEG_EXPORT_PLUGINS],
[enum] the environment variable [var GRAMMAR_PEG_PLUGINS],
[enum] the environment variable [var GRAMMAR_PLUGINS],
[enum] the path [file {~/.grammar/peg/export/plugin}]
[enum] the path [file {~/.grammar/peg/plugin}]
[enum] the path [file {~/.grammar/plugin}]
[enum] the path [file {~/.grammar/peg/export/plugins}]
[enum] the path [file {~/.grammar/peg/plugins}]
[enum] the path [file {~/.grammar/plugins}]
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\GRAMMAR\PEG\EXPORT\PLUGINS"
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\GRAMMAR\PEG\PLUGINS"
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\GRAMMAR\PLUGINS"
[list_end]

The last three are used only when the package is run on a machine
using the Windows(tm) operating system.

[para]

The whole system is delivered with three predefined export plugins,
namely

[list_begin definitions]
[def container] See [manpage {PEG Export Plugin. To CONTAINER format}] for details.
[def json]      See [manpage {PEG Export Plugin. To JSON format}] for details.
[def peg]       See [manpage {PEG Export Plugin. To PEG format}] for details.
[list_end]

[para]

For readers wishing to write their own export plugin for some format,
i.e. [term {plugin writer}]s, reading and understanding the
[manpage {Parser Tools Export API}] specification is an absolute
necessity, as it documents the interaction between this package and
its plugins in detail.


[section API]
[subsection {Package commands}]

[list_begin definitions]

[call [cmd ::pt::peg::export] [arg objectName]]

This command creates a new export manager object with an associated
Tcl command whose name is [arg objectName]. This [term object] command
is explained in full detail in the sections [sectref {Object command}]
and [sectref {Object methods}]. The object command will be created
under the current namespace if the [arg objectName] is not fully
qualified, and in the specified namespace otherwise.

[list_end]


[subsection {Object command}]

All objects created by the [cmd ::pt::peg::export] command have
the following general form:

[list_begin definitions]

[call [cmd objectName] [method method] [opt [arg "arg arg ..."]]]

The method [method method] and its [arg arg]'uments determine the
exact behavior of the command.

See section [sectref {Object methods}] for the detailed
specifications.

[list_end]


[subsection {Object methods}]

[list_begin definitions]

[call [arg objectName] [method destroy]]

This method destroys the object it is invoked for.


[call [arg objectName] [method {export serial}] [arg serial] [opt [arg format]]]

This method takes the canonical serialization of a parsing expression
grammar stored in [arg serial] and converts it to the specified
[arg format], using the export plugin for the format. This will fail
with an error if no plugin could be found for the format.

The string generated by the conversion process is returned as
the result of this method.

[para]

If no format is specified the method defaults to [const text].

[para]

The specification of what a [term canonical] serialization is can be
found in the section [sectref {PEG serialization format}].

[para]

The plugin has to conform to the interface documented in the
[manpage {Parser Tools Export API}] specification.


[call [arg objectName] [method {export object}] [arg object] [opt [arg format]]]

This method is a convenient wrapper around the [method {export serial}]
method described by the previous item.

It expects that [arg object] is an object command supporting a
[method serialize] method returning the canonical serialization of a
parsing expression grammar. It invokes that method, feeds the result
into [method {export serial}] and returns the resulting string as its
own result.


[call [arg objectName] [method {configuration names}]]

This method returns a list containing the names of all configuration
options currently known to the object.


[call [arg objectName] [method {configuration get}]]

This method returns a dictionary containing the names and values of
all configuration options currently known to the object.


[call [arg objectName] [method {configuration set}] [arg name] \
     [opt [arg value]]]

This method sets the configuration option [arg name] to the
specified [arg value] and returns the new value of the option.

[para]

If no value is specified it simply returns the current value, without
changing it.

[para]

Note that these configuration options and their values are simply
passed to a plugin when the actual export is performed. It is the
plugin which checks the validity, not the manager.


[call [arg objectName] [method {configuration unset}] [arg pattern]...]

This method unsets all configuration options matching the specified
glob [arg pattern]s. If no pattern is specified it will unset all
currently defined configuration options.


[list_end]


[include include/serial/pegrammar.inc]
[include include/serial/pexpression.inc]
[include include/feedback.inc]
[manpage_end]
