#!/usr/bin/perl -w
#
# $Id: batch.pl,v 1.4 2000/06/29 05:48:45 kjc Exp $
#
#  usage: batch.pl file [file2 ...]
#
#	batch.pl reads an tcpdump trace files and creates:
#		- a trace file with IP addresses scrambled using tcpdpriv
#		- a html file for the scrambled file using tcpdstat, fly
#		  and other scripts.
#	then updates index.html.
# 	input files can be gzipped format.
#
umask(002);

$statfile = "stat.out";

$toolpath = ".";
if ($0 =~ /(.*)\/.*/) {
    $toolpath = $1;
}

while ($file = shift @ARGV) {
    unless (-r $file) { die "Can't read $file!\n"; }

    print "processing $file ...\n";

    # if the suffix is ".gz", the dumpfile is gzipped
    $gzipped = 0;
    if ($file =~ /.*\.gz$/) {
	print "using gzipped file: $file \n";
	$gzipped = 1;
    }

    # find an Id (using "-c 1" for tcpdstat)
    $id = 0;
    if ($gzipped) {
	open(FOO,"gzip -dc $file | $toolpath/../bin/tcpdstat -c 1 |");
    }
    else {
	open(FOO,"$toolpath/../bin/tcpdstat -c 1 $file |");
    }
    while(<FOO>) {
	if (/^Id:\s*(\w+)/) {
	    $id = $1;
	}
    }
    close(FOO);

    unless ($id) { die "Can't find id!\n"; }
    print "using Id: $id\n";

    # scrambled file name is "<id>.dump"
    $scrambled = $id . ".dump";
    if ($gzipped) {
	system "gzip -dc $file | $toolpath/../bin/tcpdpriv -r - -w $scrambled";
    }
    else {
	system "$toolpath/../bin/tcpdpriv -r $file -w $scrambled";
    }
    print "collecting stat info...\n";

    $tmpfile = "stat." . $id;
    $pktfile = $id . ".pktlen.txt";
    system "$toolpath/../bin/tcpdstat -w $pktfile $scrambled > $tmpfile";

    print "gzipping the scrambled file...\n";
    system "gzip -f $scrambled";

    print "making html files...\n";

    system "$toolpath/mkhtml.pl < $tmpfile";
    system "$toolpath/barchart.pl < $tmpfile";
    system "mv $tmpfile $statfile";

    # make packet size distribution graph
    $percentile =  $id . ".pctl";
    system "$toolpath/pktcumul.pl $pktfile > $percentile";
    system "$toolpath/pktsize.pl $percentile";
    unlink $percentile;
}

print "remaking index.html\n";

system "$toolpath/mkindex.pl";

print "all done\n";
exit 0;
