#!/usr/bin/perl -w
#
# create a graph by gnuplot using a given packet size distribution file
#
# $Id: pktsize.pl,v 1.2 2000/06/30 11:17:09 kjc Exp kjc $
#

umask(002);

$plotcmd =  "tmp.plot";

while ($file = shift @ARGV) {
    unless (-r $file) { die "Can't read $file!\n"; }

    $pngfile = "tmp.pktlen.png";
    if ($file =~ /(.*?)\./) {
	$pngfile = $1 . ".pktlen.png";
    }

    open(HOUT,"> $plotcmd");
    print HOUT "set terminal png small color\n";
    print HOUT "set size 0.75,0.75\n";
    print HOUT "set output '"  . $pngfile . "'\n";
    print HOUT "set xlabel 'Packet Size (bytes)'\n";
    print HOUT "set ylabel 'Cumulative Percentage'\n";
    print HOUT "set key left\n";
    print HOUT "plot '" . $file . "' using 1:2 title 'packets' with lines, '" . $file . "' using 1:3 title 'bytes' with lines\n";
    close(HOUT);

    system "/usr/local/bin/gnuplot $plotcmd";

    unlink $plotcmd;
}
exit 0;
