#!/usr/local/bin/perl
#$Id: dictionary_converter.pl,v 1.5 2000/08/18 17:35:58 tom Exp $
################################################################

use strict;

my ($number, $cmd_number, $tab2_number)
my @input;

################
# Ƚ
while(<>){
    push(@input, $_);

    if (/^WORD\s/ || /^PRONOUNCE/){
	$cmd_number++;
    }
    if (/\t/ == 2){
	$tab2_number++;
    }
    unless (/^$/ || /^\#/){
	$number++;
    }
}
my $is_new_format;
if ($cmd_number){           # WORD, PRONOUNCE ʹԤĤǤ⤢
    if ($tab2_number/$number < .8){
	$is_new_format = 1;
    }
} else {                    # ʤе
    $is_new_format = 0;
}
################
if ($is_new_format){
    print STDERR "allready new format.\n";

    print @input;
} else {
    my $line = "# UseTdfFormat\n";
    for (@input){
	if (/^#/ || /^$/) {
	    $line .= $_;
	    next;
	}
	my ($word, $pronounce, $html) = split("\t");
	print "WORD $word\nPRONOUNCE $pronounce\n$html\n";
    }
}

# end of dictionary_converter.pl
