package TDS::DirInfo;
# $Id: DirInfo.pm,v 1.14 2000/12/15 11:44:38 tom Exp $
################################################################

use strict;
use vars qw(@ISA @EXPORT
	    $WebDiaryDir $CustomizeDir $DiaryDir $DataDir $ConfDir);
use Exporter;

use ObjectTemplate;

@ISA = qw(ObjectTemplate);
@EXPORT = qw(attributes
	     GetDiaryDir GetDataDir GetConfDir GetWebDiaryDir
	     GetCustomizeDir GetStyleDir
	     GetDataPathname GetConfFilename);

attributes qw();

################################################################
{
    # these are default value. so should be updated by conf.ph
    $WebDiaryDir = "/home/foo/public_html/diary" unless defined $WebDiaryDir;
    $CustomizeDir = "/home/foo/diary/custom" unless defined $CustomizeDir;
    $DiaryDir = "/home/foo/diary" unless defined $DiaryDir;
    $DataDir = "$DiaryDir/dat" unless defined $DataDir;
    $ConfDir = "$DiaryDir/conf" unless defined $ConfDir;
}
# static function
sub SetDirs
{
    # if you can use File::Spec, absolutize diary_dir based on web_diary_dir.
    # if diary_dir is allready absolute, do nothing.
#    $DiaryDir = FileSpec->rel2abs($DiaryDir, $WebDiaryDir);
#    die $DiaryDir;
    # set default of DataDir and ConfDir
    $DataDir = "$DiaryDir/dat";
    $ConfDir = "$DiaryDir/conf";
#    die "$DataDir, $ConfDir";
}
sub GetDiaryDir
{
    return $DiaryDir;
}
sub GetDataDir
{
    return $DataDir;
}
sub GetConfDir
{
    return $ConfDir;
}
sub GetWebDiaryDir
{
    return $WebDiaryDir;
}
sub GetCustomizeDir
{
    return $CustomizeDir;
#    return FileSpec->rel2abs($CustomizeDir, $WebDiaryDir);
}
sub GetStyleDir()
{
    my $style;
    if ($style = TDS::Style::GetStyleName()){
	return GetWebDiaryDir() . "/styles/$style";
    } else {
	return GetCustomizeDir();
    }
}
################################################################
sub GetDataPathname($)
{
    my $filename = shift;
    return "$DataDir/$filename";
}
sub GetConfFilename($)
{
    my $filename = shift;
    return "$ConfDir/$filename";
}
    
1;

