package Template;
# $Id: Template.pm,v 1.1.1.1 2000/01/25 17:00:55 tom Exp $
################################################################

=head1 NAME

Template - template expander

=head1 SYNOPSIS

 use Template;

 $cmd_name = "NEW";
 print Expand("command is %c.", {c=>$cmd_name});

 or

 $teml = new Template;
 $templ->SetTemplate("command is %c.");
 $templ->SetParamValues(c=>$cmd_name);
 print $templ->Expand;

=cut

################################################################

use strict;
use ObjectTemplate;
use Exporter;
use vars qw(@ISA @EXPORT);

@ISA = qw(ObjectTemplate);
@EXPORT = qw(Expand);

attributes qw(params template);

sub initialize($)
{
    my $self = shift;
    $self->params({});
}
sub SetTemplate($$)
{
    my ($self, $template) = @_;
    $self->template($template);
}
sub SetParamValues($%)
{
    my ($self, %parameters) = @_;

    while (my ($k, $v) = each(%parameters)){
	$self->params->{$k} = $v;
    }
}

=head2 Expand($template, $params);

=head2 $templ->Expand;

ƥץ졼Ȥѥ᡼˽Ÿ

=cut

sub Expand($$;$)
{
    my ($self, $template, $params) = @_;

    # ᥽åɴؿʤ
    if (ref $self ne 'Template'){
	$params = $template;
	$template = $self;
    } else {
	$template ||= $self->template;
	$params ||= $self->params;
    }

    $template =~ s/%%/\34/g;
    $template =~ s/%{?([A-Za-z0-9_]+)}?/$$params{$1}/g;
    $template =~ s/\34/%/g;
    return $template;
}
1;
