# NOTE: Derived from web_diary_dir/lib/DateTime/Date.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package DateTime::Date;

#line 330 "web_diary_dir/lib/DateTime/Date.pm (autosplit into web_diary_dir/lib/auto/DateTime/Date/GetParams.al)"
################################################################


sub GetParams($$)
{
    my ($self, $params) = @_;
    $params->{year} = $params->{Year} = $params->{'y'} = $params->{'Y'} =
	sprintf("%d", $self->year);
    $params->{month} = $params->{Month} = $params->{'m'} = $params->{'M'} =
	sprintf("%d", $self->month);
    $params->{day} = $params->{Day} = $params->{'d'} = $params->{'D'} = 
	sprintf("%d", $self->day);
    $params->{month_abbr} = $MonthString{'ABBR'}->[$self->month];
    
    $params->{'part'} = $self->part;
    $params->{week} = $params->{w} = $WeekString{'ABBR'}->[$self->week];
    $params->{Week} = $params->{W} = $WeekString{'JAPANESE'}->[$self->week];
    if ($self->IsHolyday){
	$params->{week_holy} = Expand($WeekHolydayTemplate,
				      {w=>$params->{week}});

	$params->{Week_holy} = Expand($WeekHolydayTemplate,
				      {w=>$params->{Week}});
    } elsif ($self->week == 6){    # Saturday
	$params->{week_holy} = Expand($WeekSaturdayTemplate,
				      {w=>$params->{week}});
	
	$params->{Week_holy} = Expand($WeekSaturdayTemplate,
				      {w=>$params->{Week}});
    } else {
	$params->{week_holy} = $params->{week};
	$params->{Week_holy} = $params->{Week};
    }
    $params->{'0m'} = sprintf("%02d", $self->month);
    $params->{'0d'} = sprintf("%02d", $self->day);
    $params->{'high'} = sprintf("%1d", int($self->day/10));
    $params->{W} = $WeekString{'JAPANESE'}->[$self->week];

    if (1){
	$params->{Year} =~ s/(\d)/$digit_array[$1]/eg;
	$params->{Month} =~ s/(\d)/$digit_array[$1]/eg;
	$params->{Day} =~ s/(\d)/$digit_array[$1]/eg;

	$params->{Y} =~ s/(\d)/$digit_array[$1]/eg;
	$params->{M} =~ s/(\d)/$digit_array[$1]/eg;
	$params->{D} =~ s/(\d)/$digit_array[$1]/eg;

    } else {
	eval "require 'jcode.pl'";
	unless ($@){
	    &jcode::tr(\$params->{Year}, "0123456789", "");
	    &jcode::tr(\$params->{Month}, "0123456789", "");
	    &jcode::tr(\$params->{Day}, "0123456789", "");    
	    &jcode::tr(\$params->{Y}, "0123456789", "");
	    &jcode::tr(\$params->{M}, "0123456789", "");
	    &jcode::tr(\$params->{D}, "0123456789", "");
	}
    }
    return $params;
}

# end of DateTime::Date::GetParams
1;
