.\" DO NOT MODIFY THIS FILE!  It was generated by help2man 1.40.9.
.TH UPDMAP "1" "June 2012" "TeX Live" "User Commands"
.SH NAME
updmap \- manage TeX font maps, per-user
.br
updmap-sys \- manage TeX font maps, system-wide
.SH SYNOPSIS
.B updmap
[\fIOPTION\fR] ... [\fICOMMAND\fR]
.br
.B updmap-sys
[\fIOPTION\fR] ... [\fICOMMAND\fR]
.SH DESCRIPTION
updmap (TeX Live, multi) version $Id: updmap.pl 26778 2012\-06\-01 17:36:30Z karl $
.PP
Update the default font map files used by pdftex, dvips, and dvipdfm(x),
and optionally pxdvi, as determined by all configuration files updmap.cfg
(the ones returned by running "kpsewhich \fB\-\-all\fR updmap.cfg", but see below).
.PP
Among other things, these map files are used to determine which fonts
should be used as bitmaps and which as outlines, and to determine which
font files are included in the PDF or PostScript output.
.PP
By default, the TeX filename database (ls\-R) is also updated.
.SH OPTIONS
.TP
\fB\-\-cnffile\fR FILE
read FILE for the updmap configuration
(can be given multiple times, in which case
all the files are used)
.TP
\fB\-\-dvipdfmxoutputdir\fR DIR
specify output directory (dvipdfm(x) syntax)
.TP
\fB\-\-dvipsoutputdir\fR DIR
specify output directory (dvips syntax)
.TP
\fB\-\-pdftexoutputdir\fR DIR
specify output directory (pdftex syntax)
.TP
\fB\-\-pxdvioutputdir\fR DIR
specify output directory (pxdvi syntax)
.TP
\fB\-\-outputdir\fR DIR
specify output directory (for all files)
.TP
\fB\-\-copy\fR
cp generic files rather than using symlinks
.TP
\fB\-\-force\fR
recreate files even if config hasn't changed
.TP
\fB\-\-nomkmap\fR
do not recreate map files
.TP
\fB\-\-nohash\fR
do not run texhash
.TP
\fB\-n\fR, \fB\-\-dry\-run\fR
only show the configuration, no output
.TP
\fB\-\-quiet\fR, \fB\-\-silent\fR
reduce verbosity
.SS "Commands:"
.TP
\fB\-\-help\fR
show this message and exit
.TP
\fB\-\-version\fR
show version information and exit
.TP
\fB\-\-showoption\fR OPTION
show the current setting of OPTION
.TP
\fB\-\-showoptions\fR OPTION
show possible settings for OPTION
.TP
\fB\-\-setoption\fR OPTION VALUE
set OPTION to value; option names below
.TP
\fB\-\-setoption\fR OPTION=VALUE
as above, just different syntax
.TP
\fB\-\-enable\fR MAPTYPE MAPFILE
add "MAPTYPE MAPFILE" to updmap.cfg,
where MAPTYPE is Map, MixedMap, or KanjiMap
.TP
\fB\-\-enable\fR Map=MAPFILE
add "Map MAPFILE" to updmap.cfg
.HP
\fB\-\-enable\fR MixedMap=MAPFILE add "MixedMap MAPFILE" to updmap.cfg
.HP
\fB\-\-enable\fR KanjiMap=MAPFILE add "KanjiMap MAPFILE" to updmap.cfg
.TP
\fB\-\-disable\fR MAPFILE
disable MAPFILE, of whatever type
.TP
\fB\-\-listmaps\fR
list all active and inactive maps
.TP
\fB\-\-listavailablemaps\fR
same as \fB\-\-listmaps\fR, but without
unavailable map files
.TP
\fB\-\-syncwithtrees\fR
disable unavailable map files in updmap.cfg
.PP
Explanation of the map types: the (only) difference between Map and
MixedMap is that MixedMap entries are not added to psfonts_pk.map.
The purpose is to help users with devices that render Type 1 outline
fonts worse than mode\-tuned Type 1 bitmap fonts.  So, MixedMap is used
for fonts that are available as both Type 1 and Metafont.
KanjiMap entries are added to psfonts_t1.map and kanjix.map.
.PP
Explanation of the OPTION names for \fB\-\-showoptions\fR, \fB\-\-showoptions\fR, \fB\-\-setoption\fR:
.TP
dvipsPreferOutline
true|false  (default true)
.IP
Whether dvips uses bitmaps or outlines, when both are available.
.TP
dvipsDownloadBase35
true|false  (default true)
.IP
Whether dvips includes the standard 35 PostScript fonts in its output.
.TP
pdftexDownloadBase14
true|false   (default true)
.IP
Whether pdftex includes the standard 14 PDF fonts in its output.
.TP
pxdviUse
true|false  (default false)
.IP
Whether maps for pxdvi (Japanese\-patched xdvi) are under updmap's control.
.TP
kanjiEmbed
(any string)
.TP
kanjiVariant
(any string)
.IP
See below.
.TP
LW35
URWkb|URW|ADOBEkb|ADOBE  (default URWkb)
.IP
Adapt the font and file names of the standard 35 PostScript fonts.
URWkb    URW fonts with "berry" filenames    (e.g. uhvbo8ac.pfb)
URW      URW fonts with "vendor" filenames   (e.g. n019064l.pfb)
ADOBEkb  Adobe fonts with "berry" filenames  (e.g. phvbo8an.pfb)
ADOBE    Adobe fonts with "vendor" filenames (e.g. hvnbo___.pfb)
.IP
These options are only read and acted on by updmap; dvips, pdftex, etc.,
do not know anything about them.  They work by changing the default map
file which the programs read, so they can be overridden by specifying
command\-line options or configuration files to the programs, as
explained at the beginning of updmap.cfg.
.IP
The options kanjiEmbed and kanjiVariant specify special replacements
in the map lines.  If a map contains the string @kanjiEmbed@, then
this will be replaced by the value of that option; similarly for
kanjiVariant.  In this way, users of Japanese TeX can select different
fonts to be included in the final output.
.SH ENVIRONMENT
.PP
Explanation of trees and files normally used:
.IP
If \fB\-\-cnffile\fR is specified on the command line (possibly multiple
times), its value(s) are used.  Otherwise, updmap reads all the
updmap.cfg files found by running `kpsewhich \fB\-all\fR updmap.cfg',
in the order returned by kpsewhich.  If multiple updmap.cfg files are
found, all the maps mentioned in all the updmap.cfg files are merged.
.IP
There is one exception to keep upgradability from earlier versions of
TeX Live: if a file TEXMFLOCAL/web2c/updmap\-local.cfg exists (formerly
used by tlmgr to merge local fonts), then the file
TEXMFLOCAL/web2c/updmap.cfg is ignored (if it exists) and the
updmap\-local.cfg is used instead.  In this case, updmap recognizes the
previous syntax for disabling map files in updmap\-local.cfg (this
syntax is different from what is used now).
.IP
According to the actions, updmap might write to one of the given files
or create a new updmap.cfg, described further below.
.IP
Where changes are saved: if config files are given on the command
line, then the first one given will be used to save any changes from
\fB\-\-setoption\fR, \fB\-\-enable\fR or \fB\-\-disable\fR.  If the config files are taken
from kpsewhich output, then the algorithm is more complex:
.IP
1) If $TEXMFHOME/web2c/updmap.cfg or $TEXMFCONFIG/web2c/updmap.cfg
appears in the list of used files, then the one listed first by
kpsewhich \fB\-\-all\fR (equivalently, the one returned by kpsewhich
updmap.cfg), is used.
.IP
2) If neither of the above two are present and changes are made, a
new config file is created in $TEXMFCONFIG/web2c/updmap.cfg.
.IP
Multiple definitions of a font:
.IP
If a font is defined in more than one map file, then the definition
coming from the first\-listed updmap.cfg is used.  If a font is
defined multiple times in the same map file, one is chosen
arbitrarily.  In both cases a warning is issued.
.IP
Disabling maps:
.IP
updmap.cfg files with higher priority (listed earlier) can disable
maps mentioned in lower priority (listed later) updmap.cfg files by
writing, e.g.,
.IP
#! Map mapname.map
.IP
or
.IP
#! MixedMap mapname.map
.IP
in the higher\-priority updmap.cfg file.
.IP
As an example, suppose you have a copy of MathTime Pro fonts
and want to disable the Belleek version of the fonts; that is,
disable the map belleek.map.  You can create the file
$TEXMFCONFIG/web2c/updmap.cfg with the content
.IP
#! Map belleek.map
Map mt\-plus.map
Map mt\-yy.map
.IP
and call updmap.
.IP
updmap writes the map files for dvips (psfonts.map) and pdftex
(pdftex.map) to the TEXMFVAR/fonts/map/updmap/{dvips,pdftex}/
directories.
.IP
The log file is written to TEXMFVAR/web2c/updmap.log.
.IP
When updmap\-sys is run, TEXMFSYSCONFIG and TEXMFSYSVAR are used
instead of TEXMFCONFIG and TEXMFVAR, respectively.  This is the only
difference between updmap\-sys and updmap.
.IP
Other locations may be used if you give them on the command line, or
these trees don't exist, or you are not using the original TeX Live.
.IP
To see the precise locations of the various files that
will be read and written, give the \fB\-n\fR option (or read the source).
.SH EXAMPLES
.PP
For step\-by\-step instructions on making new fonts known to TeX, read
http://tug.org/fonts/fontinstall.html.  For even more terse
instructions, read the beginning of updmap.cfg.
.SH FILES
Configuration and input files:
.IP "\fIupdmap\&.cfg\fP"
Main configuration file\&.  In
\fItexmf/web2c\fP by default, but may be located elsewhere
depending on your distribution\&.  Each texmf tree read should have its
own \fIupdmap.cfg\fP.
.IP "\fIdvips35\&.map\fP"
Map file for standard 35 PostScript fonts for
use with \fBdvips\fP(1)\&.
.IP "\fIpdftex35\&.map\fP"
Map file for standard 35 PostScript fonts for
use with \fBpdftex\fP(1)\&.
.IP "\fIps2pk35\&.map\fP"
Map file for standard 35 PostScript fonts for
use with \fBps2pk\fP(1)\&.
.PP
Output files:
.IP "\fIpsfonts\&.map\fP"
For \fBdvips\fP(1)\&.
Same as \fIpsfonts_t1\&.map\fP if option \fBdvipsPreferOutline\fP active,
else as \fIpsfonts_pk\&.map\fP.
.IP "\fIpsfonts_pk\&.map\fP"
For \fBdvips\fP(1)\&.
Without information from MixedMap files\&.
(Setting of \fBdvipsPreferOutline\fP ignored\&.)
.IP "\fIpsfonts_t1\&.map\fP"
For \fBdvips\fP(1)\&.
With information from MixedMap files\&.
(Setting of \fBdvipsPreferOutline\fP ignored\&.)
.IP "\fIdownload35\&.map\fP"
For \fBdvips\fP(1)\&.
Always downloads the standard 35 fonts\&.
(Setting of \fBdvipsDownloadBase35\fP ignored\&.)
.IP "\fIbuiltin35\&.map\fP"
For \fBdvips\fP(1)\&.
Never downloads the standard 35 fonts\&.
(Setting of \fBdvipsDownloadBase35\fP ignored\&.)
.IP "\fIpdftex\&.map\fP"
For \fBpdftex\fP(1)\&.
Same as \fIpdftex_dl14\&.map\fP if option \fBpdftexDownloadBase14\fP active,
else as \fIpdftex_ndl14\&.map\fP.
.IP "\fIpdftex_dl14\&.map\fP"
For \fBpdftex\fP(1)\&.
Always downloads the standard 14 fonts\&.
.IP "\fIpdftex_ndl14\&.map\fP"
For \fBpdftex\fP(1)\&.
Never downloads the standard 14 fonts\&.
.IP "\fIps2pk\&.map\fP"
Similar to \fIpsfonts.map\fP file, but
forces all fonts to be downloaded, so this map file can be used with
\fBxdvi\fP(1) and \fBps2pk\fP(1)\&.
.PP
Configuration files for \fBdvips\fP(1):
.IP "\fIconfig\&.builtin35\fP"
Loads \fIbuiltin35\&.map\fP instead
of \fIpsfonts\&.map\fP\&.
.IP "\fIconfig\&.download35\fP"
Loads \fIdownload35\&.map\fP instead
of \fIpsfonts\&.map\fP\&.
.IP "\fIconfig\&.outline\fP"
Loads \fIpsfonts_t1\&.map\fP instead
of \fIpsfonts\&.map\fP\&.
.IP "\fIconfig\&.pdf\fP"
Loads \fIpsfonts_t1\&.map\fP instead
of \fIpsfonts\&.map\fP and has additional optimizations for PDF generation\&.
.IP "\fIconfig\&.pk\fP"
Loads \fIpsfonts_pk\&.map\fP instead
of \fIpsfonts\&.map\fP\&.
.IP "\fIconfig\&.www\fP"
Loads \fIpsfonts_t1\&.map\fP instead
of \fIpsfonts\&.map\fP\&.
(For compatibility with old versions\&.)
.IP "\fIconfig\&.gstopk\fP"
Loads \fIpsfonts_t1\&.map\fP instead
of \fIpsfonts\&.map\fP\&.
.SH "REPORTING BUGS"
Report bugs to: tex\-k@tug.org
.br
TeX Live home page: <http://tug.org/texlive/>
